//*********************************************************************
//  : MQ6855_UART.c
// 汾     : V1.0 2022/03/02 MQ6855
//      : UART ʹú
// ע     : UART غ㼯ڱӳ
//*********************************************************************

#include "main.h"


unsigned char RX1_DATA,recvCnt;




extern unsigned char recvBuf[10];	

//*********************************************************************
//    : UART1_Init
//  : IO,UARTʼ ***UARTʹP90(TX)P91(RX)
// ע     : ģʽΪNormal1,Normal2
//*********************************************************************
void UART1_Init(void)
{
//====== ѡUART1ʹP90P91֮ܽųʼ ======
//***ʱP26/P27ܵUART1

    P9CR_P1 = 0;                        // 趨P91
    P9CR_P0 = 1;                        // 趨P90
	
    P9FC_P0 = 1;                        // лP90Ϊ⹦ܽ
	
	
	UATCNG_UAT2IO = 0;   				// 趨 P90 P91 ΪUARTڹܽ
    UATCNG_UAT1IO = 0;                  // 0: 趨 P90ΪTX, P91ΪRX
										// 1: 趨 P91ΪTX, P90ΪRX
										
//---------------------------------------------------------------------------------------------------------------

/*
//====== ѡUART1ʹP26P27֮ܽųʼ ======
//***ʱP90/P91ܵUART1
//***ʱP26/P27ܵTCC

//    P2CR_P7 = 0;                        // 趨P27
//    P2CR_P6 = 1;                        // 趨P26
	
//    P2FC_P6 = 1;                        // лP26Ϊ⹦ܽ



//    UATCNG_UAT2IO = 1;                  // 趨 P26 P27 ΪUARTڹܽ	*UARTʹP90P91,δʹõP26P27									
//    UATCNG_UAT1IO = 0;                  // 0: 趨 P26ΪTX, P27ΪRX
//										  // 1: 趨 P27ΪTX, P26ΪRX									
*/

//---------------------------------------------------------------------------------------------------------------


/*
//====== ѡUART0ʹP20P21֮ܽųʼ ======
//    P2CR_P1 = 0;                        // 趨P21
//    P2CR_P0 = 1;                        // 趨P20
	
//    P2FC_P0 = 1;                        // лP20Ϊ⹦ܽ


//	  UATCNG_UAT0IO = 0;				  // 趨 P20 P21 ΪUARTڹܽ   *UARTʹP90P91,δʹõP20P21
//										  // 0: 趨 P20ΪTX, P21ΪRX
//										  // 1: 趨 P21ΪTX, P20ΪRX	
*/

//---------------------------------------------------------------------------------------------------------------

								

//====== ܿ( Enable) ======

//ʹP90 P91 => UART1	
    POFFCR1_UART1EN = 1;                // ȿݴò  *UARTʹUART1

/*		
//ʹP26 P27 => UART1
    POFFCR1_UART1EN = 1;                // ȿݴò
*/

/*
//ʹP20 P21 => UART0	
    POFFCR1_UART0EN = 1;                // ȿݴò
*/
//====== 趨 ======
	UART1CR1_STOPBT	= 0;				// TXֹͣλ : 1λ
	UART1CR2_STOPBR	= 0;				// RXֹͣλ : 1λ
	UART1CR1_PE		= 0;				// żУλ	
	UART1CR1_BRG	= 0;				// 0: շʱ = fcgck
										// 1: շʱ = TCA0  (ɴɼBaud rate)

//------ Baud rate 趨= 9600 -------   
//--- fcgck @ 16MHz
/* 
    UART1CR2_RTSEL = 0x01;
    UART1DR        = 0x64;
 */
 
//--- fcgck @ 8MHz
/* 
    UART1CR2_RTSEL = 0x00;
    UART1DR        = 0x33;
 */

//*** fcgck @ 4MHz                      *ʹBaud rate = 9600,fcgck @ 4MHz
    UART1CR2_RTSEL = 0x00;
    UART1DR        = 0x19;
    
//--- fcgck @ 2MHz
/* 
    UART1CR2_RTSEL = 0x00;
    UART1DR        = 0x0c;
*/	
//------ Baud rate 趨= 115200 -----
//--- fcgck @ 16MHz
/* 
    UART1CR2_RTSEL = 0x03;
    UART1DR        = 0x08;
 */
//--- fcgck @ 8MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x03;
 */
//--- fcgck @ 4MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x01;
 */
//--- fcgck @ 2MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x00;
 */

}


//*********************************************************************
//    : UART1_Start
//  : UART
// ע     :
//*********************************************************************
void UART1_Start(void)
{
    UART1CR1_TXE = 1;                   //  TX
    UART1CR1_RXE = 1;                   //  RX
}


//*********************************************************************
//    : UART1_Stop
//  : ֹͣUART
// ע     :
//*********************************************************************
void UART1_Stop(void)
{
    UART1CR1_TXE = 0;                   // ֹͣ TX
    UART1CR1_RXE = 0;                   // ֹͣ RX
}


//*********************************************************************
//    : UART1_IntEnable
//  : UARTж
// ע     : ִкῪж(IMF)
//*********************************************************************
void UART1_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
/*    
  	IL_INTTXD1      = 0;                // TXж
  	EI_INTTXD1      = 1;                // 趨TXж
*/
    IL_INTRXD1      = 0;                // RXж
    EI_INTRXD1      = 1;                // 趨RXж
    EI;                                 // пж // EIRL_IMF=1
}


//*********************************************************************
//    : UART1_IntDisable
//  : ֹUARTж
// ע     : ִкῪж(IMF)
//*********************************************************************
void UART1_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
/*   
	 IL_INTTXD1      = 0;               // TXж
	 EI_INTTXD1      = 0;               // TXж
*/
    IL_INTRXD1      = 0;                // RXж
    EI_INTRXD1      = 0;                // RXж
    EI;                                 // пж // EIRL_IMF=1
}



//*********************************************************************
//    : IntRXD1
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntRXD1(void)
{
	BIT_LIST_8 uart_flag;
	
	uart_flag.byte = UART1SR;			//get flag data

										//                bit7  bit6  bit5	bit4  bit3  bit2  bit1  bit0
	 									// get flag data [PERR, FERR, OERR,   -,  RBSY, RBFL, TBSY, TBFL]
                                        // PERR    żУ   0: żУ
                                        //                            1: żУ
                                        // RFERR   շ     0: շ
                                        //                            1: շ
                                        // OERR           0: 
                                        //                            1: 
                                        // RBSY    æµ       0: ǰչ
                                        //                            1: 
                                        // RBFL    ջ 0: ջΪ
                                        //                            1: ջ
                                        // TBSY    æµ       0: ǰ͹
                                        //                            1: 
                                        // TBFL    ͻ 0: ͻΪ
                                        //                            1: ͻ
										
	RX1_DATA = RD1BUF;					// get Rx data and clear UART1SR flag										
	// Error handle
	if(uart_flag.bit.b7 == 1){
										// żУ
	}
	else if(uart_flag.bit.b6 == 1){
										// շ
	}
	else if(uart_flag.bit.b5 == 1){
										// 
	}
	else{
		recvBuf[(recvCnt++)%10]= RX1_DATA;		// No Error, store the data
		
	}
	
	
}





//*********************************************************************
//    : UART1_senddata
//  : UART1 ䷶
// ע     :
//*********************************************************************
void UART1_senddata(uchar* buf,uint length)
{
    uint sendloop;

    for( sendloop = 0; sendloop < length; sendloop++ )
    {
        while( UART1SR_TBFL ==1 )           // ȴͻΪգٴдҪʹ֮
        {
            CLR_WDT;                    // Źʱ (ι)
        }
        
        TD1BUF = buf[sendloop];			// дҪʹ֮
    }

    while( UART1SR_TBSY ==1 )               // ݔ:Set1 , ݔꮅ:set0,ȴ͹
    {
        CLR_WDT;                        // Źʱ (ι)
    }
}























