//***********************************************
//  : MQ6855_16BIT_TCAx.c
// 汾     : V1.0 2022/03/02 MQ6855
//      : 16BIT TCA0 ʹú
// ע     : 16BIT_TCA0 غ㼯ڱӳ
//***********************************************

#include "main.h"




//*********************************************************************
//    : TCA0_Timer_Init
//  : TCA0 ʱģʽʱ 1 ms
// ע     :
//*********************************************************************
void TCA0_Timer_Init(void)
{
//====== ܿ( Enable) ======
    POFFCR0_TCA0EN = 1;                 // ȿݴò

//====== 趨 ======
    TA0MOD_TAM      = 0;                // 趨Ϊ 16 λʱģʽ
    
    TA0MOD_TADBE    = 1;                // ʹ˫
    TA0MOD_TACK     = 2;                // fcgck/4 = 1MHz = 1us
    TA0DRA          = 1000;             // 趨ֵ: ÿ 1000 * 1us = 1ms жһ
}

//*********************************************************************
//    : TCA0_PPG_Init
//  : TCA0(P72) ɱ  1 ms ռձ 50%
// ע     :
//*********************************************************************
void TCA0_PPG_Init(void)
{
//====== ܽųʼ ======
    P7DR_P2         = 1;                // ܽʼ P72ߵƽ **ͬ PPG ĳʼֵ(TA0CR_TATFF)
    P7CR_P2         = 1;                // P72ܽ趨Ϊ

//====== ܿ( Enable) ======
    POFFCR0_TCA0EN  = 1;                // ȿݴò

//====== 趨 ======
    TA0CR_TATFF     = 1;                // 趨ʼֵΪ"׼λ"ռձ

    TA0MOD_TAM      = 3;                // 趨Ϊ 16 λɱ PPG ģʽ
    
    TA0MOD_TADBE    = 1;                // ʹ˫
    TA0MOD_TACK     = 2;                // fcgck/4 = 1MHz = 1us ,λʱ 1us
    TA0DRA          = 1000;             // 趨 PPG  = 1000 * 1us = 1ms
    TA0DRB          = 500;              // 趨 PPG ռձ = 500/1000 = 50%
	
//	***PxFC ùţڳʼֵ趨֮ PxFC
    P7FC_P2         = 1;                // лP72Ϊ⹦ܽ,ܽ趨Ϊ PPG 	
}


//*********************************************************************
//    : TCA0_ExtTrigTimer_Init
//   : TCA0 ⲿ½شʱģʽP72룬ʱ 1 ms
// ע     :
//*********************************************************************
void TCA0_ExtTrigTimer_Init(void)
{
//====== ܽųʼ ======    
    P7CR_P2         = 0;                // P72ܽ趨Ϊ
    P7FC_P2         = 1;                // лP72Ϊ⹦ܽ,
    
//====== ܿ( Enable) ======
    POFFCR0_TCA0EN  = 1;                 // ȿݴò

//====== 趨 ======
    TA0MOD_TAM      = 4;                // 趨Ϊ 16 λⲿʱģʽ
    TA0MOD_TADBE    = 1;                // ʹ˫
    TA0MOD_TAMETT   = 0;                // ʱ
    TA0MOD_TATED    = 1;                // ½ش
    TA0MOD_TACK     = 2;                // fcgck/4 = 1MHz ,λʱ 1us
    TA0DRA          = 1000;             // 趨ֵ: ÿ 1000 * 1us = 1ms жһ
}

//*********************************************************************
//    :  TCA0_Window_Init
//   : TCA0 ģʽP72͵ƽʱߵƽʱֵͣ 10000
//             ʱ 10000 * 1us = 10 ms                                        
// ע     :
//*********************************************************************
void TCA0_Window_Init(void)
{
//====== ܽųʼ ======    
    P7CR_P2         = 0;                // P72ܽ趨Ϊ
    P7FC_P2         = 1;                // лP72Ϊ⹦ܽ,
    
//====== ܿ( Enable) ======
    POFFCR0_TCA0EN  = 1;                 // ȿݴò

//====== 趨 ======
    TA0MOD_TAM      = 5;                // 趨Ϊģʽ
    TA0MOD_TADBE    = 1;                // ʹ˫    
    TA0MOD_TATED    = 1;                // ͵ƽ
    TA0MOD_TACK     = 2;                // fcgck/4 = 1MHz ,λʱ 1us
    TA0DRA          = 10000;            // 趨ֵ: ֵ    10000 
                                        //            ʱ  10000 * 1 us = 10 ms
}           


//*********************************************************************
//    : TCA0_PulseMeasure_Init  //*20190131
//  : TCA0 ģʽλʱ0.5us
//            ߵƽ = 65535 * 0.5us = 32767.5 us
//                   = 65535 * 0.5us = 32767.5 us
// ע     :
//*********************************************************************
void TCA0_PulseMeasure_Init(void)
{
//====== ܽųʼ ======    
    P7CR_P2         = 0;                // P72ܽ趨Ϊ
    P7FC_P2         = 1;                // лP72Ϊ⹦ܽ,
    
//====== ܿ( Enable) ======
    POFFCR0_TCA0EN  = 1;                 // ȿݴò

//====== 趨 ======
    TA0MOD_TAM      = 6;                // 趨Ϊģʽ
    TA0MOD_TACK     = 3;                // fcgck/2 = 2MHz ,λʱ 0.5us   //*20190131  
    TA0MOD_TAMCAP   = 0;                // ˫ץȡ
    TA0MOD_TATED    = 0;                // ش½ؽһץȡ(ص½)
                                        // ʱץȡ(صһ)
}      



//*********************************************************************
//    : TCA0_SetDuty
//  : ֵ
// ע     : 
//*********************************************************************
void set_TCA0_Duty(uint duty)
{
    TA0DRB          = duty;
}


//*********************************************************************
//    : TCA0_SetPeriod
//   : ڼֵ
// ע     : 
//*********************************************************************
void TCA0_SetPeriod(uint period)
{
    TA0DRA          = period;
}


//*********************************************************************
//    : TCA0_Start
//  : TCA0
// ע     :
//*********************************************************************
void TCA0_Start(void)
{
    TA0CR_TAS       = 1;                // ʱ
}


//*********************************************************************
//    : TCA0_Stop
//  : ֹͣTCA0
// ע     :
//*********************************************************************
void TCA0_Stop(void)
{
    TA0CR_TAS       = 0;                // ֹͣʱ
}


//*********************************************************************
//    : TCA0_IntEnable
//  :  TCA0 ж
// ע     : ִкῪж(IMF)
//*********************************************************************
void TCA0_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTTCA0      = 0;                // ж
    EI_INTTCA0      = 1;                // 趨ж
    EI;                                 // пж // EIRL_IMF=1
}



//*********************************************************************
//    : TCA0_IntDisable
//  : ֹ TCA0 ж
// ע     : ִкῪж(IMF)
//*********************************************************************
void TCA0_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    
    EI_INTTCA0      = 0;                // ж
    IL_INTTCA0      = 0;                // ж
    EI;                                 // пж // EIRL_IMF=1
}


//*********************************************************************
//    : TCA0_ReadSingleCapture
//   : ȡֵ
// ע     : ģʽ
//*********************************************************************
uint TCA0_ReadSingleCapture()
{
    return TA0DRB;
}



//*********************************************************************
//    : TCA0_ReadDoubleCapture
//   : ȡ 
// ע     : ˫ץȡģʽ
//*********************************************************************
uint TCA0_ReadDoubleCapture()
{
    return TA0DRA;
}

//*********************************************************************
//    : IntTCA0
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntTCA0(void)
{
    P9DR_P0 = !P9DR_P0;					// 趨P90
    NOP;                                // ָ
}




























