//***********************************************************
//  : main.c
// 汾     : V1.0 2022/03/02 MQ6855
//      : 
// ע     : TBTʱ 0.26214 s ж,жʱP70 
//            P70 LED,۲˸
//***********************************************************
#ifndef IO_MEM
#define IO_MEM
#endif

#include "main.h"

/* ----------------------  ------------------------------ */


/* ----------------------  -------------------------------- */
void main(){
    /* ---------------------- ϵͳʼ ------------------------ */
    SYSTEM_INIT();    

    /* ---------------------- ܳʼ ------------------------ */
    //  TBTжƵ = fcgck / 2^20 = 3.81469 Hz 
    //                = 0.26214 s
    //  P70  TBT жʱ
    TBT_Init();

    TBT_IntEnable();    
    //--------------------------------------------------------------
    TBT_Start();
    //--------------------------------------------------------------    


//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *    
    while(1)
    {
        CLR_WDT;                        // Źʱ (ι)

        NOP;                            // ָ
        NOP;                            // ָ
        NOP;                            // ָ
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


















/*---------------------- жϷ ------------------------*/
void __interrupt OnlyReti(void)
{
    NOP;                                // ָ
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10;    	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}      
/*-----------------  жϷ ------------------------*/

/*------------------------ ж ------------------------*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
    OnlyReti,           // 0xffba : IntTCA2
    OnlyReti,           // 0xffbc : IntTXD2
    OnlyReti,           // 0xffbe : IntRXD2
    OnlyReti,           // 0xffc0 : IntTCC0T
    OnlyReti,           // 0xffc2 : IntTCC0P
    OnlyReti,           // 0xffc4 : IntTC05
    OnlyReti,           // 0xffc6 : IntTC04
    OnlyReti,           // 0xffc8 : IntTCA1
    OnlyReti,           // 0xffca : IntSIO1
    OnlyReti,           // 0xffcc : IntTC03
    OnlyReti,           // 0xffce : IntTC02
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    OnlyReti,           // 0xffd4 : Int5
    OnlyReti,           // 0xffd6 : Int4
    OnlyReti,           // 0xffd8 : Int3 / IntCMP1
    OnlyReti,           // 0xffda : Int2 / IntCMP0 / IntEMG0
    OnlyReti,           // 0xffdc : Int1 / IntCMP2
    OnlyReti,           // 0xffde : Int0 / IntCMP3
    OnlyReti,           // 0xffe0 : IntSBI
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,           // 0xffec : IntLVD
    OnlyReti,           // 0xffee : IntTXD0
    OnlyReti,           // 0xfff0 : IntRXD0
    OnlyReti,           // 0xfff2 : IntSIO0
    IntTBT,             // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI / INTUNDEF
    STARTUP             // 0xfffe : RESET
};
#pragma section const
/*-------------------  ж ------------------------*/

















//*********************************************************************
//    : SYSTEM_INIT(void)
//  : IO, CGCR ʼ P10/P40/P41 ڷʱ֮趨
// ע     :
//*********************************************************************
void SYSTEM_INIT(void)
{
#ifdef _DEBUG   //...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//  (ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//  SET_P10_to_RESET_PIN;
//------------------------------------------------------------------
    FSCTRL_FSSEL = 0;                   // 0ΪĬֵбλ(bit)ڷģʽֶʼΪĬֵ 0
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
    SET_P10_to_IO_PIN;
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG   //...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//   P10/P40/P41  Debug modeڷʱ趨Ϊ룬
//  ԱӰ漰¼.
    P1DR = 0x00;
    P1CR = set8bit(11111110);           //  P10 Ϊ
    P4DR = 0x00;
    P4CR = set8bit(11111100);           //  P40/P41 Ϊ
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;
    P5DR = 0x00;
    P5CR = 0xff;
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;

    CLR_WDT;                            // Źʱ (ι)
}



//*********************************************************************
//    : delay_times
//  : ʱ
// ע     : ==> t_1ms   = 0;          // ӳʱ䵥λ ms
//          : ==> t_100us = 1;          // ӳʱ䵥λ usϴ
//          : ɹ̶Ȧʱһʱ䣬ʹ÷£
//          : delay_times(t_1ms, 800);  // ӳ 800ms
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
    uint  i, cgcrT;

//  uchar cgcrF[4]={ 2, 4,  8, 1 };     // پƵΪ  8MHz ʱʹô
    uchar cgcrF[4]={ 4, 8, 16, 2 };     // پƵΪ 16MHz ʱʹô

//  ϵͳڸʱ(ͨ1ͨ2ģʽ) ʱ
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  ϵͳڵʱ(12ģʽ) ʱϴ󣬲οʹã
    else for(; x>0; x--){}

    CLR_WDT;                            // Źʱ (ι)
}




