//***********************************************
//  : MQ6855_SIO_Slave.c
// 汾     : V1.0 2022/03/02 MQ6855
//      : SIOʹú
// ע     : SIO_Slave غ㼯ڱӳ
//***********************************************

#include "main.h"

uchar wBUF_data[16]={0x50,0x01,0x00,0x80, 0x9f,0x00,0x00,0x00,   0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff};
uchar rBUF_data[16]={0x11,0x22,0x33,0x44, 0x55,0x66,0x77,0x88,   0x99,0xaa,0xbb,0xcc, 0xdd,0xee,0xff,0xab};
uchar Device_ID[16]={0xaa,0x68,0x35,0x55, 0x66,0x77,0x88,0x99,   0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff};

uchar Device_CMD = 0x00;
uchar flag_CMD   = 0x00;
uchar pLoop;

//*********************************************************************
//    : SIO_Init
//  : IOSIOģʽ
// ע     :
//*********************************************************************
void SIO_Init(void)
{
	
/* 
//  master mode ( SIOCKS=(000~110) ʱѡ²趨)
//====== ܽųʼ ======
    P7CR_P4 = 0;                        // SI
    P7FC_P4 = 0;
	
    P7CR_P5 = 1;                        // SO
    P7FC_P5 = 1;
	
    P7CR_P6 = 1;                        // SCLK
    P7FC_P6 = 1;

    
    POFFCR2_SIO0EN = 1;                 // SIO0ܿ( Enable)
    SIO0CR_SIOEDG  = 0;                 // CPOL = 1, CPHA = 1
    SIO0CR_SIOCKS  = 0x00;              // ѡ clock Ϊ fcgck/2^9
    SIO0CR_SIODIR  = 1;                 // MSB ( bit7 ʼ)
    SIO0CR_SIOM    = 0x03;              // ѡ SIO ģʽ8 λͼģʽ
    
 */
 
 
 
//  slave mode ( SIOCKS=111(ʹⲿ clock) ʱѡ²趨)
//====== ܽųʼ ======
    P7CR_P4 = 0;                        // SI
    P7FC_P4 = 0;
	
    P7CR_P5 = 1;                        // SO
    P7FC_P5 = 1;
	
    P7CR_P6 = 0;                        // SCLK
    P7FC_P6 = 1;

    
    POFFCR2_SIO0EN = 1;                 // SIO0ܿ( Enable)
    SIO0CR_SIOEDG  = 0;                 // CPOL = 1   CPHA = 1
    SIO0CR_SIOCKS  = 0x07;              // ѡⲿ clock 
    SIO0CR_SIODIR  = 1;                 // MSB ( bit7 ʼ)
    SIO0CR_SIOM    = 0x03;              // ѡ SIO ģʽ8 λͼģʽ

}


//*********************************************************************
//    : SIO_Start
//  : SIO
// ע     :
//*********************************************************************
void SIO_Start(void)
{
    SIO0CR_SIOS = 1;                    // ʼ
}


//*********************************************************************
//    : SIO_Stop
//  : ֹͣSIO
// ע     :
//*********************************************************************
void SIO_Stop(void)
{
    SIO0CR_SIOS = 0;                    // ֹͣ(reserved stop)
}


//*********************************************************************
//    : SIO0_IntEnable
//  : SSIOж
// ע     : ִкῪж(IMF)
//*********************************************************************
void SIO0_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTSIO0 = 0;                     // ж
    EI_INTSIO0 = 1;                     // 趨ж
    EI;                                 // пж // EIRL_IMF=1
}


//*********************************************************************
//    : SIO0_IntDisable
//  : ֹSIOж
// ע     : ִкῪж(IMF)
//*********************************************************************
void SIO0_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    EI_INTSIO0 = 0;                     // ж
	IL_INTSIO0 = 0;                     // ж    
    EI;                                 // пж // EIRL_IMF=1
}


//*********************************************************************
//    : SIO_ByteSend
//  : SIO
// ע     :
//*********************************************************************
void SIO_ByteSend(uchar *data, uchar len)
{
    uchar i, dummy;

    for( i=0; i<len; i++ ){    
        SIO0BUF = *data;                // Ƚд SIOBUF  SIO
        data++;

        if( i == 0 ){                   // һϴ        
            if( SIO0CR_SIOS == 0 ){            
                SIO0CR_SIOS = 1;        // SIOS SIO
            }
        }
        while( SIO0SR_TBFL == 1 ){      // TBFLͶʱȴͻΪʱдһ
            //  CLR_WDT;                // Źʱ (ι)
        }
    }
    while( SIO0SR_SEF == 1 ){           // SEFȴһϴ    
    //  CLR_WDT;                        // Źʱ (ι)
    }
}


//*********************************************************************
//    : SIO_ByteRead
//  : SIO
// ע     :
//*********************************************************************
void SIO_ByteRead(uchar *data, uchar len)
{
    uchar i, dummy;

    for( i=0; i<len; i++ ){    
        if( i == 0 ){
        //   SIO ͬʱΪͼģʽ SIO ֮ǰ SIO0BUF дһ dummy data: 0xff
            if( SIO0CR_SIOM == 0x3 ){
                SIO0BUF = 0xff;         //  SIO0BUF дһ dummy data: 0xff
                dummy = SIO0BUF;        // read dummy data
            }
            else{            
                dummy = SIO0BUF;        // read dummy data
            }

            if( SIO0CR_SIOS == 0 ){            
                SIO0CR_SIOS = 1;        // SIOS SIO
            }
        }
        else{        
            while( SIO0SR_RENDB == 0 ){ // RENDȴϣΪ 1             
            //  CLR_WDT;                // Źʱ (ι)
            }
            *data = SIO0BUF;            // ȡ SIO0BUF
            data++;

            if( SIO0CR_SIOM == 0x3 ){            
                SIO0BUF = 0xff;         //  SIO0BUF дһ dummy data: 0xff
            }
        }
    }


    while( SIO0SR_RENDB == 0 ){         // RENDȴϣΪ 1     
    //  CLR_WDT;                        // Źʱ (ι)
    }

//  һ֮ǰ reserved stopΪȡд SIOBUF ٴδ SIO clock
    SIO_ReservedStopWait();

//  һ֮ȡ
    *data = SIO0BUF;                    // ȡ SIO0BUF
    data++;
}


//*********************************************************************
//    : SIO_ReservedStopWait
//  : SIO ֹͣ
// ע     :  SIOS=0(ֹͣ SIO)(reserved stop) ж SIOF  (ȴ SIO ֹͣ)
//*********************************************************************
void SIO_ReservedStopWait(void)
{
    SIO0CR_SIOS = 0;                    // SIOS=0: reserved stop

    while( SIO0SR_SIOF == 1 ){          // SIOF: ȴ SIO ֹͣ(SIOF=0)    
    //  NOP;                            // ָ
    }
}


//*********************************************************************
//    : IntSIO0
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntSIO0(void)
{
    uchar tempBUF = 0xff , lastData=0;


    if( flag_CMD == 0x00 ){             // ʼ SIO ֮һ CMD ж    
        tempBUF = SIO0BUF;              // ȡ SIO0BUF

    //   Master ˽յȡָ (0x9f) 󣬽ظ -> 0xaa -> 0x68 -> 0x35
        if( tempBUF == 0x9f ){        
            Device_CMD = tempBUF;
            pLoop = 0;
            flag_CMD = 0xff;
        }
    //   Master ˽յȡָ (0x03) 󣬽ظ 10  rBUF_data[0] ~ rBUF_data[9] ֮
        else if( tempBUF == 0x03 ){        
            Device_CMD = tempBUF;
            pLoop = 0;
            flag_CMD = 0xff;
        }
    //   Master ˽յдָ (0x02) 󣬽յظд rBUF_data[0] ~ rBUF_data[9] ֮
        else if( tempBUF == 0x02 ){        
            Device_CMD = tempBUF;
            pLoop = 0;
            flag_CMD = 0xff;
            return;                     // ˱ʽյΪд CMDȴһʲҪд
        }
    //  δָ֮ǿֹͣ SIO
    
/*      
        else{        
            SIO0CR.byte  &= 0xf8;       // SIOM: 00 ǿֹͣ SIO
            __asm("NOP");
            SIO0CR.byte  |= 0x03;       // SIOM: Ϊͼģʽ
            flag_CMD      = 0x00;
            Device_CMD    = 0x00;
            return;                     // SIO ֹͣ뿪жϳ
        }
*/
    }


//   Master ˽յȡָ (0x9f) 󣬽ظ -> 0xaa -> 0x68 -> 0x25
    if( Device_CMD == 0x9f ){    
        if( SIO0SR_SEF == 0 ){          // SEFȴһϴ        
            SIO0BUF = Device_ID[pLoop];
            pLoop++;
            //pLoop %= 0x03;            // ظͬ 3  Devic ID 
            if(pLoop >= 3){
                lastData = 1;
            }
        }
    }
//   Master ˽յȡָ (0x03) 󣬽ظ 10  rBUF_data[0] ~ rBUF_data[9] ֮
    else if( Device_CMD == 0x03 ){    
        if( SIO0SR_SEF == 0 ){          // SEFȴһϴ        
            SIO0BUF = rBUF_data[pLoop];
            pLoop++;
            //pLoop %= 0x10;            // ظͬ 10  rBUF_data[0] ~ rBUF_data[9] ֮
            if(pLoop >= 10){
                lastData = 1;
            }
        }
    }
//   Master ˽յдָ (0x02) 󣬽յظд rBUF_data[0] ~ rBUF_data[9] ֮
    else if( Device_CMD == 0x02 ){    
        if( SIO0SR_SEF == 0 ){          // SEFȴһϴ        
            rBUF_data[pLoop] = SIO0BUF;
            pLoop++;
            //pLoop %= 0x10;            // ظд rBUF_data[0] ~ rBUF_data[9] ֮
            if(pLoop >= 5){
                lastData = 1;
            }
        }
    }
    
    if(lastData == 1){
        flag_CMD    = 0x00;
        Device_CMD  = 0x00; 
    }
    
}




























