//******************************************
//  : MQ6855_LCD.c
// 汾     : V 1.00 2019/02/22 MQ6855
//      : LCD ʹú
// ע     : LCD غ㼯ڱӳ
//******************************************

#include "main.h"

//---------------------------------------------------------------------------------------
// 010, AF 16 ,ĸʾ
// ӦLCD GDC03077 8com*14segʾ
//                               .egf                                     dcba
// 0 ӦLCD GDC03077 fge: 0101 0x05  ,ӦLCD GDC03077 abcd: 1111 0x0F
// 1 ӦLCD GDC03077 fge: 0000 0x00  ,ӦLCD GDC03077 abcd: 0110 0x06
// 2 ӦLCD GDC03077 fge: 0110 0x06	,ӦLCD GDC03077 abcd: 1011 0x0B
// 3 ӦLCD GDC03077 fge: 0010 0x02	,ӦLCD GDC03077 abcd: 1111 0x0F
// 4 ӦLCD GDC03077 fge: 0011 0x03	,ӦLCD GDC03077 abcd: 0110 0x06
// 5 ӦLCD GDC03077 fge: 0011 0x03	,ӦLCD GDC03077 abcd: 1101 0x0D
// 6 ӦLCD GDC03077 fge: 0111 0x07	,ӦLCD GDC03077 abcd: 1101 0x0D
// 7 ӦLCD GDC03077 fge: 0001 0x01	,ӦLCD GDC03077 abcd: 0111 0x07

// 8 ӦLCD GDC03077 fge: 0111 0x07  ,ӦLCD GDC03077 abcd: 1111 0x0F
// 9 ӦLCD GDC03077 fge: 0011 0x03  ,ӦLCD GDC03077 abcd: 1111 0x0F
// A ӦLCD GDC03077 fge: 0111 0x07  ,ӦLCD GDC03077 abcd: 0111 0x07
// B ӦLCD GDC03077 fge: 0111 0x07  ,ӦLCD GDC03077 abcd: 1100 0x0C
// C ӦLCD GDC03077 fge: 0101 0x05  ,ӦLCD GDC03077 abcd: 1001 0x09
// D ӦLCD GDC03077 fge: 0110 0x06  ,ӦLCD GDC03077 abcd: 1110 0x0E
// E ӦLCD GDC03077 fge: 0111 0x07  ,ӦLCD GDC03077 abcd: 1001 0x09
// F ӦLCD GDC03077 fge: 0111 0x07  ,ӦLCD GDC03077 abcd: 0001 0x01
//--------------------------------------------------------------------------------------

const uchar DIG_CODE_fge[16]={  0x05, 0x00, 0x06, 0x02, 0x03, 0x03, 0x07, 0x01,
                                0x07, 0x03, 0x07, 0x07, 0x05, 0x06, 0x07, 0x07 };

const uchar DIG_CODE_abcd[16]={	0x0F, 0x06, 0x0B, 0x0F, 0x06, 0x0D, 0x0D, 0x07,
                                0x0F, 0x0F, 0x07, 0x0C, 0x09, 0x0E, 0x09, 0x01 };

//	GDC03077 8com*14seg


//*********************************************************************
//    : LCD_Init
//  : LCD ʼ
// ע     :
//*********************************************************************
void LCD_Init(void)
{
//====== ܽųʼ ======
// 轫ʹõ LCD ܵĽΪ
// ˷ʹCOM0~COM7, SEG0~SEG13

    P9CR_P0 = 0;                        // COM  0
    P9CR_P1 = 0;                        // COM  1
    P7CR_P2 = 0;                        // COM  2
    P7CR_P3 = 0;                        // COM  3
    P8CR_P2 = 0;                        // COM  4 <== or ==> SEG  28
    P8CR_P3 = 0;                        // COM  5 <== or ==> SEG  29
    P2CR_P3 = 0;                        // COM  6 <== or ==> SEG  30
    P2CR_P4 = 0;                        // COM  7 <== or ==> SEG  31

    P2CR_P5 = 0;                        // SEG  0
    P2CR_P6 = 0;                        // SEG  1
    P2CR_P7 = 0;                        // SEG  2
    P7CR_P7 = 0;                        // SEG  3
    P7CR_P5 = 0;                        // SEG  4
    P7CR_P0 = 0;                        // SEG  5
    P7CR_P6 = 0;                        // SEG  6
    P7CR_P4 = 0;                        // SEG  7

    P4CR_P7 = 0;                        // SEG  8
    P4CR_P6 = 0;                        // SEG  9
    P4CR_P5 = 0;                        // SEG 10
    P4CR_P4 = 0;                        // SEG 11
    P2CR_P0 = 0;                        // SEG 12
    P2CR_P1 = 0;                        // SEG 13
	
	//---------------------------------------------
	/*															
    P2CR_P2 = 0;                        // SEG 14
    P8CR_P4 = 0;                        // SEG 15

    P8CR_P5 = 0;                        // SEG 16
    P8CR_P6 = 0;                        // SEG 17
    P8CR_P7 = 0;                        // SEG 18
    P9CR_P2 = 0;                        // SEG 19
    P9CR_P3 = 0;                        // SEG 20
    P5CR_P7 = 0;                        // SEG 21
    P5CR_P6 = 0;                        // SEG 22
    P5CR_P5 = 0;                        // SEG 23

    P5CR_P4 = 0;                        // SEG 24
    P5CR_P3 = 0;                        // SEG 25
    P5CR_P2 = 0;                        // SEG 26
    P5CR_P1 = 0;                        // SEG 27
	*/

//====== ܿ( Enable) ======
    POFFCR2_LCDEN = 1;

//====== 趨 ======

    LCDCR1_DUTY   = 0x05;               // 1/8 ռգ1/4 ƫѹ
//  LCDCR1_DUTY   = 0x06;               // 1/8 ռգ1/3 ƫѹ
//  LCDCR1_DUTY   = 0x07;               // 1/8 ռգ1/2 ƫѹ
    LCDCR1_SLF    = 0x03;               // Fcgck/2^15
    LCDCR2_LDRS   = 1;					// LCDܿ

    LCDBUFxx_init_seq();				// LCD ȫʾ
	

    LCDCR3 = 0xff;                      // Enable COM_EN[7:0]

    LCDCR4 = 0xff;                      // Enable SEGH_EN[ 7: 0]
    LCDCR5 = 0x3f;                      // Enable SEGH_EN[15: 8]
	/*
    LCDCR6 = 0xff;                      // Enable SEGH_EN[23:16]
    LCDCR7 = 0x0f;                      // Enable SEGH_EN[31:24]
	*/
}



//**************************************************************************************
//    : LCD_Power_Control
//  : LCD Դ/bias voltage趨
// ע     : LCDVCR1_VCR4_00~31ѡ0Ϊ31Ϊǳ
//			  LCDǳ̶ȣݲͬLCDвͬʹ߿еLCDVCR1_VCR4_0
//**************************************************************************************
void LCD_Power_Control(uchar ki, uchar z1, uchar z2)
{
  //---------------- LCD Դ趨 --------------------------------------
    //***ȷLCDѹVDDѹ
    LCDCR2_VLCSEL = 0;					// ѡVDD ΪLCD Դ
	
	//LCDCR2_VLCSEL = 1;				// ѡP71 ΪLCD Դ
	
 //---------LCDƫѹ޵ʹLCDɫ -------------------------
	//LCDVCR1 = 0;						// LCDƫѹ޵,LCDɫ



	
 //---------LCDƫѹʹLCDǳ -------------------------
	
 /* ----------------------  ------------------------------ */
	z1=z2=2;						    // ʾ趨ʼֵ	

 //-----------------------------------------------------------------
 //ΪLCDǳ[=>ǳ,=>ǳ,ǳ=>,ǳ=>]
 //-----------------------------------------------------------------
    // 1.LCDִɫ ǳɫظʾ
	for(z1=2; z1>0; --z1)
	{
	
		for(ki=0; ki<32; ki++)
		{
			LCDVCR1_VCR4_0 = ki;		// LCDƫѹ
			delay_times(t_1ms, 250);	// ӳ 250ms
		
		}
		
	}	


    // 2.LCDִǳɫ ɫظʾ
	for(z2=2; z2>0; --z2)
	{	
		for(ki=31; ki>0; ki--)
		{
			LCDVCR1_VCR4_0 = ki;		// LCDƫѹ
			delay_times(t_1ms, 250);	// ӳ 250ms
		}
	}
		
			
	delay_times(t_1ms, 100);			// ӳ 100ms
	
 //---------------------------------------------------------------------
 
 
 //-----------------------------------------------------------------
 //ΪLCDǳ[ǳ=>,ǳ=>,=>ǳ,=>ǳ]
 //-----------------------------------------------------------------
 
/*
	// 1.LCDִǳɫ ɫظʾ
	for(z1=2; z1>0; --z1)
	{
		for(ki=31; ki>0; ki--)
		{
			LCDVCR1_VCR4_0 = ki;		// LCDƫѹ
			delay_times(t_1ms, 250);	// ӳ 250ms
		}
		
	}	


	// 2.LCDִɫ ǳɫظʾ
	for(z2=2; z2>0; --z2)
	{	
		for(ki=0; ki<32; ki++)
		{
			LCDVCR1_VCR4_0 = ki;		// LCDƫѹ
			delay_times(t_1ms, 250);	// ӳ 250ms

		}
	}
		
			
	delay_times(t_1ms, 100);			// ӳ 100ms
	//-------------------------------------------------------------------
*/
	
	
	

}




//*********************************************************************
//    : LCD_Power_Control_08
//  : LCDƫѹ,LCDֽǳɫ 
// ע     : LCDVCR1_VCR4_00~31ѡ0Ϊ31Ϊǳ
//*********************************************************************
void LCD_Power_Control_08()
{

	LCDVCR1_VCR4_0 = 0x08;				// LCDƫѹ
	
}

//*********************************************************************
//    : LCD_Power_Control_10
//  : LCDƫѹ,LCDָǳɫ
// ע     : LCDVCR1_VCR4_00~31ѡ0Ϊ31Ϊǳ
//*********************************************************************
void LCD_Power_Control_10()
{

	LCDVCR1_VCR4_0 = 0x10;				// LCDƫѹ
	
}


//*********************************************************************
//    : LCD_Start
//  : Start LCD
// ע     : 
//*********************************************************************
void LCD_Start(void)
{
    LCDCR1_EDSP = 1;					// LCD ʾ
}

//*********************************************************************
//    : LCD_Stop
//  : Stop LCD
// ע     : 
//*********************************************************************
void LCD_Stop(void)
{
    LCDCR1_EDSP = 0;					// ֹLCD ʾ
}



//*********************************************************************
//    : LCDBUFxx_init_seq
//  : LCD ȫʾ
// ע     : MQ6855 (8com*28seg) (4com*32seg)
//*********************************************************************
void LCDBUFxx_init_seq(void)
{
    LCDBUF00 = 0xFF;
    LCDBUF01 = 0xFF;
    LCDBUF02 = 0xFF;
    LCDBUF03 = 0xFF;
    LCDBUF04 = 0xFF;
    LCDBUF05 = 0xFF;
    LCDBUF06 = 0xFF;
    LCDBUF07 = 0xFF;
    LCDBUF08 = 0xFF;
    LCDBUF09 = 0xFF;
    LCDBUF10 = 0xFF;
    LCDBUF11 = 0xFF;
    LCDBUF12 = 0xFF;                    // for SEG28 & SEG12
    LCDBUF13 = 0xFF;                    // for SEG29 & SEG13
		
										// ˷ʹSEG0~SEG13
    //---------------------------------------------------------------										
	/*
    LCDBUF14 = 0xFF;                    // for SEG30 & SEG14
    LCDBUF15 = 0xFF;                    // for SEG31 & SEG15
    LCDBUF16 = 0xFF;
    LCDBUF17 = 0xFF;
    LCDBUF18 = 0xFF;
    LCDBUF19 = 0xFF;
    LCDBUF20 = 0xFF;
    LCDBUF21 = 0xFF;
    LCDBUF22 = 0xFF;
    LCDBUF23 = 0xFF;
    LCDBUF24 = 0xFF;
    LCDBUF25 = 0xFF;
    LCDBUF26 = 0xFF;
    LCDBUF27 = 0xFF;
	*/
}


//*********************************************************************
//    : Dig_Decode
//  : LCD_digital_display
// ע     : 8 ·̬4λʽ LCD Һʾ GDC03077
//*********************************************************************
void Dig_Decode(uchar digN, uchar Num)			// digNͼ,Numʾڼʾ,ĸ
{
    uchar NumFGE=0, NumABCD=0, NumMask;

    if( digN/5 )								// ͼ5~10 (>=5)
    {
        NumMask  = 0xf0;						// ʹ(NumMask=1111 0000)
        NumFGE   = DIG_CODE_fge[Num];
        NumABCD  = DIG_CODE_abcd[Num];
    }
    else										// ͼ1~4 (<5)
    {
        NumMask  = 0x0f;						// ʹ(NumMask=0000 1111)
        NumFGE   = DIG_CODE_fge[Num]  << 4;     // 4bit
        NumABCD  = DIG_CODE_abcd[Num] << 4;     // 4bit
		
    }

    switch(digN){
        case 1:									// ͼ1ʹõSEG0SEG1
            LCDBUF00 &= NumMask;				// NumMask = 0000 1111
            LCDBUF01 &= NumMask;				// NumMask = 0000 1111
            LCDBUF00 |= NumFGE;					// SEG0
            LCDBUF01 |= NumABCD;				// SEG1
            break;
        case 2:									// ͼ2ʹõSEG2SEG3
            LCDBUF02 &= (NumMask|0x80);			// NumMask = 1000 1111 (0000 1111 or 1000 0000) 
            LCDBUF03 &= NumMask;				// NumMask = 0000 1111
            LCDBUF02 |= NumFGE;					// SEG2
            LCDBUF03 |= NumABCD;				// SEG3
            break;
        case 3:									// ͼ3ʹõSEG4SEG5
            LCDBUF04 &= (NumMask|0x80);			// NumMask = 1000 1111 (0000 1111 or 1000 0000) 
            LCDBUF05 &= NumMask;				// NumMask = 0000 1111
            LCDBUF04 |= NumFGE;					// SEG4
            LCDBUF05 |= NumABCD;				// SEG5
            break;
        case 4:									// ͼ4ʹõSEG6SEG7
            LCDBUF06 &= (NumMask|0x80);			// NumMask = 1000 1111 (0000 1111 or 1000 0000) 
            LCDBUF07 &= NumMask;				// NumMask = 0000 1111
            LCDBUF06 |= NumFGE;					// SEG6
            LCDBUF07 |= NumABCD;				// SEG7
            break;
        case 5:									// ͼ5ʹõSEG0SEG1
            LCDBUF00 &= NumMask;				// NumMask = 1111 0000
            LCDBUF01 &= NumMask;				// NumMask = 1111 0000
            LCDBUF00 |= NumFGE;					// SEG0
            LCDBUF01 |= NumABCD;				// SEG1
            break;
        case 6:									// ͼ6ʹõSEG2SEG3
            LCDBUF02 &= (NumMask|0x08);			// NumMask = 1111 1000 (1111 0000 or 0000 1000) 
            LCDBUF03 &= NumMask;				// NumMask = 1111 0000
            LCDBUF02 |= NumFGE;					// SEG2
            LCDBUF03 |= NumABCD;				// SEG3
            break;
        case 7:									// ͼ7ʹõSEG4SEG5
            LCDBUF04 &= (NumMask|0x08);			// NumMask = 1111 1000 (1111 0000 or 0000 1000) 
            LCDBUF05 &= NumMask;				// NumMask = 1111 0000
            LCDBUF04 |= NumFGE;					// SEG4
            LCDBUF05 |= NumABCD;				// SEG5
            break;
        case 8:									// ͼ8ʹõSEG12SEG13
            LCDBUF13 &= NumMask;				// NumMask = 1111 0000
            LCDBUF12 &= NumMask;				// NumMask = 1111 0000
            LCDBUF13 |= NumFGE;					// SEG13
            LCDBUF12 |= NumABCD;				// SEG12
            break;
        case 9:									// ͼ9ʹõSEG10SEG11
            LCDBUF11 &= NumMask;				// NumMask = 1111 0000
            LCDBUF10 &= NumMask;				// NumMask = 1111 0000
            LCDBUF11 |= NumFGE;					// SEG11
            LCDBUF10 |= NumABCD;				// SEG10
            break;
        case 10:								// ͼ10ʹõSEG8SEG9
            LCDBUF09 &= NumMask;				// NumMask = 1111 0000
            LCDBUF08 &= NumMask;				// NumMask = 1111 0000
            LCDBUF09 |= NumFGE;					// SEG9
            LCDBUF08 |= NumABCD;				// SEG8
            break;
        default:
        // Add your code here ......
        break;
    }
}



//*********************************************************************
//    : Bat_Decode
//  : Battery Display صƺʾ
// ע     : 8 ·̬4λʽ LCD Һʾ GDC03077
//*********************************************************************
void Bat_Decode(uchar Num)
{
    uchar NumBat=0, NumMask;

    NumMask  = 0xf0;							// NumMask  = 1111 0000
    switch(Num){
        case 0:
            NumBat = 0x00;						// صƺȫ(S1,S2,S3,S4)  0000 0000
            break;
        case 1:
            NumBat = 0x08;						// صƺ0 (S1)           0000 1000
            break;
        case 2:
            NumBat = 0x08 | 0x01;				// صƺ1 (S1,S4)        0000 1001 (0000 1000 or 0000 0001)
            break;
        case 3:
            NumBat = 0x08 | 0x03;				// صƺ2 (S1,S3,S4)     0000 1011 (0000 1000 or 0000 0011)
            break;
        case 4:
            NumBat = 0x08 | 0x07;				// صƺ (S1,S2,S3,S4) 0000 1111 (0000 1000 or 0000 0111)
            break;
        default:
        // Add your code here ......
        break;
    }
    LCDBUF06 &= NumMask;
    LCDBUF06 |= NumBat;
}


//*********************************************************************
//    : Percent_Decode
//  : Percentage Display ٷֱȵƺʾ
// ע     : 8 ·̬4λʽ LCD Һʾ GDC03077
//*********************************************************************
void Percent_Decode(uchar Num)
{
    uchar NumPer=0, NumMask;
	
	
	uchar Percent_line;
	uchar Percent_se1;
	uchar Percent_se2;
	uchar Percent_se3;
	uchar Percent_se4;
	
    NumMask  = 0x0f;							// NumMask  = 0000 1111
	
	
	
    switch(Num){
        case 0:								    // ٷֱȵƺȫ
			Percent_line = 0x00 << 4;			
			Percent_se1  = 0x00 << 4;
			Percent_se2  = 0x00 << 4;
			Percent_se3  = 0x00 << 4;
			Percent_se4  = 0x00 << 4;

			LCDBUF08  &= NumMask;
			LCDBUF08  |= Percent_line;

			LCDBUF12  &= NumMask;
			LCDBUF12  |= Percent_se1;
			
			LCDBUF11  &= NumMask;
			LCDBUF11  |= Percent_se2;
			
			LCDBUF10  &= NumMask;
			LCDBUF10  |= Percent_se3;
			
			LCDBUF09  &= NumMask;
			LCDBUF09  |= Percent_se4;
            break;
        case 1:									// ٷֱȵƺ100%
			Percent_line = 0x08 << 4;			
			Percent_se1  = 0x0F << 4;
			Percent_se2  = 0x0F << 4;
			Percent_se3  = 0x0F << 4;
			Percent_se4  = 0x00 << 4;  
			
			LCDBUF08  &= NumMask;
			LCDBUF08  |= Percent_line;

			LCDBUF12  &= NumMask;
			LCDBUF12  |= Percent_se1;
			
			LCDBUF11  &= NumMask;
			LCDBUF11  |= Percent_se2;
			
			LCDBUF10  &= NumMask;
			LCDBUF10  |= Percent_se3;
			
			LCDBUF09  &= NumMask;
			LCDBUF09  |= Percent_se4;
            break;
        case 2:									// ٷֱȵƺ75
			Percent_line = 0x08 << 4;			
			Percent_se1  = 0x0F << 4;
			Percent_se2  = 0x0F << 4;
			Percent_se3  = 0x00 << 4;
			Percent_se4  = 0x00 << 4;
			
			LCDBUF08  &= NumMask;
			LCDBUF08  |= Percent_line;

			LCDBUF12  &= NumMask;
			LCDBUF12  |= Percent_se1;
			
			LCDBUF11  &= NumMask;
			LCDBUF11  |= Percent_se2;
			
			LCDBUF10  &= NumMask;
			LCDBUF10  |= Percent_se3;
			
			LCDBUF09  &= NumMask;
			LCDBUF09  |= Percent_se4;
            break;
        case 3:									// ٷֱȵƺ
			Percent_line = 0x08 << 4;			
			Percent_se1  = 0x0F << 4;
			Percent_se2  = 0x00 << 4;
			Percent_se3  = 0x00 << 4;
			Percent_se4  = 0x00 << 4;
			
			LCDBUF08  &= NumMask;
			LCDBUF08  |= Percent_line;

			LCDBUF12  &= NumMask;
			LCDBUF12  |= Percent_se1;
			
			LCDBUF11  &= NumMask;
			LCDBUF11  |= Percent_se2;
			
			LCDBUF10  &= NumMask;
			LCDBUF10  |= Percent_se3;
			
			LCDBUF09  &= NumMask;
			LCDBUF09  |= Percent_se4;
            break;
        case 4:									// ٷֱȵƺ
			Percent_line = 0x08 << 4;			
			Percent_se1  = 0x0C << 4;
			Percent_se2  = 0x00 << 4;
			Percent_se3  = 0x00 << 4;
			Percent_se4  = 0x00 << 4;
			
			LCDBUF08  &= NumMask;
			LCDBUF08  |= Percent_line;

			LCDBUF12  &= NumMask;
			LCDBUF12  |= Percent_se1;
			
			LCDBUF11  &= NumMask;
			LCDBUF11  |= Percent_se2;
			
			LCDBUF10  &= NumMask;
			LCDBUF10  |= Percent_se3;
			
			LCDBUF09  &= NumMask;
			LCDBUF09  |= Percent_se4;
            break;
        default:
        // Add your code here ......
        break;
    }
	



}




