//**********************************************************************
//  : MQ6855_Flash.c
// 汾     : V1.0 2022/03/02 MQ6855
//      : Flashʹú
// ע		***ȷFLASHʽִǰоƬϵ硢λ
//**********************************************************************

#include "main.h"

//==============================================================================
//ʽ  : Flash_WriteByte 
//شֵ    : 0:дɹ  1:дʧ<дԤֵͬ>  2:дʧ<дǰֵΪ0xff>
//            3:Чĵַ
//		: <addr>	ָдַʹFLASHڴ(0x7E80~0x7EFF)
//          			FLASHڴרоƬ\Еro䛅ʹá
//          			¼оƬʱʹô顣ҲʹڳFLASH
//          			ڴ(0x8000~0xffff)עõַ޴룬д޸ĳṹ
//     		  <data>	дFLASHϣΪ1BYTE
//		: addrַʼд볤Ϊ1BYTEָdata
//==============================================================================
unsigned char Flash_WriteByte(unsigned int addr,unsigned char data)
{	
	unsigned char tmpIMF;
	
	
	if( !((addr>=0x7e80&&addr<=0x7eff) ||
		   (addr>=0x8000&&addr<=0xffff)) )
		return 3;				// Чĵַ
		   
	if( *((unsigned char*)addr) != 0xff)
		return 2;				// дǰΪ(0xff)
		   
    FLSCR1_FLSMD = 0x05;        //  Flash 洢л
    FLSCR2       = 0xd5;        //  FLSCR1 趨
	tmpIMF = EI_IMF;
	EI_IMF = 0x0;			//DI
	__asm("ld (0xf555),0xaa");
	__asm("ld (0xfaaa),0x55");
	__asm("ld (0xf555),0xa0");
	*(unsigned char* )(addr) = data;      
	EI_IMF = tmpIMF;		//recover IMF
    FLSCR1_FLSMD = 0x02;        // ֹ Flash 洢л
    FLSCR2       = 0xd5;        //  FLSCR1 趨
	
	if( *((unsigned char*)addr) != data)
		return 1;				// дʧ
	
	
	return 0;					// дɹ
	
}


//==============================================================================
//ʽ	: Flash_ReadSequence
//شֵ	: void
//		: <addr> 	FLASHȡʼַ
//     		  <data> 	ָ꣬ʽFLASHȡϣд
//     		  <length>	ʽFLASHȡĳ(BYTE)
//		: addrַʼȡFLASHָlengthϣdata
//==============================================================================
void Flash_ReadSequence(unsigned int addr,unsigned char* data,unsigned int length)
{
	unsigned char *p_addr = (unsigned char *)addr;
	unsigned int i;
	for(i=0;i<length;i++)
	{
		data[i] = *(p_addr+i);
		WDCDR=0x4e; 			//clear wdt
	}
	
}




//==============================================================================
//ʽ	: FlashReadByte 
//شֵ	: unsigned char
//		: <addr>	FLASHȡĵַ
//		: ַָaddrȡϺش
//==============================================================================
unsigned char Flash_ReadByte(unsigned int addr)
{	
	return *((unsigned char *)addr);
}




//==============================================================================
//ʽ  : Flash_SectionErase 
//شֵ    : 0:ɹ  1:ʧ 3:Чĵַ
//		: <addr> ʽַָaddrsection
//		: ַָaddr,ϵͳ˵ַԶжϡַָaddrsection(128 Bytes)
//     
//     		  : addr =0x7e80 tsection:0x7e80~0x7eff 0x7e80  ϵͳ0x7e80~0x7eff  (128 Bytes)
//         		  addr =0x7e99 tsection:0x7e80~0x7eff 0x7e99  ϵͳ0x7e80~0x7eff  (128 Bytes)
//         		  addr =0x7eff tsection:0x7e80~0x7eff 0x7eff  ϵͳ0x7e80~0x7eff  (128 Bytes) 
//         		  addr =0xf000 tsection:0xf000~0xf07f 0xf000  ϵͳ0xf000~0xf07f  (128 Bytes)
//         		  addr =0xcfff tsection:0xcf80~0xcfff 0xcfff  ϵͳ0xcf80~0xcfff  (128 Bytes)
// 
//         	  section:0xXX00~0xXX7f , 0xXX80~0xXXff
// 
// 		   	  FLASHڴ:
//         		  <section>0x7e80~0x7eff
//  	      FLASHڴ:
//         		  <section>0x8000~0x807f 
//         		  <section>0x8080~0x80ff 
//         		  <section>0x8100~0x817f 
//         		  <section>0x8180~0x81ff
//                          :
//                          :						  
//         		  <section>0xff00~0xff7f 
//         		  <section>0xff80~0xffff
//==============================================================================
unsigned char Flash_SectionErase(unsigned int addr)
{
	unsigned char tmpIMF;
	unsigned int  iAddr,startAddr,endAddr;
	
	
	if( !((addr>=0x7e80&&addr<=0x7eff) ||
		   (addr>=0x8000&&addr<=0xffff)) )
		return 3;				// Чĵַ
	
    FLSCR1_FLSMD = 0x05;        //  Flash 洢л
    FLSCR2       = 0xd5;        //  FLSCR1 趨
	tmpIMF = EI_IMF;
	EI_IMF = 0x0;			//DI
	__asm("ld (0xf555),0xaa");
	__asm("ld (0xfaaa),0x55");
	__asm("ld (0xf555),0x80");
	__asm("ld (0xf555),0xaa");
	__asm("ld (0xfaaa),0x55");		
	*(unsigned char* )(addr) = 0x20;
	EI_IMF = tmpIMF;		//recover IMF
    FLSCR1_FLSMD = 0x02;        // ֹ Flash 洢л
    FLSCR2       = 0xd5;        //  FLSCR1 趨
	
	startAddr 	= addr & 0xff80;
	endAddr		= addr|0x7f	;	
	for(iAddr=startAddr;iAddr <=endAddr ;iAddr++){
		if( *(unsigned char* )(iAddr) != 0xff){
			return 1;			// ʧ
		}
	}
	
	return 0;
}








