//******************************************
//  : MQ6855_ADC.h
// 汾     : V1.0 2022/03/02 MQ6855
//      : ADCͷļ
// ע     :
//******************************************
#ifndef _MQ6855_ADC_H__
#define _MQ6855_ADC_H__

#define	ad_test_times       16

/******************
 * 1st Argument
 * ****************/
#define     ADC_Single      0x1 // תģʽ
#define     ADC_Repeat      0x3 // תģʽ
/******************
 * 2nd Argument
 * ****************/
#define     AIN_DIS         0x0 // ֹģź
#define     AIN_EN          0x1 // ģź
/******************
 * 3rd Argument
 * ****************/
#define     AIN0            0x0 // ѡⲿѹAIN0
#define     AIN1            0x1 // ѡⲿѹAIN1
#define     AIN2            0x2 // ѡⲿѹAIN2
#define     AIN3            0x3 // ѡⲿѹAIN3
#define     AIN4            0x4 // ѡⲿѹAIN4
#define     AIN5            0x5 // ѡⲿѹAIN5
#define     AIN6            0x6 // ѡⲿѹAIN6
#define     AIN7            0x7 // ѡⲿѹAIN7
#define     AIN8            0x8 // ѡⲿѹAIN8
#define     VDD4_1          0x9 // ѡڲѹ (4֮1 VDD)
#define     AIN_GND         0xc // ڲӵ
#define     AIN13           0xd // ѡⲿѹAIN13
#define     AIN14           0xe // ѡⲿѹAIN14
#define     AIN15           0xf // ѡⲿѹAIN15
/******************
 * 4th Argument
 * ****************/
// fcgck=16M... Conv256CLK(16us) ~ Conv1024CLK( 64us)
// fcgck= 8M... Conv128CLK(16us) ~ Conv1024CLK(128us)
// fcgck= 4M... Conv64CLK (16us) ~ Conv512CLK (128us)
// fcgck= 2M... Conv32CLK (16us) ~ Conv256CLK (128us)
#define     Conv32CLK       0x0 // ADתʱ-  32ʱ
#define     Conv64CLK       0x1 // ADתʱ-  64ʱ
#define     Conv128CLK      0x2 // ADתʱ- 128ʱ
#define     Conv256CLK      0x3 // ADתʱ- 256ʱ
#define     Conv512CLK      0x4 // ADתʱ- 512ʱ
#define     Conv1024CLK     0x5 // ADתʱ-1024ʱ
                                // (*עתʱӦ趨12.8 us ~ 128 us Χ)
/******************
 * 5th Argument
 * ****************/
#define     Vref2           0x0 // ѡڲ 2Vοѹ
#define     Vref3           0x1 // ѡڲ 3Vοѹ
#define     Vref4           0x2 // ѡڲ 4Vοѹ
#define     VDDVref         0x3 // ѡڲVDDοѹ
#define     EXTVref         0x4 // ѡⲿExtοѹʹAIN3ͬĵ28(P43)Ϊ
								// ⲿοѹ룬ⲿοѹʱʹAIN3Ϊⲿѹ





extern uint  vref_l, vref_h, iReal_Vref2V, ADC_Code_READ;



void ADC_Init(uchar SAIN);
void ADC_Start(void);
void ADC_Stop(void);
void ADC_IntEnable(void);
void ADC_IntDisable(void);

uint GetVref(void);
uint ADC_single_detect(uchar SAIN);
uint ADC_repeat_detect(uchar SAIN);

void __interrupt IntADC(void);






#endif








