//******************************************
//  : MQ6855_ADC.c
// 汾     : V1.0 2022/03/02 MQ6855
//      : ADC
// ע     : ADCغ㼯ڱӳ
//******************************************

#include "main.h"



uint  vref_l, vref_h, iReal_Vref2V, ADC_Code_READ;


//*********************************************************************
//    : ADC_Init
//  : OIO,AIN,늉,ģʽ
// ע     :
//*********************************************************************
void ADC_Init(uchar SAIN)
{
//Ѿmain.c趨IO
//====== 趨 ======
// ADCCR1:
//           SAIN  ѡAD תģźͨ(Analog input channel select)
//		     AINEN ģź
//			 AMD   AD תģʽ
// ADCCR2:
//           ACK   AD תʱ
//
//----------------------------------------------------------------------   
//  MQ6855 AIN2~AIN8,AIN13~AIN15  ģźͨ-----------

    ADCVRF_VRFSEL   = Vref2;            	// 0. 趨 ADC οѹVref2 = 2V Ϊڲ·
    ADCCR1_SAIN     = SAIN;             	// 1. 趨 SAINѡ AD תģźͨ,SAINѾmain.cѡAIN7
    
    ADCCR1_AINEN    = 1;                	// 2. 趨ģź AINEN Ϊ"ģź"
    ADCCR1_AMD      = ADC_Repeat;       	// 3. 趨 AMDѡ AD תģʽΪλظģʽ
    
    
    
    ADCCR2_ACK      = Conv256CLK;       	// 4. 趨 AD תʱ
}


//*********************************************************************
//    : ADC_Start
//  :  ADC
// ע     :
//*********************************************************************
void ADC_Start(void)
{
    ADCCR1_ADRS = 1;                    	//  AD ת
}


//*********************************************************************
//    : ADC_Stop
//  : ֹͣ ADC	
// ע     :
//*********************************************************************
void ADC_Stop(void)
{
    ADCCR1_AMD = 0;                     	// 0: ֹ AD ǿ AD ֹͣ
}


//*********************************************************************
//    : ADC_IntEnable
//  : ADCж
// ע     : ִкῪж(IMF)
//*********************************************************************
void ADC_IntEnable(void)
{
    DI;                                 	// ֹпж // EIRL_IMF=0
    IL_INTADC = 0;                      	// ж
    EI_INTADC = 1;                      	// 趨ж
    EI;                                 	// пж // EIRL_IMF=1
}


//*********************************************************************
//    : ADC_IntDisable
//  : ֹADCж
// ע     : ִкῪж(IMF)
//*********************************************************************
void ADC_IntDisable(void)
{
    DI;                                 	// ֹпж // EIRL_IMF=0
    
    
    IL_INTADC = 0;                      	// ж
    EI_INTADC = 0;                      	// ж
    EI;                                 	// пж // EIRL_IMF=1
}


//*********************************************************************
//    : GetVref()
//  : ȡ ADC ڲ Vref 2V ֮ʵֵ(λΪmV),
//          : ȡֵΪ ( ڲ Vref 2V ֮ʵֵ * 1024 ), λΪ mV
// ע     :  ADC Զ:(0x0EF6)(VREF_CALIB<VRFCAL>)=1
//*********************************************************************
uint GetVref(void)
{
    BIT_LIST_16 ADC_READ;
//	Vref2V, value is ( Real_2V * 1024 )
	__asm("LD A,(0x7E05)");		        	// low byte
	__asm("LD (_vref_l),A");
	__asm("LD A,(0x7E06)");		        	// high byte
	__asm("LD (_vref_h),A");

	ADC_READ.byte[0] = vref_l;
	ADC_READ.byte[1] = vref_h & 0x0f;

//  ڲ֮ Vref2V ѹ 2150 <= Vref2V >= 1950,  ADC Զ
	if( ADC_READ.word <= 2150 )
	    if( ADC_READ.word >= 1950 )
	        VREF_CALIB_VRFCAL = 1;      	//  ADC Զ

    return ADC_READ.word;
}
//uint GetVref(void)
//{
////	__asm("LD A,(0x7E05)");		    	// low byte
////	__asm("LD A,(0x7E06)");		    	// high byte
//	uint *adc_value = (uint*)(0x7E05);
//	uint adc_read;

//  adc_read = *adc_value & 0x0fff;
//  ڲ֮ Vref2V ѹ 2150 <= Vref2V >= 1950,  ADC Զ
//  if( ADC_READ.word <= 2150 )
//      if( ADC_READ.word >= 1950 )
//          VREF_CALIB_VRFCAL = 1;
//	return adc_read;
//}

//*********************************************************************
//    : ADC_single_detect
//  : ADC ģʽȡ
// ע     :
//*********************************************************************
uint ADC_single_detect(uchar SAIN)
{
    BIT_LIST_16 ADC_READ;

//====== 趨ģźͨ ======
    ADCCR1_SAIN = SAIN;                 	// 1. 趨 SAINѡ AD תģźͨ

    ADCCR1_ADRS = 1;                    	//  AD ת
    while(  ADCCR2_ADBF ){ CLR_WDT; }   	// 1: AD תС    [ADBF:ADתæµ]
    while( !ADCCR2_EOCF ){ CLR_WDT; }   	// 1: AD תɣ 0: AD תǰת  [EOCF:ADתɱ]

    ADC_READ.byte[0] = ADCDRL;          	// ȡ ADC ֵȶ Low Byte, ٶ High Byte
    ADC_READ.byte[1] = ADCDRH;          	// ȡ ADC ֵȶ Low Byte, ٶ High Byte
//    adc_data += ADC_READ.word;




	return ADC_READ.word;
}


//*********************************************************************
//    : ADC_repeat_detect
//  : ADC ظģʽȡ
// ע     :
//*********************************************************************
uint ADC_repeat_detect(uchar SAIN)
{
    uchar i;
    ulong adc_data = 0;
    uint  ad_max = 0, ad_min = 1024;
    BIT_LIST_16 ADC_READ;

//====== Oģźͨ ======
    ADCCR1_SAIN = SAIN;                 	// 1. 趨 SAINѡ AD תģźͨ

    ADCCR1_ADRS = 1;                    	//  AD ת
    for( i=0; i<(ad_test_times+2); i++ )	// ظ18
    {
        while( !ADCCR2_EOCF ){ CLR_WDT; } 	// 1: AD תɣ 0: AD תǰת
        ADC_READ.byte[0] = ADCDRL;      	// ȡ ADC ֵȶ Low Byte, ٶ High Byte
        ADC_READ.byte[1] = ADCDRH;      	// ȡ ADC ֵȶ Low Byte, ٶ High Byte
        adc_data += ADC_READ.word;
        if( ADC_READ.word > ad_max ) ad_max = ADC_READ.word;
        if( ADC_READ.word < ad_min ) ad_min = ADC_READ.word;
    }
    ADCCR1_ADRS = 0;                    	// ֹͣ AD ת

    adc_data -= ad_max;                 	// ȥֵ
    adc_data -= ad_min;                 	// ȥСֵ
    adc_data /= ad_test_times;

	return (uint)adc_data;
}



//*********************************************************************
//    : IntADC
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntADC(void)
{
    NOP;                                	// ָ
}










