//***************************************************
// file			: MQ6835_10BIT_TCCx.c
// version		: V1.0 2021/09/13
// brief		: 10-bit TCC0 PPG related functions
// note			: 10-bit TCC0 PPG related functions are gathered in this subroutine
//****************************************************

#include "main.h"


//*********************************************************************
// name			: TCC0_PPGC0x_Init
// brief		: TCC0 PPGC01/PPGC02 output with variable duty ratio
// note			:
//          : use the following procedure to configure the control and setup registers in sequence
//          : 1. mode configuration : TCxCR1, TCxCR2
//          : 2. dead time and pulse width configuration: TCxDRA, TCxDRB, TCxDRD, TCxDRE (it is only necessary if the relevant modes used)
//          : 3. period configuration: TCxDRC
//          : 4. timer control: TCxCR3
//*********************************************************************
void TCC0_PPGC0x_Init(void)
{
//====== pin configuration ======
    P2CR_P6 = 1;                        // set P26(PPGC01B) as output pin
    P2CR_P7 = 1;                        // set P27(PPGC02B) as output pin

//====== enable function ======
    POFFCR0_TCC0EN = 1;		            // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
	UATCNG_UAT2IO = 0;
	

//------ ------ ------ ------ ------ ------
// 1. mode configuration : TC0CR1, TC0CR2
//------ ------ ------ ------ ------ ------
    TC0CR1_TCCCK    =  0x02;            // TCCCK: select source clock
                    // 0x00: fcgck
                    // 0x01: fcgck/2
                    // 0x02: fcgck/2^2
                    // 0x03: fcgck/2^3
    TC0CR1_PPGC1INI = 0;                // set the initial value of PPG01 output to low (positive logic)
    TC0CR1_PPGC2INI = 0;                // set the initial value of PPG02 output to low (positive logic)
//	set function pins after function initialization
    P2FC_P6 = 1;                        // set P26(PPGC01B) as special function pin
    P2FC_P7 = 1;                        // set P27(PPGC02B) as special function pin

//------ ------ ------ ------ ------ ------
    TC0CR2_TCCOUT   =  0x00;            // TCCOUT: select an output waveform mode
                    // 0x00: PPGC01/PPGC02 independent output
                    // 0x01: *reserved
                    // 0x02: output with variable duty ratio
                    // 0x03: output with 50% duty ratio

//------ ------ ------ ------ ------ ------
// 2. dead time and pulse width configuration: TC0DRA, TC0DRB, TC0DRD, TC0DRE (it is only necessary if the relevant modes used)
//------ ------ ------ ------ ------ ------
    TC0DRAL         = 0x06;             // dead time 1 setup register (low byte)   6
    TC0DRAH         = 0x00;             // dead time 1 setup register (high byte)

    TC0DRBL         = 0x20;             // pulse width 1 setup register (low byte)      32
    TC0DRBH         = 0x00;             // pulse width 1 setup register (high byte)

    TC0DRDL         = 0x10;             // dead time 2 setup register (low byte)   16
    TC0DRDH         = 0x00;             // dead time 2 setup register (high byte)

    TC0DREL         = 0x80;             // pulse width 2 setup register (low byte)      128
    TC0DREH         = 0x00;             // pulse width 2 setup register (high byte)

//------ ------ ------ ------ ------ ------
// 3. period configuration: TC0DRC
//------ ------ ------ ------ ------ ------
    TC0DRCL         = 0x80;             // period setup register (low byte)        128
    TC0DRCH         = 0x00;             // period setup register (high byte)

//------ ------ ------ ------ ------ ------
// 4. timer control: TC0CR3
//------ ------ ------ ------ ------ ------
    TC0CR3_STM      = 0x00;             // STM: select the state when stopped. select continuous or one-time output.
                //  --------|---------------------|----------------------------------
                //          | TCCST=1             | TCCST=0
                //  --------|---------------------|----------------------------------
                //    0x00: | continuous output   | immediately stop and clear the counter with the output initialized
                //    0x01: | continuous output   | immediately stop and clear the counter with the output initialized
                //    0x02: | one-time output     | stop the counter after completing output in the current period
                //    0x03: | reserved            | reserved
                //  --------|---------------------|----------------------------------

}


//*********************************************************************
// name			: TCC0_PPGC0x_Start
// brief		: start TCC0
// note			:
//*********************************************************************
void TCC0_PPGC0x_Start(void)
{
    TC0CR3_TCCST    = 1;                
}


//*********************************************************************
// name			: TCC0_PPGC0x_Stop
// brief		: stop TCC0
// note			: 
//*********************************************************************
void TCC0_PPGC0x_Stop(void)
{
    TC0CR3_TCCST    = 0;                
}


//*********************************************************************
// name			: TCC0_PPGC0x_IntEnable
// brief		: enable TCC0P and TCC0T interrupts
// note			:
//*********************************************************************
void TCC0_PPGC0x_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTCC0T     = 0;                // clear interrupt latch
    EI_INTTCC0T     = 1;                // set interrupt enable flag
    IL_INTTCC0P     = 0;                // clear interrupt latch
    EI_INTTCC0P     = 1;                // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: TCC0_PPGC0x_IntDisable
// brief		: disable TCC0P and TCC0T interrupts
// note			:
//*********************************************************************
void TCC0_PPGC0x_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTCC0T     = 0;                // clear interrupt latch
    EI_INTTCC0T     = 0;                // clear interrupt enable flag
    IL_INTTCC0P     = 0;                // clear interrupt latch
    EI_INTTCC0P     = 0;                // clear interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: IntTCC0T
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTCC0T(void)
{
    NOP;                                // no operation
}



//*********************************************************************
// name			: IntTCC0P
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTCC0P(void)
{
    NOP;                                // no operation
}




