//******************************************
// file			: MQ6835_LVD.c
// version		: V1.0 2019/04/19
// brief		: LVD related functions
// note			: LVD related functions are gathered in this subroutine
//******************************************

#include "main.h"

//*********************************************************************
// name			: LVD_Init
// brief		: LVD related setting, set VD1 to 4.2V+/- 0.2V and trigger reset after detection
// note			: this function waits in a loop until the system has stabilized before completing the setup
//*********************************************************************
void LVD_Init(){	
    /* ------- select VDCR1_VD2LVL --------- */
	// 			0: 2.85V +/- 0.1V
    // 			1: 2.65V +/- 0.1V
    // 			2: 2.35V +/- 0.1V
    // 			3: 2.00V +/- 0.1V
	/* ------- select VDCR1_VD1LVL --------- */ 
	// 			0: 4.50V +/- 0.2V
    // 			1: 4.20V +/- 0.2V
    // 			2: 3.70V +/- 0.15V
    // 			3: 3.15V +/- 0.15V

    VDCR1_VD1LVL 	= 1;                // select detction voltage to 4.2V
                        
	// set to generate a interrupt signal first and wait for the system to stabilize before setting to generate a reset signal												
    VDCR2_VD1MOD 	= 0;				// set VD1 to gernerate a interrupt signal
	EI_INTLVD 	 	= 0;				// disable LVD interrupt
	IL_INTLVD 	 	= 0;				// clear LVD interrupt flag	
	VDCR2_VD1EN  	= 1; 				// enable VD1	
	delay_times(t_100us,1);				// 100us delay ensures system stability
	
	while(IL_INTLVD == 1){				 
		CLR_WDT;						// clear the watchdog timer
		IL_INTLVD	= 0;				// clear LVD interrupt flag 	
	}	
	VDCR1_VD1F      = 0;				// clear VD1F
	// ---
	
	// selects the operation mode of voltage to generates a voltage detection reset signal
	VDCR2_VD1MOD	= 1;				// 0 : Generates a voltage detection interrupt request signal
                                        // 1 : Generates a voltage detection reset signal
										
}
//*********************************************************************
// name			: LVD_IntEnable
// brief		: enable LVD interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void LVD_IntEnable(){   
    DI;
    IL_INTLVD = 0;                      // clear LVD interrupt flag
    EI_INTLVD = 1;                      // enable LVD interrupt
    EI; 
}
//*********************************************************************
// name			: LVD_IntDisable
// brief		: disable LVD interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void LVD_IntDisable(){  
    DI;
    EI_INTLVD = 0;                      // disable LVD interrupt
    IL_INTLVD = 0;                      // clear LVD interrupt flag    
    EI; 
}

//*********************************************************************
// name			: LVD_Stop
// brief		: disable LVD
// note			: 
//*********************************************************************
void LVD_Stop(){
     VDCR2_VD1EN = 0;                   
}

//*********************************************************************
// name			: __interrupt IntVLTD
// brief		: LVD interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntVLTD(void){    
     NOP;
}
