//******************************************
// file			: main.c
// version		: V1.0 2021/09/13
// brief		: main program
// note			:
// 1. set reference voltage to internal 2V and analog input channel to AIN7
// 2. in this example, since the ADC reference voltage is set to 2V, the input voltage range is 0V to 2V during simulation
// 3. to change the ADC reference voltage, make changes in MQ6835_ADC.c and MQ6835_ADC.h
// 
//  when simulating the ADC function, please try to set the breakpoints in the main program such as the NOP above
//  also in the simulation options there is a preset ==> Stop Peripheral when pausing, change it to ==> Don't Stop All Peripheral
//  toggling the selection allows the peripheral circuit function to continue to operate while the simulation is paused
//  this setting option can be found next to the IDE shortcut keys for emulation, single-step execution, or please refer to the IDE documentation  
//***************************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif

#include "main.h"


BIT_LIST_8  _flag_8bit;
BIT_LIST_16 _flag_16bit;
/* ---------------------- global variables ------------------------------ */

/* ---------------------- main program -------------------------------- */
void main(){
    /* ---------------------- system initialization ------------------------ */
    SYSTEM_INIT();


    /* ---------------------- ADC initialization ------------------- */
	// 1. use the internal circuit generate 2V as ADC reference voltage source, and change the code in ADC_Init()according to the requirement
	// 2. set analog input channel to AIN7
	// 3. to use repeat mode, change the code in ADC_Init() as required
  	      P4FC_P7 = 1;					// set P47 to special function pin
    	  P4CR_P7 = 0;					// set P47 as input pin
          ADC_Init(AIN7);

    //-----------------------------------
    //  perform this procedure once to get the actual value of internal Vref 2V
    //  MQ6835:readout value is the actual value of internal Vref 2V multiplied by 1024 and its unit is mV
        iReal_Vref2V = GetVref();
    //  data2Port[0] = ((iReal_Vref2V/100)%100);
    //  data2Port[1] = ((iReal_Vref2V/  1)%100);
    //  sendout_I2C(88); sendout_I2C(data2Port[0]); sendout_I2C(data2Port[1]);
    //-----------------------------------


//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    while(1)
    {
        CLR_WDT;                        // clear the watchdog timer

        NOP;                            // no operation
        NOP;                            // no operation
        NOP;                            // no operation

        ADC_Code_READ = ADC_repeat_detect(AIN7);

        NOP;                            // no operation
        NOP;                            // no operation
        NOP;                            // no operation
        
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


















/*---------------------- interrupt service routine ------------------------*/
void __interrupt OnlyReti(void)
{
    NOP;                                // no operation
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntSWI(void)
{
#define		SWI_ADDR_RETRY_MAX	    		(200)  // same return max retry times
    //unsigned short rtn_addr;
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };
	
	// Is Invalid Op Code
    for ( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10;	// invalid opcode(s) --> system clock reset
    }
	
    // adjust address for return from IntSWI //
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
	
#if 0	
    rtn_addr = 	(*(unsigned short *)(__SP + (6 * 2) + 1));
	   
	// if same swi occurse several times, then reset MCU
	if(swi_Return_addr == rtn_addr)
	{
	    swi_Count++;
	    if(swi_Count >  SWI_ADDR_RETRY_MAX)
			SYSCR2 = 0x10;	// invalid opcode(s) , system  reset
    }
	else
	    swi_Count=0;

    swi_Return_addr = rtn_addr;
#endif	
	
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");
}
/*----------------- end of interrupt service routine ------------------------*/

/*------------------------ interrupt vector ------------------------*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
    OnlyReti,           // 0xffc0 : IntTCC0T
    OnlyReti,           // 0xffc2 : IntTCC0P
    OnlyReti,           // 0xffc4 : IntTC05
    OnlyReti,           // 0xffc6 : IntTC04
    OnlyReti,           // 0xffc8 : IntTCA1
    OnlyReti,           // 0xffca : IntSIO1
    OnlyReti,           // 0xffcc : IntTC03
    OnlyReti,           // 0xffce : IntTC02
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    OnlyReti,           // 0xffd4 : Int5
    OnlyReti,           // 0xffd6 : Int4
    OnlyReti,           // 0xffd8 : Int3 / IntCMP1
    OnlyReti,           // 0xffda : Int2 / IntCMP0 / IntEMG0
    OnlyReti,           // 0xffdc : Int1 / IntCMP2
    OnlyReti,           // 0xffde : Int0 / IntCMP3
    OnlyReti,           // 0xffe0 : IntSBI
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,           // 0xffec : IntLVD
    OnlyReti,           // 0xffee : IntTXD0
    OnlyReti,           // 0xfff0 : IntRXD0
    OnlyReti,           // 0xfff2 : IntSIO0
    OnlyReti,           // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI / INTUNDEF
    STARTUP             // 0xfffe : RESET
};
#pragma section const
/*------------------- end of interrupt vector ------------------------*/

















//*********************************************************************
// name			: SYSTEM_INIT(void)
// brief		: IO, CGCR and P10/P40/P41 initialization during debugging
// note			:
//*********************************************************************
void SYSTEM_INIT(void)
{
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  (default): when emulation, set P10 to Reset pin to avoid affecting the emulation and program functions
//  SET_P10_to_RESET_PIN;
//------------------------------------------------------------------
    FSCTRL_FSSEL = 0;                   // if the program has changed this bit, you need to manually initialize and clear it to the default value of 0 in the emulation mode 
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode), set P10 to GPIO pin
//------------------------------------------------------------------
//-- set P10 to GPIO pin ------
    SET_P10_to_IO_PIN;
//------------------------------------------------------------------
#endif



//-- pin configuration initialization (debug pin configuration)------
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  the simulation uses P10, P40 and P41 into Debug mode, which is set as an input during simulation
//  to avoid affecting the emulation and program functions
    P1DR = 0x00;
    P1CR = set8bit(11111110);           // set P10 as input pin
    P4DR = 0x00;
    P4CR = set8bit(11111100);           // set P40 and P41 as input pins
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- pin configuration initialization ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;
    P5DR = 0x00;
    P5CR = 0xff;
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;

    CLR_WDT;                            // clear the watchdog timer
}

//*********************************************************************
// name			: delay_times
// brief		: time delay function
// note			: ==> t_1ms   = 0;          // time delay unit ms
//          : ==> t_100us = 1;          // time delay unit us (this accuracy is not good)
//          : the example of using a fixed loop with a time delay is as follows:
//          : delay_times(t_1ms, 800);  // delay 800ms
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
    uint  i, cgcrT;

//  uchar cgcrF[4]={ 2, 4,  8, 1 };     // use this array when the high-speed crystal frequency is 8MHz
    uchar cgcrF[4]={ 4, 8, 16, 2 };     // use this array when the high-speed crystal frequency is 16MHz

//  the time delay function of the system at NORMAL1 mode and NORMAL2 mode
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  the time delay function of the system at SLOW1 mode and SLOW2 mode), which has a large error, is used for reference
    else for(; x>0; x--){}

    CLR_WDT;                            // clear the watchdog timer
}
