//******************************************
//           This is a C Template file
//ߣ
//
//
//ע
//******************************************
//******************************************
//Stack Pointer	=	0x43f (If use MQ6833_startup.asm)
//Ram range = 0x40~0x43f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "MQ6833.h"
#include "iApp.h"
#include "OPmode.h"
#include "FlashFunction.h"



#pragma section const DataFlashArea	0xD000
const uchar dataflash[0x580] = {
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  0
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  1
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  2
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  3
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  4
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  5
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  6
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  7
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  8
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	//  9
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 10
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 11
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 12
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 13
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88,	// 14
								0X88, 0X88, 0X88, 0X88,    0X88, 0X88, 0X88, 0X88	// 15
							};
#pragma section const

uchar varlist[0x81] = {
						0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
						0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38
	 				};
//--------------------------------------------------------------------------------------------------//
//	 <OPmode.h> ⲿ ( or ), ο˵
//	ⲿپ HXTAL(P00/P01)
//	ⲿپ LXTAL(P02/P03)
//.....................................................................................
//#undef	XTAL_High		// ⲿپ: #define(ʹþ) / #undef(þ) :
//#define	XTAL_Low		// ⲿپ: #define(ʹþ) --> MQ6833 ڲپѡⲿ :
//--------------------------------------------------------------------------------------------------//

uchar varbyte = 0x55;

void SYSTEM_INIT(void);


void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨 ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt

	Flash_SEC_ERS(0xD000, Erase_128byte);

	Flash_PGM_Byte(0xD000,   1, &varbyte);

	Flash_PGM_Byte(0xD002,   1, &varlist[5]);
	Flash_PGM_Byte(0xD005,   3, &varlist[2]);
	Flash_PGM_Byte(0xD010,   5, &varlist[0]);


	varbyte = FlashReadByte(0xD010);
	FlashReadSequence(0xD002,   1, &varbyte);

	FlashReadSequence(0xD002,   1, varlist);
	FlashReadSequence(0xD002,   1, &varlist[1]);
	FlashReadSequence(0xD00f,  10, &varlist[2]);

	Flash_SEC_ERS(0xD000, Erase_1024byte);
	Flash_PGM_Byte(0xD000, 129, varlist);

	WDCDR.byte = 0x4e;				// clear wdt


	Flash_SEC_ERS(0xD000, Erase_128byte);

	Flash_PGM_Byte(0xD000, 8, varlist);

	Flash_SEC_ERS(0xD000, Erase_1024byte);


	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt

		__asm("CPL (_P9DR).1");		// toggle IO
		__asm("CPL (_P9DR).1");		// toggle IO
		__asm("CPL (_P9DR).1");		// toggle IO
		__asm("CPL (_P9DR).1");		// toggle IO
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}



//*********************************************************************
// 	: SYSTEM_INIT(void)
// 	: IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
// ע		:
//*********************************************************************
void SYSTEM_INIT(void)
{
#ifdef _DEBUG	//...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//	(ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//	SYSCR3.byte   = 0x00;	// SYSCR3.bit.b0=1: P10趨ΪһIO, SYSCR3.bit.b0=0(Ԥֵ): P10Ϊ Reset Pin
//	SYSCR4.byte   = 0xB2;	// 0xB2:  SYSCR3.bit.b0 ֮趨ֵ
//------------------------------------------------------------------
#else			//...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
	SYSCR3.byte = 0x01;		// SYSCR3.bit.b0=1: P10趨ΪһIO, SYSCR3.bit.b0=0(Ԥֵ): P10Ϊ Reset Pin
	SYSCR4.byte = 0xB2;		// 0xB2:  SYSCR3.bit.b0 ֮趨ֵ
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG	//...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//	 P10/P20/P21  Debug modeڷʱ趨Ϊ룬
//	ԱӰ漰¼.
	P1DR.byte = 0x00;
	P1CR.byte = set8bit(11111110);		//  P10 Ϊ
	P2DR.byte = 0x00;
	P2CR.byte = set8bit(11111100);		//  P20/P21 Ϊ
//------------------------------------------------------------------
#else			//...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
	P1DR.byte = 0x00;
	P1CR.byte = 0xff;
	P2DR.byte = 0x00;
	P2CR.byte = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
	P0DR.byte = 0x00;
	P0CR.byte = 0xff;
//	P1DR.byte = 0x00;
//	P1CR.byte = 0xff;
//	P2DR.byte = 0x00;
//	P2CR.byte = 0xff;
	P4DR.byte = 0x00;
	P4CR.byte = 0xff;
	P7DR.byte = 0x00;
	P7CR.byte = 0xff;
	P9DR.byte = 0x00;
	P9CR.byte = 0xff;
	WDCDR.byte = 0x4e;			// clear wdt


//	============================================
//	پƵãCGCR				;MQ6833 fc = 8MHz
//	============================================
	CGCR.byte = 0x00;			// ==> fcgck = fc/4 =  2Mhz(ϵͳĬ)
//	CGCR.byte = 0x01;			// ==> fcgck = fc/2 =  4Mhz
//	CGCR.byte = 0x02;			// ==> fcgck = fc   =  8Mhz
//	============================================
//	*** 벻Ҫڵģʽ(SLOW1/SLOW2) ı CGCR<FCGCKSEL> Ĵֵ
//	============================================


//--------------------------------------------------------------------------------------------------//
//	 <OPmode.h> ⲿ ( or ), ο˵
//	ⲿپ HXTAL(P00/P01)
//	ⲿپ LXTAL(P02/P03)
//.....................................................................................
//#undef	XTAL_High		// ⲿپ: #define(ʹþ) / #undef(þ) :
//#define	XTAL_Low		// ⲿپ: #define(ʹþ) --> MQ6833 ڲپѡⲿ :
//--------------------------------------------------------------------------------------------------//
//	кѡǷлⲿپ
	XTAL_High_Config();

}



void all_operation_mode_seq(void)
{
//----------------------------------------//
//****** Power on Ϊ Normal1 mode ******//
//----------------------------------------//

//	Normal1 entry stop mode ............	
	Active_STOP;					// ˷ KWI5  STOP mode
	

//	Normal1 entry IDLE0 mode ............
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE0;					// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	

//	Normal1 entry IDLE1 mode ............
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE1;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	

//----------------------------------------//
//****** Entry Normal2 mode **************//
//----------------------------------------//
	OpMode_Change_to(iNor2);		// ѡҪĹģʽ (iNor1/iNor2/iSlow2/iSlow1) ֮һ

//	Normal2 entry stop mode ............
	Active_STOP;					// ˷ KWI5  STOP mode
	

//	Normal2 entry IDLE2 mode ............
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE2;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	

//----------------------------------------//
//****** Entry SLOW2 mode ****************//
//----------------------------------------//
	OpMode_Change_to(iSlow2);		// ѡҪĹģʽ (iNor1/iNor2/iSlow2/iSlow1) ֮һ

//----------------------------------------//
//****** Entry SLOW1 mode ****************//
//----------------------------------------//
	OpMode_Change_to(iSlow1);		// ѡҪĹģʽ (iNor1/iNor2/iSlow2/iSlow1) ֮һ

//	SLOW1 entry stop mode ............
	Active_STOP;					// ˷ KWI5  STOP mode

//	SLOW1 entry SLEEP0 mode ............
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_SLEEP0;					// TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode

//	SLOW1 entry SLEEP1 mode ............
	INTTBT_Init_OP();				// initial TBT timer setting
									// ˷ TBT  IDLE1/IDLE2/SLEEP1 mode
	Active_SLEEP1;					// IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
//----------------------------------------//
//----------------------------------------//
}



