
//******************************************
//Stack Pointer	=	0x43f (If use MQ6833_x_startup.asm)
//Ram range = 0x240~0x43f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "MQ6833.h"
#include "iApp.h"
#include "OPmode.h"
#include "SIO.h"




uchar wBUF_data[16]={0x50,0x01,0x00,0x80, 0x9f,0x00,0x00,0x00,   0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff};
uchar rBUF_data[16]={0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,   0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff};


//--------------------------------------------------------------------------------------------------//
//	 <OPmode.h> ⲿ ( or ), ο˵
//	ⲿپ HXTAL(P00/P01)
//	ⲿپ LXTAL(P02/P03)
//.....................................................................................
//#undef	XTAL_High		// ⲿپ: #define(ʹþ) / #undef(þ) :
//#define	XTAL_Low		// ⲿپ: #define(ʹþ) --> MQ6833 ڲپѡⲿ :
//--------------------------------------------------------------------------------------------------//



void SYSTEM_INIT(void);
void TC0_init(void);
void INTTBT_Init(void);

uchar SST25_ReadState(void);
void SST25_WaitBusy(void);
void SST25_Write_Enable(void);
void SST25_Write_Disable(void);
enum SST25_Enum{SST25_ReadID	= 0x9F,
				SST25_WRSR		= 0x01,
				SST25_Write		= 0x02,
				SST25_Read		= 0x03,
				SST25_WriteDis	= 0x04,
				SST25_WriteEN	= 0x06,
				SST25_Erase4K	= 0x20,
				SST25_EWSR		= 0x50};

void main()
{
	uchar iloop;
//----------------------------------------------------------------------//
//****** IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨 ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt



	SIO_Init();



// ======================================================================
// Ϊ SIO 䣬ԱоƬ MASTERSPI Flash(SST25V04)
// P23-SO  (Serial Out, DO)  ©ţ100K Ohm
// P24-SI  (Serial In , DI)  ©ţ100K Ohm
// P25-SCLK(Serial CLocK)
// P76-#CS  (ʹGPIOģ)
// ======================================================================


delay_times(t_1ms, 1);
//	SST25VF040B Setup
if(1)
{
	wBUF_data[0] = SST25_EWSR;		
	SIO_ByteSend(wBUF_data, 1);
	SPI_Reserved_Stop_Wait();

	wBUF_data[0] = SST25_WRSR;
	wBUF_data[1] = 0x00;			// Disable all memory W/E protection
	SIO_ByteSend(wBUF_data, 2);
	SPI_Reserved_Stop_Wait();
}


//	ȡ Device ID: 0xBF 0x25 0x8D
if(1)
{
	wBUF_data[0] = SST25_ReadID;	// дһ byte command
	SIO_ByteSend(wBUF_data, 1);

	SIO_ByteRead(rBUF_data, 3);
}
	WDCDR.byte = 0x4e;				// clear wdt


delay_times(t_1ms, 1);
//	ȡ Slave Data
if(1)
{
	wBUF_data[0] = SST25_Read;	
	wBUF_data[1] = 0x00;			// ADDR msb
	wBUF_data[2] = 0x00;			// ADDR
	wBUF_data[3] = 0x00;			// ADDR lsb
	SIO_ByteSend(wBUF_data, 4);

	SIO_ByteRead(rBUF_data, 10);
}
	WDCDR.byte = 0x4e;				// clear wdt


delay_times(t_1ms, 1);
//	Erase 4K
if(1)
{
	wBUF_data[0] = SST25_WriteEN;	// Write enable
	SIO_ByteSend(wBUF_data, 1);
	SPI_Reserved_Stop_Wait();

	wBUF_data[0] = SST25_Erase4K;	// Sector erase  4K command for SST25VF: SPI Serial Flash
	wBUF_data[1] = 0x00;			// Chip erase command for SST25VF: SPI Serial Flash
	wBUF_data[2] = 0x00;			// Chip erase command for SST25VF: SPI Serial Flash
	wBUF_data[3] = 0x00;			// Chip erase command for SST25VF: SPI Serial Flash
	SIO_ByteSend(wBUF_data, 4);
	SPI_Reserved_Stop_Wait();

	SST25_WaitBusy();

	wBUF_data[0] = SST25_WriteDis;	// Write disable
	SIO_ByteSend(wBUF_data, 1);
	SPI_Reserved_Stop_Wait();
}


delay_times(t_1ms, 1);
//	ȡ Slave Data
if(1)
{
	wBUF_data[0] = SST25_Read;	
	wBUF_data[1] = 0x00;			// ADDR msb
	wBUF_data[2] = 0x00;			// ADDR
	wBUF_data[3] = 0x00;			// ADDR lsb
	SIO_ByteSend(wBUF_data, 4);

	SIO_ByteRead(rBUF_data, 10);
}
	WDCDR.byte = 0x4e;				// clear wdt


delay_times(t_1ms, 1);
//	д Slave Data
//	SST25VF040B Write one byte
if(1)
{

	wBUF_data[0] = SST25_WriteEN;	// Write enable
	SIO_ByteSend(wBUF_data, 1);
	SPI_Reserved_Stop_Wait();

	wBUF_data[0] = SST25_Write;		// to PGM one byte
	wBUF_data[1] = 0x00;			// ADDR msb
	wBUF_data[2] = 0x00;			// ADDR
	wBUF_data[3] = 0x00;			// ADDR lsb

	wBUF_data[4] = 0x5a;			// PGM data

	SIO_ByteSend(wBUF_data, 5);
	SPI_Reserved_Stop_Wait();

	SST25_WaitBusy();

	wBUF_data[0] = SST25_WriteDis;	// Write disable
	SIO_ByteSend(wBUF_data, 1);
	SPI_Reserved_Stop_Wait();
}
	WDCDR.byte = 0x4e;				// clear wdt


delay_times(t_1ms, 1);
//	ȡ Slave Data
if(1)
{
	wBUF_data[0] = SST25_Read;	
	wBUF_data[1] = 0x00;			// ADDR msb
	wBUF_data[2] = 0x00;			// ADDR
	wBUF_data[3] = 0x00;			// ADDR lsb	
	SIO_ByteSend(wBUF_data, 4);

	SIO_ByteRead(rBUF_data, 10);
}
	WDCDR.byte = 0x4e;				// clear wdt





//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt		
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}



//*********************************************************************
// 	: SYSTEM_INIT(void)
// 	: IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
// ע		:
//*********************************************************************
void SYSTEM_INIT(void)
{
#ifdef _DEBUG	//...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//	(ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//	SYSCR3.byte   = 0x00;	// SYSCR3.bit.b0=1: P10趨ΪһIO, SYSCR3.bit.b0=0(Ԥֵ): P10Ϊ Reset Pin
//	SYSCR4.byte   = 0xB2;	// 0xB2:  SYSCR3.bit.b0 ֮趨ֵ
//------------------------------------------------------------------
#else			//...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
	SYSCR3.byte = 0x01;		// SYSCR3.bit.b0=1: P10趨ΪһIO, SYSCR3.bit.b0=0(Ԥֵ): P10Ϊ Reset Pin
	SYSCR4.byte = 0xB2;		// 0xB2:  SYSCR3.bit.b0 ֮趨ֵ
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG	//...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//	 P10/P20/P21  Debug modeڷʱ趨Ϊ룬
//	ԱӰ漰¼.
	P1DR.byte = 0x00;
	P1CR.byte = set8bit(11111110);		//  P10 Ϊ
	P2DR.byte = 0x00;
	P2CR.byte = set8bit(11111100);		//  P20/P21 Ϊ
//------------------------------------------------------------------
#else			//...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
	P1DR.byte = 0x00;
	P1CR.byte = 0xff;
	P2DR.byte = 0x00;
	P2CR.byte = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
	P0DR.byte = 0x00;
	P0CR.byte = 0xff;
//	P1DR.byte = 0x00;
//	P1CR.byte = 0xff;
//	P2DR.byte = 0x00;
//	P2CR.byte = 0xff;
	P4DR.byte = 0x00;
	P4CR.byte = 0xff;
	P7DR.byte = 0x00;
	P7CR.byte = 0xff;
	P9DR.byte = 0x00;
	P9CR.byte = 0xff;
	WDCDR.byte = 0x4e;			// clear wdt


//	============================================
//	پƵãCGCR				;MQ6833 fc = 8MHz
//	============================================
	CGCR.byte = 0x00;			// ==> fcgck = fc/4 =  2Mhz(ϵͳĬ)
//	CGCR.byte = 0x01;			// ==> fcgck = fc/2 =  4Mhz
//	CGCR.byte = 0x02;			// ==> fcgck = fc   =  8Mhz
//	============================================
//	*** 벻Ҫڵģʽ(SLOW1/SLOW2) ı CGCR<FCGCKSEL> Ĵֵ
//	============================================


//--------------------------------------------------------------------------------------------------//
//	 <OPmode.h> ⲿ ( or ), ο˵
//	ⲿپ HXTAL(P00/P01)
//	ⲿپ LXTAL(P02/P03)
//.....................................................................................
//#undef	XTAL_High		// ⲿپ: #define(ʹþ) / #undef(þ) :
//#define	XTAL_Low		// ⲿپ: #define(ʹþ) --> MQ6833 ڲپѡⲿ :
//--------------------------------------------------------------------------------------------------//
//	кѡǷлⲿپ
	XTAL_High_Config();

}



//*********************************************************************
// 	: TC0_init(void)
// 	:
// ע		:
//*********************************************************************
void TC0_init(void)
{
	__asm("DI");
	POFFCR0.bit.b4	= 1;		// TC00EN
	EIRH.bit.b4		= 1;		// [-,INTTCA0,INTTC01,INTTC00	INTRTC,INTADC,INTLVD,-]
								//  INTTC00
	__asm("EI");
	T00MOD.byte		= 0xE8;		// <TCK0>=101=fcgck/4, <TCM0>='00' 8λʱģʽ

	T00REG.byte		= 0x40;		// öʱֵ
	T001CR.bit.b0	= 1;		// T00RUN ==> 1: 
}
//*********************************************************************



//*********************************************************************
// 	: INTTBT_Init(void)
// 	:
// ע		:
//*********************************************************************
void INTTBT_Init(void)
{
							// -----|-------------|----------|----------|
							//      |          Normal        |   SLOW   |
							// -----|-------------|----------|----------|
							//      |   DV9CK=0   | DV9CK=1  |----------|
							// -----|-------------|----------|----------|
							// 000: | fcgck/2^22  | fs/2^15  | fs/2^15  |
							// 001: | fcgck/2^20  | fs/2^13  | fs/2^13  |
							// 010: | fcgck/2^15  | fs/2^8   | Reserved |
							// 011: | fcgck/2^13  | fs/2^6   | Reserved |
							// 100: | fcgck/2^12  | fs/2^5   | Reserved |
							// 101: | fcgck/2^11  | fs/2^4   | Reserved |
							// 110: | fcgck/2^10  | fs/2^3   | Reserved |
							// 111: | fcgck/2^8   | Reserved | Reserved |
							// -----|-------------|----------|----------|
	TBTCR.byte    = 0x05;	// TBTCR[2:0]<TBTCK>: 0~7, default=0
	SYSCR1.bit.b4 = 0;		// DV9CK: 0.fcgck, 1.fs/4
//..........................................................................................
	__asm("DI");
	ILL.bit.b5    = 0;		// need clear interrupt latch first
	EIRL.bit.b5   = 1;		// INTTBT enable
	TBTCR.bit.b3  = 1;		// start TBT
	__asm("EI");
//..........................................................................................
}



//*********************************************************************
// 	: SST25_ReadState()
// 	:
// ע		:
//	--------:----------------------------------------------------------
//*********************************************************************
uchar SST25_ReadState(void)
{
	uchar readRegCmd[1] = {0x05};
	uchar regState[1], retValue;

//	Start , Send Read State Register command     , Continue comunication
	SIO_ByteSend(readRegCmd, 1);

//	Receive 1 byte data of State Register, Stop comunication
	SIO_ByteRead(regState, 1);

	retValue = regState[0];
	return retValue;
}


//*********************************************************************
// 	: SST25_WaitBusy()
// 	:
// ע		:
//	--------:----------------------------------------------------------
//*********************************************************************
void SST25_WaitBusy(void)
{
	while((SST25_ReadState()&0x01)==0x01)
	{
		WDCDR.byte = 0x4e;			// clear wdt
	}
}


//*********************************************************************
// 	: SST25_Write_Enable()
// 	:
// ע		:
//	--------:----------------------------------------------------------
//*********************************************************************
void SST25_Write_Enable(void)
{
	uchar WriteCmd[1] = {0x06};

	SIO_ByteSend(WriteCmd, 1);
	SPI_Reserved_Stop_Wait();
}


//*********************************************************************
// 	: SST25_Write_Disable()
// 	:
// ע		:
//	--------:----------------------------------------------------------
//*********************************************************************
void SST25_Write_Disable(void)
{
	uchar WriteCmd[1] = {0x04};

	SIO_ByteSend(WriteCmd, 1);
	SPI_Reserved_Stop_Wait();
}





