
#include "MQ6833.h"
#include "iApp.h"


//	delay_times(t_1ms, 800);				//  Normal mode, Slow mode
//void delay_times(uchar tBase, uint x);	//  Normal mode, Slow mode
//.....................|...........| x: 趨ӳʱ
//.....................| tBase: 趨ӳٵλ: t_1ms/t_100us ...
//#define t_1ms		0
//#define t_100us	1



//*********************************************************************
// 	: delay_times(uchar tBase, uint x)
// 	: ʱ
// ע		: ==> t_1ms   = 0;
// 			: ==> t_100us = 1;
// 			: ...
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
	uint  i, cgcrT;

	uchar cgcrF[4]={ 2, 4,  8, 1 };	// HIRC =>  8MHz
//	uchar cgcrF[4]={ 4, 8, 16, 2 };	// HIRC => 16MHz

//	...... ...... ...... delay for HIRC ...... ...... ......
	if( SYSCR2.bit.b4 == 0 )
	{
		cgcrT = cgcrF[CGCR.byte];		//0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
		switch(tBase){
			case 0:		// t_1ms
				cgcrT *= 110;
				for(; x>0; x--)
					for(i=0; i<cgcrT; i++){}
				break;
			case 1:		// t_100us
				cgcrT *= 11;
				for(; x>0; x--)
					for(i=0; i<cgcrT; i++){}
				break;
		}
	}
//	...... ...... ...... delay for LIRC ...... ...... ......
	else for(; x>0; x--){}

	WDCDR.byte=0x4e; 			//clear wdt
}




//*********************************************************************
// 	: look_data()
// 	: IO output data by IO_i2c
// ע		:  I2C ʽϲӷǹۿ
//*********************************************************************
void look_data(uchar data)
{
	uchar iloop, x, z=10;

	look_SDA_cr = 1;	// setting output port
	look_SCL_cr = 1;	// setting output port

//	start condition......
	look_SDA = 1;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 0;		for(x=z; x>0; x--){}

//	sent byte data......
	for( iloop=0; iloop<8; iloop++ )
	{
		look_SDA = data >> 7;
		data     = data << 1;
						for(x=z; x>0; x--){}
		look_SCL = 1;	for(x=z; x>0; x--){}
		look_SCL = 0;	for(x=z; x>0; x--){}
	}
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SCL = 0;		for(x=z; x>0; x--){}

//	stop condition......
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SDA = 1;		for(x=z; x>0; x--){}
}


void DVOB_init_and_try()
{
	P7FC.bit.b4   = 1;
	P7CR.bit.b4   = 1;
//	SYSCR1.bit.b4 = 1;		// DV9CK=1 for fs
	DVOCR.byte    = 0x00;	// setting DVOB register
	DVOCR.bit.b2  = 1;		// start DVOB output
}































