//******************************************
// file			: MQ6832_TC0_16Bit
// version		: V1.0
// brief		: 16-bit TC0 related functions
// note			: 16-bit TC0 related functions are gathered in this subroutine
//******************************************

#include "main.h"

//*********************************************************************
// name			: T001_16BitTimer_Init
// brief		: T001_16BitTimer_Init initialization
// note			:
//*********************************************************************
void T001_16BitTimer_Init(void)
{
//====== pin configuration ======

//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T001CR_TCAS     = 1;                // cascade timers 
    T01MOD_TFF      = 1;                // set initial state of function pin to high    

    T01MOD_TCM      = 0;                // set operation mode to 16-bit timer mode  
    T01MOD_DBE      = 1;                // enable the double buffer
    T01MOD_TCK      = 5;                // fcgck/4 = 1MHz,   
    
    T00REG          = 100;
    T01REG          = 200;              // Timer Period =    51300          / 1MHz = 51.3 ms
                                        //               (200*256 + 100)
    
    NOP;                                // no operation
}

//*********************************************************************
// name			: T001_16BitPPG_Init
// brief		: T001_16BitPPG_Init initialization
// note			:
//*********************************************************************
void T001_16BitPPG_Init(void)
{
//====== pin configuration ======
    P7DR_P1         = 1;                // set pin to output high (suggest output level as the same as the value of T0xMOD_TFF)
    P7CR_P1         = 1;                // set pin to output pin

//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T001CR_TCAS     = 1;                // cascade timers 
    T01MOD_TFF      = 1;                // set initial state of function pin to high    
//  set function pins after function initialization
    P7FC_P1         = 1;                // set pin function to PPG mode
    
    T01MOD_TCM      = 3;                // set operation mode to 16-bit PPG mode
    T01MOD_DBE      = 1;                // enable the double buffer
    T01MOD_TCK      = 7;                // TCK = fcgck = 16MHz,   
    
    T00REG          = 50;
    T01REG          = 100;              // Timer Period =    25650          / 16MHz  =  1.6 ms
                                        //               (100*256 + 50)
    
    T00PWM          = 40;   
    T01PWM          = 80;              // Duty = 20520 / 25650  = 80%
    
    NOP;                                // no operation
}


//*********************************************************************
// name			: T001_16Bit_Start
// brief		: start to run 16-bit TC0
// note			:
//*********************************************************************
void T001_16Bit_Start(void)
{
    T001CR_T01RUN = 1;
}


//*********************************************************************
// name			: T001_16Bit_Stop
// brief		: stop runnning 16-bit TC0
// note			:
//*********************************************************************
void T001_16Bit_Stop(void)
{
    T001CR_T01RUN = 0;
}


//*********************************************************************
// name			: T001_16Bit_IntEnable
// brief		: enable TC001 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void T001_16Bit_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTC01 = 0;                     // clear interrupt latch
    EI_INTTC01 = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: T001_16Bit_IntDisable
// brief		: disable TC001 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void T001_16Bit_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTTC01 = 0;                     // clear interrupt enable flag
    IL_INTTC01 = 0;                     // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: T001_16Bit_SetDuty
// brief		: set duty cycle
// note			: duty cycle = [T01PWM:T00PWM] / [T01REG:T00REG]
//*********************************************************************
void T001_16Bit_SetDuty(uint pwmDuty)
{
    T00PWM = pwmDuty&0xff;              // set low-order first
    T01PWM = pwmDuty>>8;                // then high-order
}

//*********************************************************************
// name			: T001_16Bit_SetPeriod
// brief		: set period
// note			: 
//*********************************************************************
void T001_16Bit_SetPeriod(uint period)
{    
    T00REG = period&0xff;               // set low-order first
    T01REG = period>>8;                 // then high-order
}

//*********************************************************************
// name			: IntTC01
// brief		: TC01 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTC01(void)
{
    P9DR_P0 =!P9DR_P0;
    NOP;                                // no operation
}


























