//******************************************
// file			: MQ6832_TC0
// version		: V1.0
// brief		: TC0ʹú
// note			:
//******************************************

#include "main.h"




//*********************************************************************
// name			: TC00_Timer_Init
// brief		: TC00 8-bit timer mode initialization (set period to 100us)
// note			:
//*********************************************************************
void TC00_Timer_Init(void)
{
//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T00MOD_TCM      = 0;                // set operation mode to 8-bit timer/event counter modes
    T00MOD_TCK      = 5;                // fcgck/4 = 1MHz = 1us
    T00MOD_DBE      = 1;                // enable the double buffer
    T00REG          = 100;              // set counter value to 100
}


//*********************************************************************
// name			: TC00_PPG_Init
// brief		: TC00 8-bit PPG mode initialization (set period to 100us and duty cycle to 50%)
// note			:
//*********************************************************************
void TC00_PPG_Init(void)
{
//====== pin configuration ======
    P7DR_P0         = 1;                // set P70 to output high (suggest output level as the same as the value of T0xMOD_TFF)
    P7CR_P0         = 1;                // set P70 as output pin

//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T00MOD_TFF      = 1;                // set initial state of function pin to high
//	set function pins after function initialization
    P7FC_P0         = 1;                // set P70 as PPG function pin

    T00MOD_TCM      = 3;                // set operation mode to 8-bit PPG mode
    T00MOD_TCK      = 5;                // fcgck/4 = 1MHz = 1us
    T00MOD_DBE      = 1;                // enable the double buffer

    T00REG          = 100;              // set PPG period = 100us
    T00PWM          = 50;               // set PPG duty cycle = 50/100 = 50%
}


//*********************************************************************
// name			: TC00_PWM_Init
// brief		: TC00 8-bit PWM mode initialization (set period to 128us and duty cycle to 50%)
// note			:
//*********************************************************************
void TC00_PWM_Init(void)
{
//====== pin configuration ======
    P7DR_P0         = 1;                // set P70 to output high (suggest output level as the same as the value of T0xMOD_TFF)
    P7CR_P0         = 1;                // set P70 as output pin

//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T00MOD_TFF      = 1;                // set initial state of function pin to high
//	set function pins after function initialization
    P7FC_P0         = 1;                // set P70 as PWM function pin

    T00MOD_TCM      = 2;                // set operation mode to 8-bit PWM mode
    T00MOD_TCK      = 5;                // fcgck/4 = 1MHz = 1us
    T00MOD_DBE      = 1;                // enable the double buffer

// the pulse-width modulated pulses with a resolution of 7 bits are output in the 8-bit PWM mode. T00REG is invaild.
// 128 * 1us = 128us
    T00PWM          = 128;              // set PWM duty cycle = (128/2)/128 = 50%
}


//*********************************************************************
// name			: TC00_SetDuty
// brief		: set duty cycle
// note			: duty cycle : T00PWM/T00REG    (8-bit PPG mode)
//                 : (T00PWM/2) / 128 (8-bit PWM mode
//*********************************************************************
void TC00_SetDuty(uchar duty)
{
    T00PWM          = duty;
}

//*********************************************************************
// name			: TC00_SetPeriod
// brief		: set period
// note			: 
//*********************************************************************
void TC00_SetPeriod(uchar period)
{
    T00REG          = period;
}

//*********************************************************************
// name			: TC00_Start
// brief		: start TC00
// note			:
//*********************************************************************
void TC00_Start(void)
{
    T001CR_T00RUN   = 1;                // start to run TC00
}


//*********************************************************************
// name			: TC00_Stop
// brief		: stop TC00
// note			:
//*********************************************************************
void TC00_Stop(void)
{
    T001CR_T00RUN   = 0;                // ֹͣʱ
}


//*********************************************************************
// name			: TC00_IntEnable
// brief		: enable TC00 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TC00_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTC00      = 0;                // clear interrupt latch
    EI_INTTC00      = 1;                // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: TC00_IntDisable
// brief		: disable TC00 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TC00_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTTC00      = 0;                // clear interrupt enable flag
	IL_INTTC00      = 0;                // clear interrupt latch    
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: IntTC00
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTC00(void)
{    
	P9DR_P0 = !P9DR_P0;
    NOP;                                // no operation
}




























