//******************************************
// file			: MQ6832_SIO
// version		: V1.0
// brief		: SIO related functions
// note			: SIO related functions are gathered in this subroutine
//******************************************

#include "main.h"



uchar wBUF_data[16]={0x50,0x01,0x00,0x80, 0x9f,0x00,0x00,0x00,   0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff};
uchar rBUF_data[16]={0x11,0x22,0x33,0x44, 0x55,0x66,0x77,0x88,   0x99,0xaa,0xbb,0xcc, 0xdd,0xee,0xff,0xab};
uchar Device_ID[16]={0xaa,0x68,0x25,0x55, 0x66,0x77,0x88,0x99,   0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff};

uchar Device_CMD = 0x00;
uchar flag_CMD   = 0x00;
uchar pLoop;

//*********************************************************************
// name			: SIO_Init
// brief		: SIO initialization
// note			:
//*********************************************************************
void SIO_Init(void)
{
//====== pin configuration ======
//  set to master mode as follows
 
    P7CR_P4 = 0;                        // SI
    P7FC_P4 = 0;
    P7CR_P5 = 1;                        // SO
    P7FC_P5 = 1;
    P7CR_P6 = 1;                        // SCLK
    P7FC_P6 = 1;

    
    POFFCR2_SIO0EN = 1;                 // enable function
    SIO0CR_SIOEDG  = 0;                 // CPOL = 1, CPHA = 1
    SIO0CR_SIOCKS  = 0x00;              // select serial colck to fcgck/2^9
    SIO0CR_SIODIR  = 1;                 // MSB first (transfer from bit 7)
    SIO0CR_SIOM    = 0x03;              // 8-bit transmit and receive mode
	
    
 
//  set to slave mode as follows
/*
    P7CR_P4 = 0;                        // SI
    P7FC_P4 = 0;
    P7CR_P5 = 1;                        // SO
    P7FC_P5 = 1;
    P7CR_P6 = 0;                        // SCLK
    P7FC_P6 = 1;

    
    POFFCR2_SIO0EN = 1;                 // enable function
    SIO0CR_SIOEDG  = 0;                 // CPOL = 1   CPHA = 1
    SIO0CR_SIOCKS  = 0x07;              // external clock input
    SIO0CR_SIODIR  = 1;                 // MSB first (transfer from bit 7)
    SIO0CR_SIOM    = 0x03;              // 8-bit transmit and receive mode
*/
}


//*********************************************************************
// name			: SIO_Start
// brief		: start SIO
// note			:
//*********************************************************************
void SIO_Start(void)
{
    SIO0CR_SIOS = 1;                    
}


//*********************************************************************
// name			: SIO_Stop
// brief		: stop SIO (reserved stop)
// note			:
//*********************************************************************
void SIO_Stop(void)
{
    SIO0CR_SIOS = 0;                    
}


//*********************************************************************
// name			: SIO0_IntEnable
// brief		: enable SIO interrupt
// note			: after execution, Interrupt master Allowed Flag (IMF) will be enabled
//*********************************************************************
void SIO0_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTSIO0 = 0;                     // clear interrupt latch
    EI_INTSIO0 = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: SIO0_IntDisable
// brief		: disable SIO interrupt
// note			: after execution, Interrupt master Allowed Flag (IMF) will be enabled
//*********************************************************************
void SIO0_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTSIO0 = 0;                     // clear interrupt enable flag
	IL_INTSIO0 = 0;                     // clear interrupt latch    
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: SIO_ByteSend
// brief		: SIO continuous transfer
// note			:
//*********************************************************************
void SIO_ByteSend(uchar *data, uchar len)
{
    uchar i, dummy;

    for( i=0; i<len; i++ ){    
        SIO0BUF = *data;                // write data to SIOBUF first, and then start SIO
        data++;

        if( i == 0 ){                   // first transmission of data       
            if( SIO0CR_SIOS == 0 ){            
                SIO0CR_SIOS = 1;        // operation start
            }
        }
        while( SIO0SR_TBFL == 1 ){      // wait for the transmit buffer is empty
            //  CLR_WDT;                // clear the watchdog timer
        }
    }
    while( SIO0SR_SEF == 1 ){           // wait for shift operation not in progress   
    //  CLR_WDT;                        // clear the watchdog timer
    }
}


//*********************************************************************
// name			: SIO_ByteRead
// brief		: SIO continuous receive
// note			:
//*********************************************************************
void SIO_ByteRead(uchar *data, uchar len)
{
    uchar i, dummy;

    for( i=0; i<len; i++ ){    
        if( i == 0 ){
        //  when the SIO operation mode is set to 8-bit transmit and receive mode, write dummy data 0xFF to SIO0BUF before starting SIO
            if( SIO0CR_SIOM == 0x3 ){
                SIO0BUF = 0xff;         // write dummy data 0xFF to SIO0BUF
                dummy = SIO0BUF;        // read dummy data
            }
            else{            
                dummy = SIO0BUF;        // read dummy data
            }

            if( SIO0CR_SIOS == 0 ){            
                SIO0CR_SIOS = 1;        // operation start
            }
        }
        else{     


            while( SIO0SR_RENDB == 0 ){ // wair for at least one data receive operation has been executed          
            //  CLR_WDT;                // clear the watchdog timer

            }

            *data = SIO0BUF;            // reading SIO0BUF
            data++;

            if( SIO0CR_SIOM == 0x3 ){            
                SIO0BUF = 0xff;         // write dummy data 0xFF to SIO0BUF
            }
        }
    }


    while( SIO0SR_RENDB == 0 ){         // wair for at least one data receive operation has been executed  
    //  CLR_WDT;                        // clear the watchdog timer
    }

//  set reserved stop before reading the last data because reading or writing SIOBUF will trigger the SIO clock again
    SIO_ReservedStopWait();

//  read the last byte of data
    *data = SIO0BUF;                    // reading SIO0BUF
    data++;
}


//*********************************************************************
// name			: SIO_ReservedStopWait
// brief		: stop SIO (reserved stop) and wait for transfer not in progress
// note			: 
//*********************************************************************
void SIO_ReservedStopWait(void)
{
    SIO0CR_SIOS = 0;                    // SIOS=0: reserved stop

    while( SIO0SR_SIOF == 1 ){          // wait for transfer not in progress    
    //  NOP;                            // no operation
    }
}


//*********************************************************************
// name			: IntSIO0
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntSIO0(void)
{	
    NOP;
	NOP;
	NOP;
}




























