//******************************************
// file			: MQ6832_TBT
// version		: V1.0
// brief		: TBT related functions
// note			:
//******************************************

#include "main.h"

//*********************************************************************
// name			: TBT_Init
// brief		: TBT initialization
// note			:
//*********************************************************************
void TBT_Init(void)
{
//====== parameter setting ======
    TBTCR_TBTCK   = 0;                  // 
                                        // 
    NOP;                                // no operation
}


//*********************************************************************
// name			: TBT_Start
// brief		: TBT_Start 
// note			:
//*********************************************************************
void TBT_Start(void)
{
    TBTCR_TBTEN   = 1;
}


//*********************************************************************
// name			: TBT_Stop
// brief		: TBT_Stop ֹͣ
// note			:
//*********************************************************************
void TBT_Stop(void)
{
    TBTCR_TBTEN   = 0;
}


//*********************************************************************
// name			: TBT_IntEnable
// brief		: enable TBT interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TBT_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTBT  = 0;                     // clear interrupt latch
    EI_INTTBT  = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: TBT_IntDisable
// brief		: disable TBT interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TBT_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTTBT  = 0;                     // clear interrupt enable flag
    IL_INTTBT  = 0;                     // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: IntTBT
// brief		: TBT interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTBT(void)
{
    
    
}


























