//******************************************
// file			: MQ6832_ADC
// version		: V1.0
// brief		: 
// note			:
//******************************************

#include "main.h"



uint  vref_l, vref_h, iReal_Vref2V, ADC_Code_READ;


//*********************************************************************
// name			: ADC_Init
// brief		: ADC initialization
// note			:
//*********************************************************************
void ADC_Init()
{
    P4FC_P4 = 1;
    P4CR_P4 = 0;
//====== parameter setting ======
    ADCVRF_VRFSEL   = VREF2;            // set ADC reference voltage to internal 2V
    ADCCR1_SAIN     = AIN4;             // set analog input channel to AIN4
    ADCCR1_AINEN    = 1;                // analog input enable
    ADCCR1_AMD      = ADC_REPEAT;       // set AD operation mode to repeat mode
    ADCCR2_ACK      = CONV256CLK;       // set AD conversion times
}


//*********************************************************************
// name			: ADC_Start
// brief		: start ADC
// note			:
//*********************************************************************
void ADC_Start(void)
{
    ADCCR1_ADRS = 1;                    
}


//*********************************************************************
// name			: ADC_Stop
// brief		: stop ADC
// note			:
//*********************************************************************
void ADC_Stop(void)
{
    ADCCR1_AMD = 0;                     // 0: AD operation disable, forcibly stop AD operation
}


//*********************************************************************
// name			: ADC_IntEnable
// brief		: enable ADC interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void ADC_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTADC = 0;                      // clear interrupt latch
    EI_INTADC = 1;                      // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: ADC_IntDisable
// brief		: disable ADC interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void ADC_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTADC = 0;                      // clear interrupt enable flag
	IL_INTADC = 0;                      // clear interrupt latch    
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: GetVref()
// brief		: get the value of internal ADC reference voltage (unit: mV)
// note			: start ADC auto calibration:(0x0EF6)(VREF_CALIB<VRFCAL>)=1
//*********************************************************************
uint GetVref(void)
{
    BIT_LIST_16 ADC_READ;
//	Vref2V, value is ( Real_2V * 1024 )
	__asm("LD A,(0x7E05)");		        // low byte
	__asm("LD (_vref_l),A");
	__asm("LD A,(0x7E06)");		        // high byte
	__asm("LD (_vref_h),A");

	ADC_READ.byte[0] = vref_l;
	ADC_READ.byte[1] = vref_h & 0x0f;

//  if internal voltage value is between 2150 and 1950, start ADC auto-compensation.
	if( ADC_READ.word <= 2150 )
	    if( ADC_READ.word >= 1950 )
	        VREF_CALIB_VRFCAL = 1;      // start ADC auto calibration

    return ADC_READ.word;
}


//*********************************************************************
// name			: ADC_SingleDetect
// brief		: get ADC value of single coversion time
// note			:
//*********************************************************************
uint ADC_SingleDetect(uchar SAIN)
{
    BIT_LIST_16 ADC_READ;

//====== select analog input channel ======
    ADCCR1_SAIN = SAIN;                 // set analog input channel

    ADCCR1_ADRS = 1;                    
    while(  ADCCR2_ADBF ){ CLR_WDT; }   // 1: AD conversion being executed
    while( !ADCCR2_EOCF ){ CLR_WDT; }   // 1: conversion end  0: before conversion or during conversion

    ADC_READ.byte[0] = ADCDRL;          // read low byte first and then read high byte
    ADC_READ.byte[1] = ADCDRH;          // read low byte first and then read high byte
//    adc_data += ADC_READ.word;

	return ADC_READ.word;
}


//*********************************************************************
// name			: ADC_RepeatDetect
// brief		: get ADC value after more times conversion
// note			:
//*********************************************************************
uint ADC_RepeatDetect(uchar SAIN)
{
    uchar i;
    ulong adc_data = 0;
    uint  ad_max = 0, ad_min = 1024;
    BIT_LIST_16 ADC_READ;

//====== select analog input channel ======
    ADCCR1_SAIN = SAIN;                 // set analog input channel

    ADCCR1_ADRS = 1;                    
    for( i=0; i<(AD_TIMES+2); i++ )
    {
        while( !ADCCR2_EOCF ){ CLR_WDT; } // 1: conversion end  0: before conversion or during conversion
        ADC_READ.byte[0] = ADCDRL;      // read low byte first and then read high byte
        ADC_READ.byte[1] = ADCDRH;      // read low byte first and then read high byte
        adc_data += ADC_READ.word;
        if( ADC_READ.word > ad_max ) ad_max = ADC_READ.word;
        if( ADC_READ.word < ad_min ) ad_min = ADC_READ.word;
    }
    ADCCR1_ADRS = 0;                    // AD conversion stop

    adc_data -= ad_max;                 // subtract the maximum value during sampling
    adc_data -= ad_min;                 // subtract the minimum value during sampling
    adc_data /= AD_TIMES;

	return (uint)adc_data;
}



//*********************************************************************
// name			: IntADC
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntADC(void)
{
    NOP;                                // no operation
}




























