//*********************************************************************
// file			: MQ6825_UART
// version		: V1.1 2019/03/20
// brief		: UART related functions
// note			: UART related functions are gathered in this subroutine
//*********************************************************************

#include "main.h"


unsigned char RX1_DATA,recvCnt;




extern unsigned char recvBuf[10];	

//*********************************************************************
// name			: UART1_Init
// brief		: UART initialization ***this example UART uses P90(TX) and P91(RX)
// note			: operation mode must be NORMAL1 mode and NORMAL2 mode
//*********************************************************************
void UART1_Init(void)
{
//====== select UART1 in this example ======


    P9CR_P1 = 0;                        // set P91 as input pin
    P9CR_P0 = 1;                        // set P90 as output pin
	
    P9FC_P0 = 1;                        // set P90 as special function pin
	
	
	UATCNG_UAT2IO = 0;   				// set P90/P91 as UART input/output pin
    UATCNG_UAT1IO = 0;                  // 0: set P90 to TX and P91 to RX
										// 1: set P91 to TX and P90 to RX
										
//---------------------------------------------------------------------------------------------------------------

/*
//====== select P26/P27 as UART1 input/output pin ======

//    P2CR_P7 = 0;                        // set P27 as input pin
//    P2CR_P6 = 1;                        // set P26 as output pin
	
//    P2FC_P6 = 1;                        // set P26 as special function pin



//    UATCNG_UAT2IO = 1;                  // set P26/P27 as UART input/output pin							
//    UATCNG_UAT1IO = 0;                  // 0: set P26 to TX and P27 to RX
//										  // 1: set P27 to TX and P26 to RX									
*/

//---------------------------------------------------------------------------------------------------------------


/*
//====== select P20/P21 as UART0 input/output pin ======
//    P2CR_P1 = 0;                        // set P21 as input pin
//    P2CR_P0 = 1;                        // set P20 as output pin
	
//    P2FC_P0 = 1;                        // set P20 as special function pin


//	  UATCNG_UAT0IO = 0;				  // set P20/P21 as UART input/output pin
//										  // 0: set P20 to TX and P21 to RX
//										  // 1: set P21 to TX and P20 to RX	
*/

//---------------------------------------------------------------------------------------------------------------

								

//====== enable function ======

//use P90 and P91 => UART1	
    POFFCR1_UART1EN = 1;                // this register must be enable first and then the related registers settings will work

/*		
//use P26 and P27 => UART1
    POFFCR1_UART1EN = 1;                // this register must be enable first and then the related registers settings will work
*/

/*
//use P20 and P21 => UART0	
    POFFCR1_UART0EN = 1;                // this register must be enable first and then the related registers settings will work
*/
//====== parameter setting ======
	UART1CR1_STOPBT	= 0;				// transmit stop bit length : 1 bit
	UART1CR2_STOPBR	= 0;				// receive stop bit length : 1 bit
	UART1CR1_PE		= 0;				// no parity	
	UART1CR1_BRG	= 0;				// 0: transfer base clock selection = fcgck
										// 1: transfer base clock selection = TCA0 output

//------ Baud rate setting = 9600 -------   
//--- fcgck @ 16MHz
/* 
    UART1CR2_RTSEL = 0x01;
    UART1DR        = 0x64;
 */
 
//--- fcgck @ 8MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x30;
 */

//*** fcgck @ 4MHz                      *this example uses Baud rate = 9600,fcgck @ 4MHz
    UART1CR2_RTSEL = 0x00;
    UART1DR        = 0x19;
    
//--- fcgck @ 2MHz
/* 
    UART1CR2_RTSEL = 0x00;
    UART1DR        = 0x0c;
*/	
//------ Baud rate setting = 115200 -----
//--- fcgck @ 16MHz
/* 
    UART1CR2_RTSEL = 0x03;
    UART1DR        = 0x08;
 */
//--- fcgck @ 8MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x03;
 */
//--- fcgck @ 4MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x01;
 */
//--- fcgck @ 2MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x00;
 */

}


//*********************************************************************
// name			: UART1_Start
// brief		: start UART
// note			:
//*********************************************************************
void UART1_Start(void)
{
    UART1CR1_TXE = 1;                   // enable TX
    UART1CR1_RXE = 1;                   // enable RX
}


//*********************************************************************
// name			: UART1_Stop
// brief		: stop UART
// note			:
//*********************************************************************
void UART1_Stop(void)
{
    UART1CR1_TXE = 0;                   // disable TX
    UART1CR1_RXE = 0;                   // disable RX
}


//*********************************************************************
// name			: UART1_IntEnable
// brief		: enable UART interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void UART1_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
/*    
  	IL_INTTXD1      = 0;                // clear TX interrupt latch
  	EI_INTTXD1      = 1;                // enable TX interrupt
*/
    IL_INTRXD1      = 0;                // clear RX interrupt latch
    EI_INTRXD1      = 1;                // enable RX interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: UART1_IntDisable
// brief		: disable UART interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void UART1_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
/*   
	 IL_INTTXD1      = 0;               // clear TX interrupt latch
	 EI_INTTXD1      = 0;               // disable TX interrupt
*/
    IL_INTRXD1      = 0;                // clear RX interrupt latch
    EI_INTRXD1      = 0;                // disable RX interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: IntRXD1
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntRXD1(void)
{
	BIT_LIST_8 uart_flag;
	
	uart_flag.byte = UART1SR;			//get flag data

										//                bit7  bit6  bit5	bit4  bit3  bit2  bit1  bit0
	 									// get flag data [PERR, FERR, OERR,   -,  RBSY, RBFL, TBSY, TBFL]
                                        // PERR    parity error flag   	     0: no parity error
                                        //                              	 1: parity error
                                        // RFERR   framing error flag        0: no framing error
                                        //                          	     1: framing error
                                        // OERR    overrun error flag        0: no overrun error
                                        //                          	     1: overrun error
                                        // RBSY    receive busy flag         0: before receiving or end of receiving
                                        //                           	     1: on receiving
                                        // RBFL    receive buffer full flag  0: receive buffer empty
                                        //                           	     1: receive buffer full
                                        // TBSY    transmit busy flag        0: before transmission or end of transmission
                                        //                           	     1: on transmitting
                                        // TBFL    transmit buffer full flag 0: transmit buffer empty
                                        //                            	     1: transmit buffer full
										
	RX1_DATA = RD1BUF;					// get Rx data and clear UART1SR flag										
	// Error handle
	if(uart_flag.bit.b7 == 1){
										// parity error
	}
	else if(uart_flag.bit.b6 == 1){
										// framing error
	}
	else if(uart_flag.bit.b5 == 1){
										// overrun error
	}
	else{
		recvBuf[(recvCnt++)%10]= RX1_DATA;		// No Error, store the data
		
	}
	
	
}





//*********************************************************************
// name			: UART1_senddata
// brief		: UART1 sends multi-bytes data
// note			:
//*********************************************************************
void UART1_senddata(uchar* buf,uint length)
{
    uint sendloop;

    for( sendloop = 0; sendloop < length; sendloop++ )
    {
        while( UART1SR_TBFL ==1 )           // wait for buffer empty
        {
            CLR_WDT;                    // clear the watchdog timer
        }
        
        TD1BUF = buf[sendloop];			// write the data to buffer
    }

    while( UART1SR_TBSY ==1 )               // wait for end of transmission
    {
        CLR_WDT;                        // clear the watchdog timer
    }
}























