//******************************************
// file			: MQ6825_TC0_12Bit
// version		: V1.1 2021/02/25
// brief		: TC0 12-Bit PWM related functions
// note			: TC0 12-Bit PWM related functions are gathered in this subroutine
//******************************************

#include "main.h"

//*********************************************************************
// name			: T001_12bit_PWM_Init
// brief		: T001_12bit_PWM initialization
// note			:
//*********************************************************************
void T001_12bit_PWM_Init(void)
{
//====== pin configuration ======
    P7DR_P1 = 1;                        // set P71 to output high (suggest output level as the same as the value of T0xMOD_TFF)
    P7CR_P1 = 1;                        // set P71 as output pin

//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T001CR_TCAS     = 1;                // cascade timers 
    T01MOD_TFF      = 1;                // set initial state of function pin to high

    T01MOD_TCM      = 2;                // set operation mode to 12-bit pulse width modulation output (PWM) mode
    T01MOD_TCK      = 5;                // fcgck/4 = 4MHz
                                        // PWM period : 0.25us*256 = 64us
    T01MOD_DBE      = 1;                // enable the double buffer



    T00PWM          = 0x04;             // set low-order of duty cycle
    T01PWM          = 0x04;             // set high-order of duty cycle
                                        // 0.25us*(0x404) = 257 , 257/1024 = 25.098% , duty cycle is 25.098%
//	***set function pins after function initialization
    P7FC_P1         = 1;                // set P71 as PWM function pin

    NOP;                                // no operation
}


//*********************************************************************
// name			: T001_12bit_PWM_Start
// brief		: start T001_12bit_PWM
// note			:
//*********************************************************************
void T001_12bit_PWM_Start(void)
{
    T001CR_T01RUN = 1;
}


//*********************************************************************
// name			: T001_12bit_PWM_Stop
// brief		: stop T001_12bit_PWM
// note			:
//*********************************************************************
void T001_12bit_PWM_Stop(void)
{
    T001CR_T01RUN = 0;
}


//*********************************************************************
// name			: T001_12bit_PWM_IntEnable
// brief		: enable TC001 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void T001_12bit_PWM_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTC01 = 0;                     // clear interrupt latch
    EI_INTTC01 = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: T001_12bit_PWM_IntDisable
// brief		: disable TC001 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void T001_12bit_PWM_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTTC01 = 0;                     // clear interrupt enable flag
    IL_INTTC01 = 0;                     // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: T001_12bit_PWM_SetDuty
// brief		: set duty cycle
// note			:
//*********************************************************************
void T001_12bit_PWM_SetDuty(uint pwmDuty)
{
    pwmDuty &= 0xfff;                   // only 12-bit valid
    T00PWM = pwmDuty&0xff;              // set low-order first
    T01PWM = (pwmDuty&0xf00)>>8;        // then high-order
}

//*********************************************************************
// name			: IntTC01
// brief		: TC01 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTC01(void)
{
    NOP;                                // no operation
}


























