//**********************************************************************************************
// file			: main.c
// version		: V1.1 2021/09/13
// brief		: main program
// note			: this example use 8-channel dynamic drive 4-bit segment LCD GDC03077
//			  	  this example performs the following:
// 			  		1. LCD is fully illuminated at the start of execution
//			  		2. then the LCD digital dynamic display began:
//						add the functions of pause display (P42 external key BTN0) and resume display (P43 external key BTN1)
//						when P43 external key BTN0 is pressed, the LCD display is suspended
//						when P42 external button BTN1 is pressed, the LCD display is restored
//						the information about the LCD GDC03077 is in the LCD_Panel_data folder
//***********************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif

#include "main.h"

#define Btn_STOP P4PRD_P3				 	// connect P43 to a button	

ST_DEVICE gdev;

BIT_LIST_8  _flag_8bit;
BIT_LIST_16 _flag_16bit;
/* ---------------------- global variables ------------------------------ */

/* ---------------------- main program -------------------------------- */
void main(){
	
	/* ---------------------- global variables -------------------------- */
	uchar DigN, NumN, iloop;
	
	
    /* ---------------------- system initialization ------------------------ */
    SYSTEM_INIT();


    /* ---------------------- LCD function initialization ------------------- */
	//  this example use 8-channel dynamic drive 4-bit segment LCD GDC03077


    	LCD_Init();							// LCD initialization		
		LCD_Start();						// start LCD
		//LCD_Power_Control();				// set LCD power source and bias

	
	//-------------------------P43 pin setting-------------------------- 
		P4CR_P3	     = 0;					// set P43 as input pin
		P4PU_P3	     = 1;					// enable P43 built-in pull-up resistor
		

	//----set P42 to KWI high level release in the following example--------
/*	
	//	P4CR_P2      = 0;					// set P42(KWI42) as input pin
	//	P4PD_P2      = 1;					// enable P42(KWI2) built-in pull-down resistor
		
	//	KWUCR0_KW2LE = 1;					// set KWI2 release level to high
	//	KWUCR0_KW2EN = 1;					// enable KWI2
*/

	//---set P42 to KWI low level release in this example----------
	
		P4CR_P2      = 0;					// set P42(KWI42) as input pin
		P4PU_P2      = 1;					// enable P42(KWI2) built-in pull-up resistor
		
		KWUCR0_KW2LE = 0;					// set KWI2 release level to low
		KWUCR0_KW2EN = 1;					// enable KWI2	
			
    //-------------------------------------------------------------
		Bat_Decode(4);				        // display 100% battery level
		//Bat_Decode(3);				    // display 67% battery level
		//Bat_Decode(2);				    // display 33% battery level
		//Bat_Decode(1);				    // display 0% battery level
	
    //-------------------------------------------------------------
		Percent_Decode(1);					// percentage display (100%)
		//Percent_Decode(2);				// percentage display
		//Percent_Decode(3);				// percentage display
		//Percent_Decode(4);				// percentage display
	//-------------------------------------------------------------

//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    while(1)
    {
        CLR_WDT;                        	// clear the watchdog timer
      
    
        for( DigN=1; DigN<11; DigN++)
		{		
            for( NumN=0; NumN<16; NumN++)
            {                
				if( Btn_STOP == 0)
				{				
					LCDCR3        = 0x00;	// disable from COM0 to COM7 outpput
					LCDCR4        = 0x00;	
					LCDCR5        = 0x00;	// disable from SEG0 to SEG13 outpput
					LCDCR1_EDSP   = 0;		// disable LCD control
					POFFCR2_LCDEN = 0;		// disable the basic clock supply to LCD					
					
					// set all pins used for the LCD function to output low level to avoid leakage					
					
					P2DR         &= (~0xFB); // 0000 0100 
					P4DR         &= (~0xF0); // 0000 1111
					P7DR 	     &= (~0xFD);   
					P8DR         &= (~0x0C);
					P9DR         &= (~0x03);
					
					P2CR 	     |= 0xFB;    // 1111 1011
					P4CR         |= 0xF0;
					P7CR 	     |= 0xFD;
					P8CR         |= 0x0C;
					P9CR         |= 0x03;
					//				
					
					Entry_STOP;     		 // enter STOP mode (set port output hold)

					// before using the LCD, set all pins used for the LCD function as input pins 
					P2CR         &= (~0xFB); // 0000 0100
					P4CR         &= (~0xF0); // 0000 1111
					P7CR         &= (~0xFD); // 0000 0001
					P8CR         &= (~0x0C); // 1111 0011
					P9CR         &= (~0x03); // 1111 1100

					POFFCR2_LCDEN = 1;		// enable the basic clock supply to LCD
					LCDCR3        = 0xFF;	// enable from COM0 to COM7 outpput 
					LCDCR4        = 0xFF;		 
					LCDCR5        = 0x3F;	// enable from SEG0 to SEG13 outpput
					LCDCR1_EDSP   = 1;      // enable LCD control
				}
				
				
/*
				if(DigN==2)
				{
					LCD_Power_Control_08(); // adjust bias to let LCD display become lighter color 
					Percent_Decode(2);		// change percentage display
									
					
				}	
				
			    else if(DigN==3)
				{
					LCD_Power_Control_10();	// adjust bias to let LCD display become lighter color
					Percent_Decode(3);		// change percentage display
					
				}	
				
				if(DigN>=4)
				{
					LCDVCR1 = 0;			// adjust bias to let LCD display become darkest color
					Percent_Decode(1);		// change percentage display
					
				}
*/				
				Dig_Decode(DigN, NumN);
				delay_times(t_1ms, 500);    // for NORMAL mode, not for SLOW mode
				
				
				
            }
			




		
		}
        NOP;                            // no operation
        NOP;                            // no operation
        NOP;                            // no operation
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}





















/*---------------------- interrupt service routine ------------------------*/
void __interrupt OnlyReti(void)
{
    NOP;                                // no operation
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10; 	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}     
/*-----------------  жϷ ------------------------*/

/*------------------------ interrupt vector ------------------------*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
    OnlyReti,           // 0xffc0 : IntTCC2P
    OnlyReti,           // 0xffc2 : IntTCC2T
    OnlyReti,           // 0xffc4 : IntTCC1P
    OnlyReti,           // 0xffc6 : IntTCC1T
    OnlyReti,           // 0xffc8 : IntTCA1
    OnlyReti,           // 0xffca : IntSIO1
    OnlyReti,           // 0xffcc : IntTCC0P
    OnlyReti,           // 0xffce : IntTCC0T
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    OnlyReti,           // 0xffd4 : Int5
    OnlyReti,           // 0xffd6 : Int4
    OnlyReti,           // 0xffd8 : Int3 / IntCMP1
    OnlyReti,           // 0xffda : Int2 / IntCMP0 / IntEMG0
    OnlyReti,           // 0xffdc : Int1 / IntCMP2
    OnlyReti,           // 0xffde : Int0 / IntCMP3
    OnlyReti,           // 0xffe0 : IntSBI
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,           // 0xffec : IntLVD
    OnlyReti,           // 0xffee : IntTXD0
    OnlyReti,           // 0xfff0 : IntRXD0
    OnlyReti,           // 0xfff2 : IntSIO0
    OnlyReti,           // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI / INTUNDEF
    STARTUP             // 0xfffe : RESET
};
#pragma section const
/*------------------- end of interrupt vector ------------------------*/

















//*********************************************************************
// name			: SYSTEM_INIT(void)
// brief		: IO, CGCR and P10/P40/P41 initialization during debugging
// note			:
//*********************************************************************
void SYSTEM_INIT(void)
{
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  (default): when emulation, set P10 to Reset pin to avoid affecting the emulation and program functions
    SET_P10_to_RESET_PIN;
//------------------------------------------------------------------
    FSCTRL_FSSEL = 0;                   // if the program has changed this bit, you need to manually initialize and clear it to the default value of 0 in the emulation mode 
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode), set P10 to GPIO pin
//------------------------------------------------------------------
//-- set P10 to GPIO pin ------
    SET_P10_to_IO_PIN;
//------------------------------------------------------------------
#endif



//-- pin configuration initialization (debug pin configuration)------
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  the simulation uses P10, P40 and P41 into Debug mode, which is set as an input during simulation
//  to avoid affecting the emulation and program functions
    P1DR = 0x00;
    P1CR = set8bit(11111110);           // set P10 as input pin
    P4DR = 0x00;
    P4CR = set8bit(11111100);           // set P40 and P41 as input pins
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- pin configuration initialization ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;
    P5DR = 0x00;
    P5CR = 0xff;
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;
//  sendout_I2C(IRSTSR);                // IRSTSR: internal factor reset detection status register
    CLR_WDT;                            // clear the watchdog timer


//--------------------------------------------------------------------------------------------------//
//  Please set the external crystal (HXTAL/LXTAL) from <main.h> and refer to the following instructions:
//  HXTAL/LXTAL use the same IO (P00/P01), only one of them can be enable
//.....................................................................................
//#undef    XTAL_High       // define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//#undef    XTAL_Low        // define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//          |........................................................................................
//          |---------> // Cautions:
//          |---------> // 1. to enable LXTAL, please set FSCTRL_FSSEL to 1 using bit operation
//          |---------> // 2. to enable external low-frequency crystal, you need to check the checkbox 'ext low OSC' when programming
//          |---------> //    programming by IDE : Project -> Pin Setting -> check 'ext low OSC'
//          |---------> //    programming by Writer : tap Type -> on the right side of the same page of IC type option -> check 'ext low OSC'
//          .........................................................................................
//--------------------------------------------------------------------------------------------------//
//	call function to select whether to switch the external high-frequency crystal oscillator
//  XTAL_High_Config();

}



//*********************************************************************
// name			: delay_times
// brief		: time delay function
// note			: ==> t_1ms   = 0;          // time delay unit ms
//          : ==> t_100us = 1;          // time delay unit us (this accuracy is not good)
//          : the example of using a fixed loop with a time delay is as follows:
//          : delay_times(t_1ms, 800);  // delay 800ms
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
    uint  i, cgcrT;

//  uchar cgcrF[4]={ 2, 4,  8, 1 };     // use this array when the high-speed crystal frequency is 8MHz
    uchar cgcrF[4]={ 4, 8, 16, 2 };     // use this array when the high-speed crystal frequency is 16MHz

//  the time delay function of the system at NORMAL1 mode and NORMAL2 mode
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  the time delay function of the system at SLOW1 mode and SLOW2 mode), which has a large error, is used for reference
    else for(; x>0; x--){}

    CLR_WDT;                            // clear the watchdog timer
}




//*********************************************************************
// name			:
// brief		:
// note			: emulate I2C with GPIO
//*********************************************************************
void sendout_I2C(uchar data)
{
    uchar iloop, x, z=10;

    io_SDA_cr = 1;                      // setting output port
    io_SCL_cr = 1;                      // setting output port

//	start condition......
    io_SDA = 1;         for(x=z; x>0; x--){}
    io_SCL = 1;         for(x=z; x>0; x--){}
    io_SDA = 0;         for(x=z; x>0; x--){}
    io_SCL = 0;         for(x=z; x>0; x--){}

//	sent byte data......
    for( iloop=0; iloop<8; iloop++ )
    {
        io_SDA = data >> 7;
        data   = data << 1;
        for(x=z; x>0; x--){}
        io_SCL = 1;     for(x=z; x>0; x--){}
        io_SCL = 0;     for(x=z; x>0; x--){}
    }
    io_SDA = 0;         for(x=z; x>0; x--){}
    io_SCL = 1;         for(x=z; x>0; x--){}
    io_SCL = 0;         for(x=z; x>0; x--){}

    //	stop condition......
    io_SDA = 0;         for(x=z; x>0; x--){}
    io_SCL = 1;         for(x=z; x>0; x--){}
    io_SDA = 1;         for(x=z; x>0; x--){}
}










