//******************************************
// file			: MQ6825_KWI
// version		: V1.1 2021/02/25
// brief		: KWI related functions
// note			: KWI related functions are gathered in this subroutine
//******************************************

#include "main.h"

//******************************************************************************
// name			: KWI_Enable
// brief		: initialize and enable KWI
// note			: STOP mode release level is only one option, no both levels in one KWI
//******************************************************************************
void KWI_Enable(void)
{
//====== KWI 0 ======
//--- low level release 
/*
    P4CR_P0         = 0;
    P4PU_P0         = 1;    
    KWUCR0_KW0LE    = 0;
    KWUCR0_KW0EN    = 1;
 */    
//--- high level release
/* 
    P4CR_P0         = 0;
    P4PU_P0         = 0;    
    KWUCR0_KW0LE    = 1; 
    KWUCR0_KW0EN    = 1;
 */
//====== KWI 1 ======
//--- low level release 
/*
    P4CR_P1         = 0;
    P4PU_P1         = 1;    
    KWUCR0_KW1LE    = 0;
    KWUCR0_KW1EN    = 1;
 */    
//--- high level release
/* 
    P4CR_P1         = 0;
    P4PU_P1         = 0;    
    KWUCR0_KW1LE    = 1; 
    KWUCR0_KW1EN    = 1;
 */
   
//====== KWI 2 ======
//--- low level release 

    P4CR_P2         = 0;
    P4PU_P2         = 1;    
    KWUCR0_KW2LE    = 0;
    KWUCR0_KW2EN    = 1;
    
//--- high level release
/* 
    P4CR_P2         = 0;
    P4PU_P2         = 0;    
    KWUCR0_KW2LE    = 1; 
    KWUCR0_KW2EN    = 1;
 */
    
//====== KWI 3 ======
//--- low level release 
/* 
    P4CR_P3         = 0;
    P4PU_P3         = 1;    
    KWUCR0_KW3LE    = 0;
    KWUCR0_KW3EN    = 1;
 */ 
//--- high level release
/* 
    P4CR_P3         = 0;
    P4PU_P3         = 0;    
    KWUCR0_KW3LE    = 1;
    KWUCR0_KW3EN    = 1; 
 */
    
//====== KWI 4 ======
//--- low level release 
/* 
    P4CR_P4         = 0;
    P4PU_P4         = 1;    
    KWUCR1_KW4LE    = 0;
    KWUCR1_KW4EN    = 1;
 */ 
//--- high level release
/* 
    P4CR_P4         = 0;
    P4PU_P4         = 0;    
    KWUCR1_KW4LE    = 1;
    KWUCR1_KW4EN    = 1;
 */
    
//====== KWI 5 ======
//--- low level release 
/* 
    P4CR_P5         = 0;
    P4PU_P5         = 1;    
    KWUCR1_KW5LE    = 0;
    KWUCR1_KW5EN    = 1;
 */ 
//--- high level release
/* 
    P4CR_P5         = 0;
    P4PU_P5         = 0;    
    KWUCR1_KW5LE    = 1;
    KWUCR1_KW5EN    = 1;
 */
    
//====== KWI 6 ======
//--- low level release 
/* 
    P4CR_P6         = 0;
    P4PU_P6         = 1;    
    KWUCR1_KW6LE    = 0;
    KWUCR1_KW6EN    = 1;
 */ 
//--- high level release
/* 
    P4CR_P6         = 0;
    P4PU_P6         = 0;    
    KWUCR1_KW6LE    = 1;
    KWUCR1_KW6EN    = 1;
 */
    
//====== KWI 7 ======
//--- low level release 
/* 
    P4CR_P7         = 0;
    P4PU_P7         = 1;    
    KWUCR1_KW7LE    = 0;
    KWUCR1_KW7EN    = 1;
 */ 
//--- high level release
/* 
    P4CR_P7         = 0;
    P4PU_P7         = 0;    
    KWUCR1_KW7LE    = 1;
    KWUCR1_KW7EN    = 1;
 */

}


//*********************************************************************
// name			: KWI_Disable
// brief		: disable KWI
// note			: 
//*********************************************************************
void KWI_Disable(void)
{

//====== KWI 0 ======   
/*  
    P4PU_P0         = 0;        
    KWUCR0_KW0EN    = 0; 
*/
    
//====== KWI 1 ======   
/*  
    P4PU_P1         = 0;        
    KWUCR1_KW1EN    = 0; 
*/

//====== KWI 2 ======   
    P4PU_P2         = 0;        
    KWUCR0_KW2EN    = 0;

//====== KWI 3 ======   
/*  
    P4PU_P3         = 0;        
    KWUCR0_KW3EN    = 0; 
*/
    
//====== KWI 4 ======   
/*  
    P4PU_P4         = 0;        
    KWUCR1_KW4EN    = 0; 
*/
    
//====== KWI 5 ======   
/*  
    P4PU_P5         = 0;        
    KWUCR1_KW5EN    = 0; 
*/
    
//====== KWI 6 ======   
/*  
    P4PU_P6         = 0;        
    KWUCR1_KW6EN    = 0; 
*/
    
//====== KWI 7 ======   
/*  
    P4PU_P7         = 0;        
    KWUCR1_KW7EN    = 0; 
*/
 
}

























