//******************************************
// file			: MQ6825_startup.c
// version		: V1.0 2019/03/20
// brief		: startup program
// note			:
//******************************************
//******************************************
//******************************************
/*
 * --------------------------------------------------------------------------
 *   HEADER INCLUDE DEFINITIONS
 * --------------------------------------------------------------------------
 */
#include <stdlib.h>
#include "MQ6825_SFR.h"    // declare the detailed names represented by each bit of the special function registers

/*
 * --------------------------------------------------------------------------
 *   MACRO DEFINITIONS
 * --------------------------------------------------------------------------
 */
extern unsigned int _BaseSP;				/* the starting address of the stacking pointer is generally defined as the the last address of the SRAM */
extern unsigned int _RAM_Top;				/* the first address of SRAM */
extern unsigned int _RAM_End;				/* the last address of SRAM */

extern unsigned char _TDataAddr[];			/* for tiny_data initialize, defined in link command file  */
extern unsigned char _TDataOrg[];			/* for tiny_data initialize, defined in link command file  */
extern unsigned int _TDataSize;				/* for tiny_data initialize, defined in link command file  */
extern unsigned char _NDataAddr[];			/* for near_data initialize, defined in link command file  */
extern unsigned char _NDataOrg[];			/* for near_data initialize, defined in link command file  */
extern unsigned int _NDataSize;				/* for near_data initialize, defined in link command file  */

/*
 * --------------------------------------------------------------------------
 *   FUNCTION DECLARATIONS
 * --------------------------------------------------------------------------
 */

/*#**************************************************************************#*/

/*
 ******************************************************************************
 * NAME				:STARTUP
 *-----------------------------------------------------------------------------
 * DESCRIPTION		:Startup routine
 * PARAMETER		:-
 *
 * RETURN VALUE		:-
 *
 ******************************************************************************
 */
void STARTUP( void )
{
//=============================================================================
//  disable interrupt
//=============================================================================
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0


//=============================================================================
//  Set CGCR
//=============================================================================
//  ============================================
//  clock gear control register CGCR                                  fc   = 16MHz
//  ============================================
    CGCR_FCGCKSEL = 0x00;           // (system clock) fcgck = fc/4 =  4Mhz(ϵͳĬ)
//  CGCR_FCGCKSEL = 0x01;           // (system clock) fcgck = fc/2 =  8Mhz
//  CGCR_FCGCKSEL = 0x02;           // (system clock) fcgck = fc   = 16Mhz
//  CGCR_FCGCKSEL = 0x03;           // (system clock) fcgck = fc/8 =  2Mhz
//  ============================================
//  *** do not change the value of CGCR<FCGCKSEL> register in low-speed mode (SLOW1/SLOW2)
//  ============================================


//=============================================================================
//  initial Registers
//=============================================================================
    __WA = 0x00;
    __BC = 0x00;
    __DE = 0x00;
    __HL = 0x00;
    __IX = 0x00;
    __IY = 0x00;

//=============================================================================
//  initialize stack pointer
//=============================================================================
    __asm(" LD SP,__BaseSP");       //initialize stack pointer

//=============================================================================
//  clear status word
//=============================================================================
    __asm(" LD PSW,0x00");

//=============================================================================
//  clear RAM
//=============================================================================
    __asm(" LD HL,__RAM_Top");
    __asm(" LD BC,__RAM_End - __RAM_Top");
    __asm(" LD A,0x00");
    __asm("CLR_RAM:");
    __asm(" LD (HL),A");
    __asm(" INC HL");
    __asm(" DEC BC");
    __asm(" JRS F,CLR_RAM");        // Clear the RAM

//=============================================================================
//  initialize of tiny_data section
//=============================================================================
    __asm("	LD	IX,__TDataOrg");
    __asm("	LD	IY,__TDataAddr");
    __asm("	LD	A,__TDataSize");
    __asm("	DEC	A");
    __asm("	J	T,non_t_data");
    __asm("move_t_data:");
    __asm("	LD	C,(IX)");
    __asm("	LD	(IY),C");
    __asm("	INC	IX");
    __asm("	INC	IY");
    __asm("	DEC	A");
    __asm("	J	F,move_t_data");
    __asm("non_t_data:");

//=============================================================================
//  initialize of near_data section
//=============================================================================
    __asm("	LD	IX,__NDataOrg");
    __asm("	LD	IY,__NDataAddr");
    __asm("	LD	WA,__NDataSize");
    __asm("	DEC	WA");
    __asm("	J	T,non_n_data");
    __asm("move_n_data:");
    __asm("	LD	C,(IX)");
    __asm("	LD	(IY),C");
    __asm("	INC	IX");
    __asm("	INC	IY");
    __asm("	DEC	WA");
    __asm("	J	F,move_n_data");
    __asm("non_n_data:");

//=============================================================================
//  other system configuration
//=============================================================================
    //System_Config();

//=============================================================================
//  jump to main
//=============================================================================
	main();
	for (;;) {
		;
	}
}

