//***************************************************************
// file			: main.c
// version		: V1.1 2021/09/13
// brief		: main program
// note			: example of accessing to 24C08 ic with I2C interface
//            
//***************************************************************
#ifndef IO_MEM
#define IO_MEM
#endif

#include "main.h"

/* ---------------------- global variables ------------------------------ */
BIT_LIST_8  _flag_8bit;
BIT_LIST_16 _flag_16bit;
uchar       iloop, data, wBuf[16], rBuf[16];
uchar      wBuf_FF[] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
							 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
/* ---------------------- main program -------------------------------- */
void main(){
    /* ---------------------- system initialization ------------------------ */
    SYSTEM_INIT();

	// prepare data to 24C08
    for( iloop=0; iloop<16; iloop++ ){
        wBuf[iloop]  = 0x10+iloop;
	}
    /* ---------------------- function initialization ------------------------ */ 
    I2C_Init();							// I2C initialization							
										// P23-SDA  P24-SCL
    delay_times(t_1ms, 1);
    
//----------------------------------------------------------------//
//----------------------------------------------------------------//

//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

//  Master operation
if(1){

		//-------------------------------------------------------------------------------------
    //  write sequence FF
    if(1){
        I2C_Start(0xa0, 0x00);			// set as master mode and generate start condition and transfer 1 byte data (0x06)   
    //..........|.....| 0x00: set slave address
    //..........| 0xa0: set slave Device ID, select AT24C08 EEPROM

        I2C_ByteWrite(wBuf_FF, 16); 	
        I2C_Stop();						// generate stop condition

        //...wait AT24C08 pgm time >5ms......................
        delay_times(t_1ms, 10);
    }
	
	    //  read sequence
	/*  step1): I2C_start(), set slave Device ID,slave start address
	    step2): I2C_restart()
	    step3): I2C_ByteRead(sI2C.I2C_rBuf, data length)
	    step4): I2C_stop()
	*/
	
	//-------------------------------------------------------------------------------------------------------
    if(1){
        I2C_Start(0xa0, 0x00);			// set as master mode and generate start condition and transfer 1 byte data (0x00)    
    //..........|.....| 0x00: set slave address
    //..........| 0xa0: set slave Device ID, select AT24C08 EEPROM
        I2C_Restart(0xa1);          	// generate restart condition

        I2C_ByteRead(rBuf, 10);     	// receive 10 bytes of data
        I2C_Stop();						// generate stop condition
    }
	//-------------------------------------------------------------------------------------
    //  write sequence
    if(1){
        I2C_Start(0xa0, 0x00);			// set as master mode and generate start condition and transfer 1 byte data (0x00)    
    //..........|.....| 0x00: set slave address
    //..........| 0xa0: set slave Device ID, select AT24C08 EEPROM

        I2C_ByteWrite(wBuf, 3);     	// transmit 3 bytes of data
        I2C_Stop();						// generate stop condition

        //...wait AT24C08 pgm time >5ms......................
        delay_times(t_1ms, 10);
    }
	//-------------------------------------------------------------------------------------
    //  read sequence
    if(1){
        I2C_Start(0xa0, 0x00);			// set as master mode and generate start condition and transfer 1 byte data (0x00)    
    //..........|.....| 0x00: set slave address
    //..........| 0xa0: set slave Device ID, select AT24C08 EEPROM
        I2C_Restart(0xa1);          	// generate restart condition

        I2C_ByteRead(rBuf, 10);     	// receive 10 bytes of data
        I2C_Stop();						// generate stop condition
    }
	//-------------------------------------------------------------------------------------
    //  write sequence
    if(1){
        I2C_Start(0xa0, 0x06);			// set as master mode and generate start condition and transfer 1 byte data (0x06)   
    //..........|.....| 0x00: set slave address
    //..........| 0xa0: set slave Device ID, select AT24C08 EEPROM

        I2C_ByteWrite(wBuf, 2);     	// transmit 2 bytes of data
        I2C_Stop();						// generate stop condition

        //...wait AT24C08 pgm time >5ms......................
        delay_times(t_1ms, 10);
    }
	//-------------------------------------------------------------------------------------
    //  read sequence
    if(1){
        I2C_Start(0xa0, 0x00);			// set as master mode and generate start condition and transfer 1 byte data (0x00)    
    //..........|.....| 0x00: set slave address
    //..........| 0xa0: set slave Device ID, select AT24C08 EEPROM
        I2C_Restart(0xa1);          	// generate restart condition

        I2C_ByteRead(rBuf, 10);     	// receive 10 bytes of data
        I2C_Stop();
    }
	//-------------------------------------------------------------------------------------
    //  read sequence
    if(1){
        I2C_Start(0xa0, 0x05);			// set as master mode and generate start condition and transfer 1 byte data (0x05) 
    //..........|.....| 0x00: set slave address
    //..........| 0xa0: set slave Device ID, select AT24C08 EEPROM
        I2C_Restart(0xa1);          	// generate restart condition

        I2C_ByteRead(rBuf, 10);     	// receive 10 bytes of data
        I2C_Stop();
    }
	

	//-------------------------------------------------------------------------------------
	
	//-------------------------------------------------------------------------------------
    //  I2C master do loop
    while(1){
        CLR_WDT;						// clear the watchdog timer
    }

}
//  Master operation
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


















/*---------------------- interrupt service routine ------------------------*/
void __interrupt OnlyReti(void)
{
    NOP;                                // no operation
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10; 	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}     
/*-----------------  жϷ ------------------------*/

/*------------------------ interrupt vector ------------------------*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
    OnlyReti,           // 0xffc0 : IntTCC2P
    OnlyReti,           // 0xffc2 : IntTCC2T
    OnlyReti,           // 0xffc4 : IntTCC1P
    OnlyReti,           // 0xffc6 : IntTCC1T
    OnlyReti,           // 0xffc8 : IntTCA1
    OnlyReti,           // 0xffca : IntSIO1
    OnlyReti,           // 0xffcc : IntTCC0P
    OnlyReti,           // 0xffce : IntTCC0T
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    OnlyReti,           // 0xffd4 : Int5
    OnlyReti,           // 0xffd6 : Int4
    OnlyReti,           // 0xffd8 : Int3 / IntCMP1
    OnlyReti,           // 0xffda : Int2 / IntCMP0 / IntEMG0
    OnlyReti,           // 0xffdc : Int1 / IntCMP2
    OnlyReti,           // 0xffde : Int0 / IntCMP3
    OnlyReti,           // 0xffe0 : IntSBI
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,           // 0xffec : IntLVD
    OnlyReti,           // 0xffee : IntTXD0
    OnlyReti,           // 0xfff0 : IntRXD0
    OnlyReti,           // 0xfff2 : IntSIO0
    OnlyReti,           // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI / INTUNDEF
    STARTUP             // 0xfffe : RESET
};
#pragma section const
/*------------------- end of interrupt vector ------------------------*/

















//*********************************************************************
// name			: SYSTEM_INIT(void)
// brief		: IO, CGCR and P10/P40/P41 initialization during debugging
// note			:
//*********************************************************************
void SYSTEM_INIT(void)
{
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  (default): when emulation, set P10 to Reset pin to avoid affecting the emulation and program functions
    SET_P10_to_RESET_PIN;
//------------------------------------------------------------------
    FSCTRL_FSSEL = 0;                   // if the program has changed this bit, you need to manually initialize and clear it to the default value of 0 in the emulation mode 
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode), set P10 to GPIO pin
//------------------------------------------------------------------
//-- set P10 to GPIO pin ------
    SET_P10_to_IO_PIN;
//------------------------------------------------------------------
#endif



//-- pin configuration initialization (debug pin configuration)------
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  the simulation uses P10, P40 and P41 into Debug mode, which is set as an input during simulation
//  to avoid affecting the emulation and program functions
    P1DR = 0x00;
    P1CR = set8bit(11111110);           // set P10 as input pin
    P4DR = 0x00;
    P4CR = set8bit(11111100);           // set P40 and P41 as input pins
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- pin configuration initialization ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;
    P5DR = 0x00;
    P5CR = 0xff;
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;
//  sendout_I2C(IRSTSR);                // IRSTSR: internal factor reset detection status register
    CLR_WDT;                            // clear the watchdog timer


//--------------------------------------------------------------------------------------------------//
//  Please set the external crystal (HXTAL/LXTAL) from <main.h> and refer to the following instructions:
//  HXTAL/LXTAL use the same IO (P00/P01), only one of them can be enable
//.....................................................................................
//#undef    XTAL_High       // define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//#undef    XTAL_Low        // define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//          |........................................................................................
//          |---------> // Cautions:
//          |---------> // 1. to enable LXTAL, please set FSCTRL_FSSEL to 1 using bit operation
//          |---------> // 2. to enable external low-frequency crystal, you need to check the checkbox 'ext low OSC' when programming
//          |---------> //    programming by IDE : Project -> Pin Setting -> check 'ext low OSC'
//          |---------> //    programming by Writer : tap Type -> on the right side of the same page of IC type option -> check 'ext low OSC'
//          .........................................................................................
//--------------------------------------------------------------------------------------------------//
//	call function to select whether to switch the external high-frequency crystal oscillator
//  XTAL_High_Config();

}



//*********************************************************************
// name			: delay_times
// brief		: time delay function
// note			: ==> t_1ms   = 0;          // time delay unit ms
//          : ==> t_100us = 1;          // time delay unit us (this accuracy is not good)
//          : the example of using a fixed loop with a time delay is as follows:
//          : delay_times(t_1ms, 800);  // delay 800ms
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
    uint  i, cgcrT;

//  uchar cgcrF[4]={ 2, 4,  8, 1 };     // use this array when the high-speed crystal frequency is 8MHz
    uchar cgcrF[4]={ 4, 8, 16, 2 };     // use this array when the high-speed crystal frequency is 16MHz

//  the time delay function of the system at NORMAL1 mode and NORMAL2 mode
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  the time delay function of the system at SLOW1 mode and SLOW2 mode), which has a large error, is used for reference
    else for(; x>0; x--){}

    CLR_WDT;                            // clear the watchdog timer
}




//*********************************************************************
// name			:
// brief		:
// note			: emulate I2C with GPIO
//*********************************************************************
void sendout_I2C(uchar data)
{
    uchar iloop, x, z=10;

    io_SDA_cr = 1;                      // setting output port
    io_SCL_cr = 1;                      // setting output port

//	start condition......
    io_SDA = 1;         for(x=z; x>0; x--){}
    io_SCL = 1;         for(x=z; x>0; x--){}
    io_SDA = 0;         for(x=z; x>0; x--){}
    io_SCL = 0;         for(x=z; x>0; x--){}

//	sent byte data......
    for( iloop=0; iloop<8; iloop++ )
    {
        io_SDA = data >> 7;
        data   = data << 1;
        for(x=z; x>0; x--){}
        io_SCL = 1;     for(x=z; x>0; x--){}
        io_SCL = 0;     for(x=z; x>0; x--){}
    }
    io_SDA = 0;         for(x=z; x>0; x--){}
    io_SCL = 1;         for(x=z; x>0; x--){}
    io_SCL = 0;         for(x=z; x>0; x--){}

    //	stop condition......
    io_SDA = 0;         for(x=z; x>0; x--){}
    io_SCL = 1;         for(x=z; x>0; x--){}
    io_SDA = 1;         for(x=z; x>0; x--){}
}










