//******************************************
// file			: MQ6825_I2C.h
// version		: V1.1 2021/02/25
// brief		: I2C header file
// note			:
//******************************************
#ifndef _MQ6825_I2C_H_
#define _MQ6825_I2C_H_



void  I2C_Init(void);
void  I2C_Start(  uchar data, uchar address);
void  I2C_Restart(uchar data);
void  I2C_Stop(void);
void  I2C_ByteWrite(uchar *data, uchar len);
void  I2C_ByteRead( uchar *data, uchar len);
void  I2C_SetSlaveAddr(uchar addr);
void  I2C_IntEnable(void);
void  I2C_IntDisable(void);

void __interrupt IntSBI(void);


void  I2C_ByteWrite_FF();

//----------------------------------//
//  SBI0SR2*************************//
//----------------------------------//
//extern TYPE_BYTE sSBI0SR2;
typedef struct {
    uchar   MST:1;          // b7. MST: Master/Slave selection status monitor.==> 0).Slave, 1).Master
    uchar   TRX:1;          // b6. TRX: Transmitter/Receiver selection status monitor.==> 0).Receiver, 1).Transmitter
    uchar   BB :1;          // b5. BB : Bus status monitor.==> 0).Bus free, 1).Bus busy
    uchar   PIN:1;          // b4. PIN: Interrupt service requests status monitor.==> 0).Requesting interrupt service, 1).Releasing interrupt service request
    uchar   AL :1;          // b3. AL : Arbitration lost detection monitor
    uchar   AAS:1;          // b2. AAS: Slave address match detection monitor
    uchar   AD0:1;          // b1. AD0: "GENERAL CALL" detection monitor
    uchar   LRB:1;          // b0. LRB: Last received bit monitor
}   BIT_SBI0SR2;
typedef struct {
    uchar   NA:6;
    uchar   R1W0:1;         // read:1, write:0
    uchar   match_addr:1;   // slave address match detection
}   BIT_flag;


typedef struct {    
    BIT_flag        sFlag;  
    uchar           iAddr_st;       // Start address
    uchar           iAddr_pt;       //
    uchar           iByte;          // 
}   User_I2C;

extern User_I2C  Flow;
#endif  //_MQ6825_I2C_H_
