//******************************************
// file			: MQ6825_Flash.h
// version		: V1.1 2021/02/25
// brief		: Flash headerfile
// note			: make sure that the chip does not power off or reset before the FLASH function is completely
//******************************************
#ifndef _MQ6825_FLASH_H__
#define _MQ6825_FLASH_H__
//==============================================================================
// name			:Flash_WriteByte 
// retval		:0:write success  1:write fail<difference from expected value after writing>  2:write fail<not 0xFF before writing>
// param		:<addr>	specified address of flash memory(0x7E80~0x7EFF)
//     		 <data>	one byte of data to be written to flash memory
// note			:make sure the address to be written has no code, so as not to modify the structure of the program after writing
//==============================================================================
unsigned char Flash_WriteByte(unsigned int addr,unsigned char data);



//==============================================================================
// name			:FlashReadByte 
// retval		:unsigned char
// param		:<addr>	specified address of flash memory
// note			:the value of specified address of flash memory
//==============================================================================
unsigned char Flash_ReadByte(unsigned int addr);


//==============================================================================
// name			:Flash_ReadSequence
// retval		:void
// param		:<addr> specified start address of flash memory
//           <data> the values of specified addresses of flash memory
//           <length>read data length
// note			:
//==============================================================================
void Flash_ReadSequence(unsigned int addr,unsigned char* data,unsigned int length);

//==============================================================================
// name			:Flash_SectionErase 
// retval		:0:erase success  1:erase fail 3:invalid address parameter
// param		:<addr> specified address of flash memory area to be erased
// note			:The flash memory area to be erased is specified by the upper 9 bits of address(128 Bytes)
//     
//     		ex. if address =0x7e80 means section:0x7e80~0x7eff including 0x7e80, so erase area is 0x7e80~0x7eff  (128 Bytes)
//         		if address =0x7e99 means section:0x7e80~0x7eff including 0x7e99, so erase area is 0x7e80~0x7eff  (128 Bytes)
//         		if address =0x7eff means section:0x7e80~0x7eff including 0x7eff, so erase area is 0x7e80~0x7eff  (128 Bytes) 
//         		if address =0xf000 means section:0xf000~0xf07f including 0xf000, so erase area is 0xf000~0xf07f  (128 Bytes)
//         		if address =0xefff means section:0xef80~0xefff including 0xefff, so erase area is 0xef80~0xefff  (128 Bytes)
// 
//         section rule:0xXX00~0xXX7f , 0xXX80~0xXXff
// 
// 		   data flash memory area:
//         		<section>0x7e80~0x7eff
//  	   program flash memory area:
//         		<section>0x8000~0xc07f 
//         		<section>0x8080~0xc0ff 
//         		<section>0x8100~0xc17f 
//         		<section>0x8180~0xc1ff
//                         :
//                         :						  
//         		<section>0xff00~0xff7f 
//         		<section>0xff80~0xffff
//==============================================================================
unsigned char Flash_SectionErase(unsigned int addr);






#endif








