//******************************************
// file			: MQ6825_ExtINT
// version		: V1.1 2021/02/25
// brief		: ExtINT related functions
// note			: ExtINT related functions are gathered in this subroutine
//******************************************

#include "main.h"




//*********************************************************************
// name			: ExtINT_Init
// brief		: external interrupt initialization
// note			: 
//*********************************************************************
void ExtINT_Init(void)
{
	


//-------------------------------------------------------

// INT0: P92, POFFCR3_INT0EN, EINTCR0
// INT1: P93, POFFCR3_INT1EN, EINTCR1
// INT2: P75, POFFCR3_INT2EN, EINTCR2
// INT3: P76, POFFCR3_INT3EN, EINTCR3
// INT4: P77, POFFCR3_INT4EN, EINTCR4
// INT5: P25, POFFCR3_INT5EN, EINTCR5

//-------------------------------------------------------
//------ INT 0
/*
    P9CR_P2 = 0;						// pin initialization, set P92 as input pin

    POFFCR3_INT0EN = 1;					// enable function *this has to be enable first, so that the relevant storages can be set up later
    //====== parameter setting ======
    EINTCR0_NCE    = 1;                 // set the noise canceller sampling interval
    EINTCR0_INTES  = 0x00;              // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 
*/

//-------------------------------------------------------
//------ INT 1
/*
    P9CR_P3 = 0;						// pin initialization, set P93 as input pin

    POFFCR3_INT1EN = 1;					// enable function *this has to be enable first, so that the relevant storages can be set up later
    //====== parameter setting ======
    EINTCR1_NCE    = 1;                 // set the noise canceller sampling interval
    EINTCR1_INTES  = 0x00;              // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 
*/

//-------------------------------------------------------
//------ INT 2
/*
    P7CR_P5 = 0;						// pin initialization, set P75 as input pin

    POFFCR3_INT2EN = 1;					// enable function *this has to be enable first, so that the relevant storages can be set up later
	//====== parameter setting ======
	EINTCR2_NCE    = 1;                 // set the noise canceller sampling interval
	EINTCR2_INTES  = 0x00;              // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 
*/

//-------------------------------------------------------
//------ INT 3
/*
    P7CR_P6 = 0;						// pin initialization, set P76 as input pin

    POFFCR3_INT3EN = 1;					// enable function *this has to be enable first, so that the relevant storages can be set up later
	//====== parameter setting ======
	EINTCR3_NCE    = 1;                 // set the noise canceller sampling interval
	EINTCR3_INTES  = 0x00;              // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 
*/

//-------------------------------------------------------
//------ INT 4

    P7CR_P7 = 0;						// pin initialization, set P77 as input pin

    POFFCR3_INT4EN = 1;					// enable function *this has to be enable first, so that the relevant storages can be set up later
	//====== parameter setting ======
    EINTCR4_INTES  = 0;                 // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 

//-------------------------------------------------------
//------ INT 5
/*
    P2CR_P5 = 0;						// pin initialization, set P25 as input pin

    POFFCR3_INT5EN = 1;					// enable function *this has to be enable first, so that the relevant storages can be set up later
	//====== parameter setting ======
	EINTCR5_INTES  = 0x00;              // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 
*/
//-------------------------------------------------------

}

//*********************************************************************
// name			: ExtINT_IntEnable
// brief		: enable external interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void ExtINT_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
//-------------------------------------------------------

//------ INT 0
/*
    IL_INT0 = 0;                        // clear interrupt latch
	EI_INT0 = 1;                        // set interrupt enable flag
*/
//-------------------------------------------------------

//------ INT 1
/*
    IL_INT1 = 0;                        // clear interrupt latch
    EI_INT1 = 1;                        // set interrupt enable flag
*/
//-------------------------------------------------------

//------ INT 2
/*
    IL_INT2 = 0;                        // clear interrupt latch
    EI_INT2 = 1;                        // set interrupt enable flag
*/
//-------------------------------------------------------

//------ INT 3
/*
    IL_INT3 = 0;                        // clear interrupt latch
    EI_INT3 = 1;                        // set interrupt enable flag
*/
//-------------------------------------------------------

//------ INT 4

    IL_INT4 = 0;                        // clear interrupt latch
    EI_INT4 = 1;                        // set interrupt enable flag
    
//-------------------------------------------------------

//------ INT 5
/*
    IL_INT5 = 0;                        // clear interrupt latch
    EI_INT5 = 1;                        // set interrupt enable flag
*/
//-------------------------------------------------------
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}










//*********************************************************************
// name			: ExtINT_IntDisable
// brief		: disable external interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void ExtINT_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
//------------------------------------------------------------

//------ INT 0
/*
	IL_INT0 = 0;                        // clear interrupt latch
	EI_INT0 = 0;                        // clear interrupt enable flag
*/
//------------------------------------------------------------

//------ INT 1
/*
	IL_INT1 = 0;                        // clear interrupt latch
	EI_INT1 = 0;                        // clear interrupt enable flag
*/
//------------------------------------------------------------

//------ INT 2
/*
	IL_INT2 = 0;                        // clear interrupt latch
	EI_INT2 = 0;                        // clear interrupt enable flag
*/
//------------------------------------------------------------

//------ INT 3
/*
	IL_INT3 = 0;                        // clear interrupt latch
	EI_INT3 = 0;                        // clear interrupt enable flag
*/
//-----------------------------------------------------------

//------ INT 4

    IL_INT4 = 0;                        // clear interrupt latch
    EI_INT4 = 0;                        // clear interrupt enable flag

//----------------------------------------------------------

//------ INT 5
/*
	IL_INT5 = 0;                        // clear interrupt latch
	EI_INT5 = 0;                        // clear interrupt enable flag
*/

//----------------------------------------------------------
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}









//*********************************************************************
// name			: Int0
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int0(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: Int1
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int1(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: Int2
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int2(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: Int3
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int3(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: Int4
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int4(void)
{
	
	P8DR_P0 = !P8DR_P0; 				// toggle IO
    NOP;                                // no operation
	
}


//*********************************************************************
// name			: Int5
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int5(void)
{
    NOP;                                // no operation
}




























