//******************************************
// file			: MQ6825_CMP.c
// version		: V1.1 2021/02/25
// brief		: COMPARATOR related functions
// note			: CMP related functions are gathered in this subroutine
//******************************************

#include "main.h"





//*********************************************************************
// name			: CMP0_Init
// brief		: CMP0 initialization
// note			: set CMP0P, CMP0N and CMP0OUT function pins
//                enable function, set the source of external interrupt 2, and set the conditions required for generating the interrupt
//*********************************************************************
void CMP0_Init(void)
{
//====== pin configuration ======
    P5CR_P7 = 0;                        // set CMPxP 
    P5FC_P7 = 1;                        // set CMPxP 
    P5CR_P6 = 0;                        // set CMPxN
    P5FC_P6 = 1;                        // set CMPxN
    P5CR_P2 = 1;                        // set CMPxOUT
    P5FC_P2 = 1;                        // set CMPxOUT
//====== function enable ======
    POFFCR3_CMP01EN = 1;                // this has to be enable first, so that the relevant register can be set up later
    POFFCR3_INT2EN  = 1;                // to start CMP0 (CMP01EN), external interrupt 2 (INT2EN) must be enabled at the same time
//====== parameter setting ======
    EINTCR2_INTSEL  = 1;                // INTxSEL interrupt source ==> 0:INTx, 1:CMPx
    EINTCR2_INTES   = 0;                // an interrupt request is generated at the rising edge of the noise canceller pass signal
//  EINTCR2_INTES   = 1;                // an interrupt request is generated at the falling edge of the noise canceller pass signal
//  EINTCR2_INTES   = 2;                // an interrupt request is generated at both edges of the noise canceller pass signal
//  EINTCR2_INTES   = 3;                // an interrupt request is generated at H level of the noise canceller pass signal
}


//*********************************************************************
// name			: CMP1_Init
// brief		: CMP1 initialization
// note			: set CMP1P, CMP1N and CMP1OUT function pins
//                enable function, set the source of external interrupt 3, and set the conditions required for generating the interrupt
//*********************************************************************
void CMP1_Init(void)
{
//====== pin configuration ======
    P5CR_P4 = 0;                        // set CMPxP 
    P5FC_P4 = 1;                        // set CMPxP 
    P5CR_P5 = 0;                        // set CMPxN
    P5FC_P5 = 1;                        // set CMPxN
    P5CR_P3 = 1;                        // set CMPxOUT
    P5FC_P3 = 1;                        // set CMPxOUT
//====== function enable ======
    POFFCR3_CMP01EN = 1;                // this has to be enable first, so that the relevant register can be set up later
    POFFCR3_INT3EN  = 1;                // to start CMP1 (CMP01EN), external interrupt 3 (INT3EN) must be enabled at the same time
//====== parameter setting ======
    EINTCR3_INTSEL  = 1;                // INTxSEL interrupt source ==> 0:INTx, 1:CMPx
    EINTCR3_INTES   = 0;                // an interrupt request is generated at the rising edge of the noise canceller pass signal
//  EINTCR3_INTES   = 1;                // an interrupt request is generated at the falling edge of the noise canceller pass signal
//  EINTCR3_INTES   = 2;                // an interrupt request is generated at both edges of the noise canceller pass signal
//  EINTCR3_INTES   = 3;                // an interrupt request is generated at H level of the noise canceller pass signal
}


//*********************************************************************
// name			: CMP2_Init
// brief		: CMP2 initialization
// note			: set CMP2P, CMP2N and CMP2OUT function pins
//                enable function, set the source of external interrupt 1, and set the conditions required for generating the interrupt
//*********************************************************************
void CMP2_Init(void)
{
//====== pin configuration ======
    P9CR_P2 = 0;                        // set CMPxP 
    P9FC_P2 = 1;                        // set CMPxP 
    P9CR_P3 = 0;                        // set CMPxN
    P9FC_P3 = 1;                        // set CMPxN
    P2CR_P2 = 1;                        // set CMPxOUT
    P2FC_P2 = 1;                        // set CMPxOUT
//====== function enable ======
    POFFCR3_CMP23EN = 1;                // this has to be enable first, so that the relevant register can be set up later
    POFFCR3_INT1EN  = 1;                // to start CMP2 (CMP23EN), external interrupt 1 (INT1EN) must be enabled at the same time
//====== parameter setting ======
    EINTCR1_INTSEL  = 1;                // INTxSEL interrupt source ==> 0:INTx, 1:CMPx
    EINTCR1_INTES   = 0;                // an interrupt request is generated at the rising edge of the noise canceller pass signal
//  EINTCR1_INTES   = 1;                // an interrupt request is generated at the falling edge of the noise canceller pass signal
//  EINTCR1_INTES   = 2;                // an interrupt request is generated at both edges of the noise canceller pass signal
//  EINTCR1_INTES   = 3;                // an interrupt request is generated at H level of the noise canceller pass signal
}


//*********************************************************************
// name			: CMP3_Init
// brief		: CMP3 initialization
// note			: set CMP3P, CMP3N and CMP3OUT function pins
//                enable function, set the source of external interrupt 0, and set the conditions required for generating the interrupt
//*********************************************************************
void CMP3_Init(void)
{
//====== pin configuration ======
    P8CR_P7 = 0;                        // set CMPxP 
    P8FC_P7 = 1;                        // set CMPxP 
    P8CR_P6 = 0;                        // set CMPxN
    P8FC_P6 = 1;                        // set CMPxN
    P2CR_P5 = 1;                        // set CMPxOUT
    P2FC_P5 = 1;                        // set CMPxOUT
//====== function enable ======
    POFFCR3_CMP23EN = 1;                // this has to be enable first, so that the relevant register can be set up later
    POFFCR3_INT0EN  = 1;                // to start CMP3 (CMP23EN), external interrupt 0 (INT0EN) must be enabled at the same time
//====== parameter setting ======
    EINTCR0_INTSEL  = 1;                // INTxSEL interrupt source ==> 0:INTx, 1:CMPx
    EINTCR0_INTES   = 0;                // an interrupt request is generated at the rising edge of the noise canceller pass signal
//  EINTCR0_INTES   = 1;                // an interrupt request is generated at the falling edge of the noise canceller pass signal
//  EINTCR0_INTES   = 2;                // an interrupt request is generated at both edges of the noise canceller pass signal
//  EINTCR0_INTES   = 3;                // an interrupt request is generated at H level of the noise canceller pass signal
}


//*********************************************************************
// name			: CMP_Start
// brief		:
// note			:
//*********************************************************************
void CMP_Start(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: CMP_Stop
// brief		:
// note			:
//*********************************************************************
void CMP_Stop(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: CMP0_IntEnable
// brief		: enable CMP0 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void CMP0_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    ILE_IL18        = 0;                // clear interrupt latch
    EI_CMP0         = 1;                // enable interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: CMP1_IntEnable
// brief		: enable CMP1 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void CMP1_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    ILE_IL19        = 0;                // clear interrupt latch
    EI_CMP1         = 1;                // enable interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: CMP2_IntEnable
// brief		: enable CMP2 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void CMP2_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    ILE_IL17        = 0;                // clear interrupt latch
    EI_CMP2         = 1;                // enable interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: CMP3_IntEnable
// brief		: enable CMP3 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void CMP3_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    ILE_IL16        = 0;                // clear interrupt latch
    EI_CMP3         = 1;                // enable interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: CMP0_IntDisable
// brief		: disable CMP0 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void CMP0_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    ILE_IL18        = 0;                // clear interrupt latch
    EI_CMP0         = 0;                // disable interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: CMP1_IntDisable
// brief		: disable CMP1 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void CMP1_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    ILE_IL19        = 0;                // clear interrupt latch
    EI_CMP1         = 0;                // disable interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: CMP2_IntDisable
// brief		: disable CMP2 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void CMP2_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    ILE_IL17        = 0;                // clear interrupt latch
    EI_CMP2         = 0;                // disable interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: CMP3_IntDisable
// brief		: disable CMP3 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void CMP3_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    ILE_IL16        = 0;                // clear interrupt latch
    EI_CMP3         = 0;                // disable interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: IntCMP0
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntCMP0(void)
{
    //P8DR_P0 = 1;                        // toggle IO
    //P8DR_P0 = 0;                        // toggle IO
	P8DR_P0=!P8DR_P0;
	
    NOP;                                // no operation
}


//*********************************************************************
// name			: IntCMP1
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntCMP1(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: IntCMP2
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntCMP2(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: IntCMP3
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntCMP3(void)
{
    NOP;                                // no operation
}


























