//*********************************************************************
// file			: MQ6823_UART.c
// version		: V1.0 2019/04/18
// brief		: UART related functions
// note			: UART related functions are gathered in this subroutine
//*********************************************************************

#include "main.h"

unsigned char RX0_DATA,recvCnt;

extern unsigned char recvBuf[10];	

//*********************************************************************
// name			: UART0_Init
// brief		: UART initialization ***this example UART uses P20(TX) and P21(RX)
// note			: operation mode must be NORMAL1 mode and NORMAL2 mode
//*********************************************************************
void UART0_Init(void)
{

//====== select P20/P21 as UART0 input/output pin ======
   P2CR_P1 = 0;                        // set P21 as input pin
   P2CR_P0 = 1;                        // set P20 as output pin
	
   P2FC_P0 = 1;                        // set P20 as special function pin


   UATCNG_UAT0IO = 0;				   // set P20/P21 as UART input/output pin
									   // 0: set P20 to TX and P21 to RX
									   // 1: set P21 to TX and P20 to RX	


//---------------------------------------------------------------------------------------------------------------

							
//====== enable function ======

//use P20 and P21 => UART0	
    POFFCR1_UART0EN = 1;                // this register must be enable first and then the related registers settings will work
	

//====== parameter setting ======
	UART0CR1_STOPBT	= 0;				// transmit stop bit length : 1 bit
	UART0CR2_STOPBR	= 0;				// receive stop bit length : 1 bit
	UART0CR1_PE		= 0;				// no parity	
	UART0CR1_BRG	= 0;				// 0: transfer base clock selection = fcgck
										// 1: transfer base clock selection = TCA0 output

//------ Baud rate setting = 9600 -------   
//--- fcgck @ 16MHz
/*
    UART0CR2_RTSEL = 0x01;
    UART0DR        = 0x64;
*/
 
//--- fcgck @ 8MHz
/*
    UART0CR2_RTSEL = 0x04;
    UART0DR        = 0x30;

*/

//*** fcgck @ 4MHz                      *this example uses Baud rate = 9600,fcgck @ 4MHz
	
	UART0CR2_RTSEL = 0x00;
    UART0DR        = 0x19;	
    
//--- fcgck @ 2MHz
/* 
    UART0CR2_RTSEL = 0x00;
    UART0DR        = 0x0c;
*/

//------ Baud rate setting = 115200 -----
//--- fcgck @ 16MHz
/* 
    UART0CR2_RTSEL = 0x03;
    UART0DR        = 0x08;
*/
 
//--- fcgck @ 8MHz
/* 
    UART0CR2_RTSEL = 0x04;
    UART0DR        = 0x03;
	*/
 
//--- fcgck @ 4MHz
/* 
    UART0CR2_RTSEL = 0x04;
    UART0DR        = 0x01;
*/

//--- fcgck @ 2MHz
/* 
    UART0CR2_RTSEL = 0x04;
    UART0DR        = 0x00;
*/

}


//*********************************************************************
// name			: UART0_Start
// brief		: start UART0
// note			:
//*********************************************************************
void UART0_Start(void)
{
    UART0CR1_TXE = 1;                   // enable TX
    UART0CR1_RXE = 1;                   // enable RX
}


//*********************************************************************
// name			: UART0_Stop
// brief		: stop UART0
// note			:
//*********************************************************************
void UART0_Stop(void)
{
    UART0CR1_TXE = 0;                   // disable TX
    UART0CR1_RXE = 0;                   // disable RX
}


//*********************************************************************
// name			: UART0_IntEnable
// brief		: enable UART0 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void UART0_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
/*    
  	IL_INTTXD0      = 0;                // clear TX interrupt latch
  	EI_INTTXD0      = 1;                // enable TX interrupt
*/
    IL_INTRXD0      = 0;                // clear RX interrupt latch
    EI_INTRXD0      = 1;                // enable RX interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: UART0_IntDisable
// brief		: disable UART0 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void UART0_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
/*   
	 IL_INTTXD0      = 0;               // clear TX interrupt latch
	 EI_INTTXD0      = 0;               // disable TX interrupt
*/
    IL_INTRXD0      = 0;                // clear RX interrupt latch
    EI_INTRXD0      = 0;                // disable RX interrupt
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: IntRXD0
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntRXD0(void)
{
	BIT_LIST_8 uart_flag;
	
	uart_flag.byte = UART0SR;			//get flag data

										//                bit7  bit6  bit5	bit4  bit3  bit2  bit1  bit0
	 									// get flag data [PERR, FERR, OERR,   -,  RBSY, RBFL, TBSY, TBFL]
                                        // PERR    parity error flag   	     0: no parity error
                                        //                              	 1: parity error
                                        // RFERR   framing error flag        0: no framing error
                                        //                          	     1: framing error
                                        // OERR    overrun error flag        0: no overrun error
                                        //                          	     1: overrun error
                                        // RBSY    receive busy flag         0: before receiving or end of receiving
                                        //                           	     1: on receiving
                                        // RBFL    receive buffer full flag  0: receive buffer empty
                                        //                           	     1: receive buffer full
                                        // TBSY    transmit busy flag        0: before transmission or end of transmission
                                        //                           	     1: on transmitting
                                        // TBFL    transmit buffer full flag 0: transmit buffer empty
                                        //                            	     1: transmit buffer full
									
	RX0_DATA = RD0BUF;					// get Rx data and clear UART0SR flag										
	// Error handle
	if(uart_flag.bit.b7 == 1){
										// parity error
	}
	else if(uart_flag.bit.b6 == 1){
										// framing error
	}
	else if(uart_flag.bit.b5 == 1){
										// overrun error
	}
	else{
		recvBuf[(recvCnt++)%10]= RX0_DATA;		// No Error, store the data
		
	}
	
	
}





//*********************************************************************
// name			: UART0_senddata
// brief		: UART0 ䷶
// note			:
//*********************************************************************
void UART0_senddata(uchar* buf,uint length)
{
    uint sendloop;

    for( sendloop = 0; sendloop < length; sendloop++ )
    {
        while( UART0SR_TBFL ==1 )           // wait for buffer empty
        {
            CLR_WDT;                    // clear the watchdog timer
        }
        
        TD0BUF = buf[sendloop];			// write the data to buffer
    }

    while( UART0SR_TBSY ==1 )               // wait for end of transmission
    {
        CLR_WDT;                        // clear the watchdog timer
    }
}













