//******************************************
// file			: MQ6823_TCC.c
// version		: V1.0 2019/04/09
// brief		: initial,setup,operation
// note			:
//******************************************

#include "main.h"




//*********************************************************************
// name			: TCC1_PPGC1x_Init
// brief		: TCC1 PPGC11/PPGC12 output with variable duty ratio
// note			:
//          : use the following procedure to configure the control and setup registers in sequence
//          : 1. mode configuration : TCxCR1, TCxCR2
//          : 2. dead time and pulse width configuration: TCxDRA, TCxDRB, TCxDRD, TCxDRE (it is only necessary if the relevant modes used)
//          : 3. period configuration: TCxDRC
//          : 4. timer control: TCxCR3
//*********************************************************************
void TCC1_PPGC1x_Init(void)
{
//====== pin configuration ======
    P8CR_P0 = 1;                        // set P80(PPGC11B) as output pin
    P8CR_P1 = 1;                        // set P81(PPGC12B) as output pin

//====== enable function ======
    POFFCR0_TCC1EN = 1;		            // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
	

//------ ------ ------ ------ ------ ------
// 1. mode configuration : TC1CR1, TC1CR2
//------ ------ ------ ------ ------ ------
    TC1CR1_TCCCK    =  0x02;            // TCCCK: select source clock
                    // 0x00: fcgck
                    // 0x01: fcgck/2
                    // 0x02: fcgck/2^2
                    // 0x03: fcgck/2^3
    TC1CR1_PPGC1INI = 0;                // set the initial value of PPG11 output to low (positive logic)
    TC1CR1_PPGC2INI = 0;                // set the initial value of PPG12 output to low (positive logic)
//	set function pins after function initialization
    P8FC_P0 = 1;                        // set P80(PPGC11B) as special function pin
    P8FC_P1 = 1;                        // set P81(PPGC12B) as special function pin

//------ ------ ------ ------ ------ ------
    TC1CR2_TCCOUT   =  0x00;            // TCCOUT: select an output waveform mode
                    // 0x00: PPGC11/PPGC12 independent output
                    // 0x01: *reserved
                    // 0x02: output with variable duty ratio
                    // 0x03: output with 50% duty ratio

//------ ------ ------ ------ ------ ------
// 2. dead time and pulse width configuration: TC1DRA, TC1DRB, TC1DRD, TC1DRE (it is only necessary if the relevant modes used)
//------ ------ ------ ------ ------ ------
    TC1DRAL         = 0x06;             // dead time 1 setup register (low byte)   6
    TC1DRAH         = 0x00;             // dead time 1 setup register (high byte)

    TC1DRBL         = 0x20;             // pulse width 1 setup register (low byte)      32
    TC1DRBH         = 0x00;             // pulse width 1 setup register (high byte)

    TC1DRDL         = 0x10;             // dead time 2 setup register (low byte)   16
    TC1DRDH         = 0x00;             // dead time 2 setup register (high byte)

    TC1DREL         = 0x80;             // pulse width 2 setup register (low byte)      128
    TC1DREH         = 0x00;             // pulse width 2 setup register (high byte)

//------ ------ ------ ------ ------ ------
// 3. period configuration: TC1DRC
//------ ------ ------ ------ ------ ------
    TC1DRCL         = 0x80;             // period setup register (low byte)        128
    TC1DRCH         = 0x00;             // period setup register (high byte)

//------ ------ ------ ------ ------ ------
// 4. timer control: TC1CR3
//------ ------ ------ ------ ------ ------
    TC1CR3_STM      = 0x00;             // STM: select the state when stopped. select continuous or one-time output.
                //  --------|---------------------|----------------------------------
                //          | TCCST=1             | TCCST=0
                //  --------|---------------------|----------------------------------
                //    0x00: | continuous output   | immediately stop and clear the counter with the output initialized
                //    0x02: | continuous output   | immediately stop and clear the counter with the output initialized
                //    0x04: | one-time output     | stop the counter after completing output in the current period
                //    0x06: | reserved            | reserved
                //  --------|---------------------|----------------------------------

}


//*********************************************************************
// name			: TCC1_PPGC1x_Start
// brief		: start TCC1
// note			:
//*********************************************************************
void TCC1_PPGC1x_Start(void)
{
    TC1CR3_TCCST    = 1;                
}


//*********************************************************************
// name			: TCC1_PPGC1x_Stop
// brief		: stop TCC1
// note			: 
//*********************************************************************
void TCC1_PPGC1x_Stop(void)
{
    TC1CR3_TCCST    = 0;                
}


//*********************************************************************
// name			: TCC1_PPGC1x_IntEnable
// brief		: enable TCC1P and TCC1T interrupts
// note			:
//*********************************************************************
void TCC1_PPGC1x_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTCC1T     = 0;                // clear interrupt latch
    EI_INTTCC1T     = 1;                // set interrupt enable flag
    IL_INTTCC1P     = 0;                // clear interrupt latch
    EI_INTTCC1P     = 1;                // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: TCC1_PPGC1x_IntDisable
// brief		: disable TCC1P and TCC1T interrupts
// note			:
//*********************************************************************
void TCC1_PPGC1x_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTCC1T     = 0;                // clear interrupt latch
    EI_INTTCC1T     = 0;                // clear interrupt enable flag
    IL_INTTCC1P     = 0;                // clear interrupt latch
    EI_INTTCC1P     = 0;                // clear interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: IntTCC1T
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTCC1T(void)
{
    NOP;                                // no operation
}



//*********************************************************************
// name			: IntTCC1P
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTCC1P(void)
{
    NOP;                                // no operation
}




