//**************************************************************
// file			: main.c
// version		: V1.0 2019/04/09
// brief		: main program
// note			: SIO master transmit/receive example with "SIO_Slave" program
//**************************************************************
#ifndef IO_MEM
#define IO_MEM
#endif

#include "main.h"

/* ---------------------- global variables ------------------------ */
BIT_LIST_8  _flag_8bit;
BIT_LIST_16 _flag_16bit;
uchar buf2[10];

/* ---------------------- main program -------------------------- */
void main(){
    /* ---------------------- system initialization ------------------------ */
    SYSTEM_INIT();

    /* ---------------------- function initialization ------------------- */
    delay_times(t_1ms, 100);
    SIO_Init(); 						//SIO initialization


//------------------------------------------------------------------------
//  1. this example is for SIO master transmission
//  2. it can be used to communicate with the SIO_Slave example chip for write and read operations
//  3. the basic commands are as follows:
//     3-1. 0x9f master reads Device ID 0xaa 0x68 0x23
//     3-2. 0x03 master reads data from slave
//     3-3. 0x02 master writes data to slave



//  transmit command command 0x9f to read Device ID like0xaa 0x68 0x23
    wBUF_data[0] = 0x9f;                // command byte
    SIO_ByteSend(wBUF_data, 1);
    SIO_ByteRead(rBUF_data, 3);
    CLR_WDT;                            // clear the watchdog timer
    delay_times(t_1ms, 1);


//  transmit command command 0x03 to read data from slave
    wBUF_data[0] = 0x03;                // command byte
    SIO_ByteSend(wBUF_data, 1);
    SIO_ByteRead(rBUF_data, 10);
    CLR_WDT;                            // clear the watchdog timer
    delay_times(t_1ms, 1);


//  transmit command command 0x02 to write data to slave
    wBUF_data[0] = 0x02;                // command byte
    wBUF_data[1] = 0x5a;                // PGM data 0
    wBUF_data[2] = 0xa5;                // PGM data 1
    wBUF_data[3] = 0x12;                // PGM data 2
    wBUF_data[4] = 0x37;                // PGM data 3
    wBUF_data[5] = 0x89;                // PGM data 4

    SIO_ByteSend(wBUF_data, 6);
    SIO_ReservedStopWait();
    CLR_WDT;                            // clear the watchdog timer
    delay_times(t_1ms, 1);


//  transmit command command 0x03 to read data from slave
    wBUF_data[0] = 0x03;                // command byte
    SIO_ByteSend(wBUF_data, 1);
    SIO_ByteRead(rBUF_data, 10);
    CLR_WDT;                            // clear the watchdog timer
    delay_times(t_1ms, 1);
    //-----------------------------------

//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    while(1)
    {
        CLR_WDT;                        // clear the watchdog timer

        NOP;                            // no operation
        NOP;                            // no operation
        NOP;                            // no operation
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


















/*---------------------- interrupt service routine ------------------------*/
//=============== Dummy function for interrupt ============
void __interrupt Int_dummy(void)
{

}
//=========================================================


void __interrupt OnlyReti(void)
{
    NOP;                                // no operation
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10; 	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}     /*-----------------  жϷ ------------------------*/

/*---------------------- MQ6823 interrupt vector --------------------*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
    Int_dummy,          // 0xffc0 : Reserved
    Int_dummy,          // 0xffc2 : Reserved
    OnlyReti,           // 0xffc4 : IntTCC1P
    OnlyReti,           // 0xffc6 : IntTCC1T
    OnlyReti,           // 0xffc8 : IntTCA1
    Int_dummy,          // 0xffca : Reserved
    Int_dummy,          // 0xffcc : Reserved
    Int_dummy,          // 0xffce : Reserved
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    Int_dummy,          // 0xffd4 : Reserved
    Int_dummy,          // 0xffd6 : Reserved
    OnlyReti,          	// 0xffd8 : Int3 / IntEMG1
    OnlyReti,           // 0xffda : Int2 
    OnlyReti,           // 0xffdc : Int1
    OnlyReti,           // 0xffde : Int0
    OnlyReti,           // 0xffe0 : IntSBI
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,           // 0xffec : IntVLTD
    OnlyReti,           // 0xffee : IntTXD0
    OnlyReti,           // 0xfff0 : IntRXD0
    OnlyReti,           // 0xfff2 : IntSIO0
    OnlyReti,           // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI / INTUNDEF
    STARTUP             // 0xfffe : RESET
};
#pragma section const
/*------------------- end of MQ6823 interrupt vector -------------------*/

















//*********************************************************************
// name			: SYSTEM_INIT(void)
// brief		: IO, CGCR and P10/P40/P41 initialization during debugging
// note			:
//*********************************************************************
void SYSTEM_INIT(void)
{

//=============================================================================
//  Set CGCR
//=============================================================================
//  ============================================
//  clock gear control registerCGCR                                  fc   = 16MHz
//  ============================================
    CGCR_FCGCKSEL = 0x00;           // (system clock) fcgck = fc/4 =  4Mhz(default)
//  CGCR_FCGCKSEL = 0x01;           // (system clock) fcgck = fc/2 =  8Mhz
//  CGCR_FCGCKSEL = 0x02;           // (system clock) fcgck = fc   = 16Mhz
//  CGCR_FCGCKSEL = 0x03;           // (system clock) fcgck = fc/8 =  2Mhz
//  ============================================
//  *** do not change the value of CGCR<FCGCKSEL> register in low-speed mode (SLOW1/SLOW2)
//  ============================================

#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  (default): when emulation, set P10 to Reset pin to avoid affecting the emulation and program functions
//  SET_P10_to_RESET_PIN;
//------------------------------------------------------------------
    FSCTRL_FSSEL = 0;                   // if the program has changed this bit, you need to manually initialize and clear it to the default value of 0 in the emulation mode 
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode), set P10 to GPIO pin
//------------------------------------------------------------------
//-- set P10 to GPIO pin ------
    SET_P10_to_IO_PIN;
//------------------------------------------------------------------
#endif



//-- pin configuration initialization (debug pin configuration)------
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  the simulation uses P10, P40 and P41 into Debug mode, which is set as an input during simulation
//  to avoid affecting the emulation and program functions
    P1DR = 0x00;
    P1CR = set8bit(11111110);           // set P10 as input pin
    P4DR = 0x00;
    P4CR = set8bit(11111100);           // set P40 and P41 as input pins
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- pin configuration initialization ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;
    P5DR = 0x00;
    P5CR = 0xff;
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;

    CLR_WDT;                            // clear the watchdog timer
}
//*********************************************************************
// name			: delay_times
// brief		: time delay function
// note			: ==> t_1ms   = 0;          // time delay unit ms
//          : ==> t_100us = 1;          // time delay unit us (this accuracy is not good)
//          : the example of using a fixed loop with a time delay is as follows:
//          : delay_times(t_1ms, 800);  // delay 800ms
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
    uint  i, cgcrT;

//  uchar cgcrF[4]={ 2, 4,  8, 1 };     // use this array when the high-speed crystal frequency is 8MHz
    uchar cgcrF[4]={ 4, 8, 16, 2 };     // use this array when the high-speed crystal frequency is 16MHz

//  the time delay function of the system at NORMAL1 mode and NORMAL2 mode
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  the time delay function of the system at SLOW1 mode and SLOW2 mode), which has a large error, is used for reference
    else for(; x>0; x--){}

    CLR_WDT;                            // clear the watchdog timer
}

