//******************************************
// file			: main.h
// version		: V1.0 2019/04/17
// brief		: header file of this example
// note			: the custom variables used are collected in this document in this header file
//******************************************
#ifndef _INCLUDES_H__
#define _INCLUDES_H__

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "MQ6823_SFR.h"    // declare the detailed names represented by each bit of the special function registers
#include "MQ6823_RTC.h"


//****************************************************
//  binary values in C **********************
//****************************************************
#define Define2Bin(n)        \
(                            \
    ( ( n >> 21 ) & 0x80 ) | \
    ( ( n >> 18 ) & 0x40 ) | \
    ( ( n >> 15 ) & 0x20 ) | \
    ( ( n >> 12 ) & 0x10 ) | \
    ( ( n >>  9 ) & 0x08 ) | \
    ( ( n >>  6 ) & 0x04 ) | \
    ( ( n >>  3 ) & 0x02 ) | \
    ( ( n       ) & 0x01 )   \
)
#define set8bit(n)  Define2Bin(0x##n##L)
//  the value can be written in binary in the program:
//  tempVAR = set8bit(10101010);   <==>   temp = 0xAA;
//****************************************************


//*******************************************************************************
//  define variables as occupying only one bit or a small number of bits in size
//  Note: variables defined in bit units in this way cannot be viewed in the IDE's watch window
//        you can only view the variables of this byte such as _flag_8bit
//*******************************************************************************
extern  BIT_LIST_8  _flag_8bit;

#define flag_8bit   _flag_8bit.byte
#define flag_7      _flag_8bit.bit.b7
//#define flag_6      _flag_8bit.bit.b6
//#define flag_5      _flag_8bit.bit.b5
//#define flag_4      _flag_8bit.bit.b4
#define flag_6_4    _flag_8bit.b6_4.b6_4  // define 3-bit variables
#define flag_3      _flag_8bit.bit.b3
#define flag_2      _flag_8bit.bit.b2
//#define flag_1      _flag_8bit.bit.b1
//#define flag_0      _flag_8bit.bit.b0
#define flag_1_0    _flag_8bit.b1_0.b1_0  // define 2-bit variables


//*******************************************************************************
//  declare the variables of BIT_LIST_16, after that, only one bit size can be defined
//  Note: variables defined in bit units in this way cannot be viewed in the IDE's watch window
//        you can only view the variables of this byte such as _flag_16bit
//*******************************************************************************
extern  BIT_LIST_16 _flag_16bit;

#define flag_16bit  _flag_16bit.word
#define flag_15     _flag_16bit.bit.b15
#define flag_14     _flag_16bit.bit.b14
#define flag_13     _flag_16bit.bit.b13
#define flag_12     _flag_16bit.bit.b12
#define flag_11     _flag_16bit.bit.b11
#define flag_10     _flag_16bit.bit.b10
#define flag_09     _flag_16bit.bit.b9
#define flag_08     _flag_16bit.bit.b8
#define flag_07     _flag_16bit.bit.b7
#define flag_06     _flag_16bit.bit.b6
#define flag_05     _flag_16bit.bit.b5
#define flag_04     _flag_16bit.bit.b4
#define flag_03     _flag_16bit.bit.b3
#define flag_02     _flag_16bit.bit.b2
#define flag_01     _flag_16bit.bit.b1
#define flag_00     _flag_16bit.bit.b0


//****************************************************
#define BIT0  0x0001
#define BIT1  0x0002
#define BIT2  0x0004
#define BIT3  0x0008
#define BIT4  0x0010
#define BIT5  0x0020
#define BIT6  0x0040
#define BIT7  0x0080
#define BIT8  0x0100
#define BIT9  0x0200
#define BIT10 0x0400
#define BIT11 0x0800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000

#define M_SET(n,c)  ((n) |=  (c))     
#define M_CLR(n,c)  ((n) &= ~(c))

//****************************************************
//  delay_times(t_1ms, 800);            // for NORMAL mode, not for SLOW mode
void delay_times(uchar tBase, uint x);  // for NORMAL mode, not for SLOW mode
//...................|...........| x: set delay time
//...................| tBase: set delay time unit like t_1ms, t_100us tec, etc....
#define t_1ms   0
#define t_100us 1




/* ---------------------- extern startup function ------------------------ */
extern void STARTUP(void);

/* ---------------------- ****** ****** ****** ------------------------ */
void SYSTEM_INIT(void);


/* ---------------------- ****** ****** ****** ------------------------ */





/*********************************************
* recommendations and precautions for transition of operation modes
**********************************************
//  --------:----------------------------------------------------------
//  Operating Mode Switching Sequence :
//  NORMAL1	--> NORMAL2 --> SLOW2 --> SLOW1
//  SLOW1 --> SLOW2 --> NORMAL2 --> NORMAL1
//  --------:----------------------------------------------------------
//*********************************************************************
//          : Each Mode Switch Sequence
//  NORMAL1 :----------------------------------------------------------
//          : --> NORMAL1
//          : --> IDLE0 (can only be woken up by "TBT interrupt" to return to NORMAL1)
//          : --> IDLE1 (can be woken up by "all interrupts" to return to MORMAL1)
//          : --> STOP  (can only be woken up by the "KWI pins" to return to NORMAL1)
//  NORMAL2 :----------------------------------------------------------
//          : --> NORMAL2
//          : --> IDLE2 (can be woken up by "all interrupts" to return to MORMAL2)
//          : --> STOP  (can only be woken up by the "KWI pins" to return to NORMAL2)
//  SLOW2   :----------------------------------------------------------
//          : --> SLOW2
//  SLOW1   :----------------------------------------------------------
//          : --> SLOW1
//          : --> SLEEP0 (can only be woken up by "TBT interrupt" to return to SLOW1)
//          : --> SLEEP1 (can be woken up by "all interrupts" to return to SLOW1)
//          : --> STOP   (can only be woken up by the "KWI pins" to return to SLOW1)
//  --------:----------------------------------------------------------
**********************************************************************/
//--------------------------------------------------------------------------------------------------//
//Cautions:
//        1. to enable LXTAL, please set FSCTRL_FSSEL to 1 using bit operation
//        2. to enable external low-frequency crystal, you need to check the checkbox 'ext low OSC' when programming
//           |---------> //    programming by IDE : Project -> Pin Setting -> check 'ext low OSC'
//           |---------> //    programming by Writer : tap Type -> on the right side of the same page of IC type option -> check 'ext low OSC'
//--------------------------------------------------------------------------------------------------//

#define Entry_IDLE0     SYSCR2_TGHALT = 1       // TGHALT: (NORMAL1->IDLE0) / (SLOW1->SLEEP0) mode
#define Entry_SLEEP0    SYSCR2_TGHALT = 1       // TGHALT: (NORMAL1->IDLE0) / (SLOW1->SLEEP0) mode

#define Entry_IDLE1     SYSCR2_IDLE   = 1       // IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode
#define Entry_IDLE2     SYSCR2_IDLE   = 1       // IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode
#define Entry_SLEEP1    SYSCR2_IDLE   = 1       // IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode

#define Entry_STOP  {   SYSCR1_OUTEN  = 1; SYSCR1_RELM = 1; SYSCR1_STOP = 1; }
                    //  SYSCR1_OUTEN  = 1;      // OUTEN=1, set the port output state in the STOP mode to output hold
                    //                          // in STOP mode, please note that the input pins should not be left floating, or the last used pin should be set as the output pin
                    //                          // floating the input pin will cause unknown leakage
                    //  SYSCR1_RELM   = 1;      // RELM=1, set the STOP mode release method to level-sensitive release mode
                    //  SYSCR1_STOP   = 1;      // enter STOP mode
//--------------------------------------------------------------------------------------------------//




#endif //#ifndef _INCLUDES_H__