//******************************************
// file			: MQ6823_RTC.c
// version		: V1.0 2019/04/09
// brief		: RTC related functions
// note			: RTC related functions are gathered in this subroutine
//******************************************

#include "main.h"

//*********************************************************************
// name			: RTC_Init
// brief		: RTC initialization
// note			:
//*********************************************************************
void RTC_Init(void)
{
//====== parameter setting ======
    POFFCR2_RTCEN  = 1;					// this register must be enable first and then the related registers settings will work
    RTCCR_RTCSEL   = 0;                 // RTC interrupt frequency = 1 Hz   //@20190109*
                                        //         period = 1 sec    

// --------------------------------------------------										
// <RTCSEL> =0 =>1      sec  
//          =1 =>0.5    sec
//			=2 =>0.25   sec
//			=3 =>0.125  sec = 125ms  
//			=4 =>0.0625 sec = 62.5ms
//			=5 =>0.03125sec = 31.25ms
//			=6 =>0.01563sec = 15.625ms
//			=7 =>0.00781sec = 7.8125ms					
// ----------------------------------------------------																				
																				
    NOP;                                // no operation
}


//*********************************************************************
// name			: RTC_Start
// brief		: start RTC
// note			:
//*********************************************************************
void RTC_Start(void)
{
    RTCCR_RTCRUN   = 1;
}


//*********************************************************************
// name			: RTC_Stop
// brief		: stop RTC
// note			:
//*********************************************************************
void RTC_Stop(void)
{
    RTCCR_RTCRUN   = 0;
}


//*********************************************************************
// name			: RTC_IntEnable
// brief		: enable RTC interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void RTC_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTRTC  = 0;                     // clear interrupt latch
    EI_INTRTC  = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: RTC_IntDisable
// brief		: disable RTC interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void RTC_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTRTC  = 0;                     // clear interrupt enable flag
    IL_INTRTC  = 0;                     // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: IntRTC
// brief		: RTC interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntRTC(void)
{
    P7DR_P0 =!P7DR_P0;					// reverse P70 output level
    NOP;                                // no operation
    NOP;
    NOP;
}


























