//***************************************************
// file			: MQ6823_KWI.c
// version		: V1.0 2019/04/09
// brief		: KWI related functions
// note			: KWI related functions are gathered in this subroutine
//***************************************************

#include "main.h"

//******************************************************************************
// name			: KWI_Enable
// brief		: initialize and enable KWI
// note			: STOP mode release level is only one option, no both levels in one KWI
//******************************************************************************
void KWI_Enable(void)
{
//====== KWI 0 ======
//--- low level release 
/*
    P4CR_P0         = 0;
    P4PU_P0         = 1;    
    KWUCR0_KW0LE    = 0;
    KWUCR0_KW0EN    = 1;
 */    
//--- high level release
/* 
    P4CR_P0         = 0;
    P4PU_P0         = 0;    
    KWUCR0_KW0LE    = 1; 
    KWUCR0_KW0EN    = 1;
 */
//====== KWI 1 ======
//--- low level release 
/*
    P4CR_P1         = 0;
    P4PU_P1         = 1;    
    KWUCR0_KW1LE    = 0;
    KWUCR0_KW1EN    = 1;
 */    
//--- high level release
/* 
    P4CR_P1         = 0;
    P4PU_P1         = 0;    
    KWUCR0_KW1LE    = 1; 
    KWUCR0_KW1EN    = 1;
 */
   
//====== KWI 2 ======
//--- low level release 

    P4CR_P2         = 0;
    P4PU_P2         = 1;    
    KWUCR0_KW2LE    = 0; // STOP mode release level(0 : low level release)
    KWUCR0_KW2EN    = 1; // 1 : enable KWI   0 : disable KWI
    
//--- high level release
/* 
    P4CR_P2         = 0;
    P4PU_P2         = 0;    
    KWUCR0_KW2LE    = 1; // STOP mode release level(1 : high level release)
    KWUCR0_KW2EN    = 1;
 */
    
//====== KWI 3 ======
//--- low level release 
/* 
    P4CR_P3         = 0;
    P4PU_P3         = 1;    
    KWUCR0_KW3LE    = 0;
    KWUCR0_KW3EN    = 1;
 */ 
//--- high level release
/* 
    P4CR_P3         = 0;
    P4PU_P3         = 0;    
    KWUCR0_KW3LE    = 1;
    KWUCR0_KW3EN    = 1; 
 */
    
//====== KWI 4 ======
//--- low level release 
/* 
    P4CR_P4         = 0;
    P4PU_P4         = 1;    
    KWUCR1_KW4LE    = 0;
    KWUCR1_KW4EN    = 1;
 */ 
//--- high level release
/* 
    P4CR_P4         = 0;
    P4PU_P4         = 0;    
    KWUCR1_KW4LE    = 1;
    KWUCR1_KW4EN    = 1;
 */
    
//====== KWI 8 ======
//--- low level release 
/* 
    P2CR_P4         = 0;
    P2PU_P4         = 1;    
    KWUCR2_KW8LE    = 0;
    KWUCR2_KW8EN    = 1;
 */ 
//--- high level release
/* 
    P2CR_P4         = 0;
    P2PU_P4         = 0;    
    KWUCR2_KW8LE    = 1;
    KWUCR2_KW8EN    = 1;
 */

//====== KWI 12 ======
//--- low level release 
/* 
    P7CR_P3         = 0;
    P7PU_P3         = 1;    
    KWUCR3_KW12LE   = 0;
    KWUCR3_KW12EN   = 1;
 */ 
//--- high level release
/* 
    P7CR_P3         = 0;
    P7PU_P3         = 0;    
    KWUCR3_KW12LE   = 1;
    KWUCR3_KW12EN   = 1;
 */
 
 
//====== KWI 13 ======
//--- low level release 
/* 
    P7CR_P4         = 0;
    P7PU_P4         = 1;    
    KWUCR3_KW13LE   = 0;
    KWUCR3_KW13EN   = 1;
 */ 
//--- high level release
/* 
    P7CR_P4         = 0;
    P7PU_P4         = 0;    
    KWUCR3_KW13LE   = 1;
    KWUCR3_KW13EN   = 1;
 */
 
//====== KWI 14 ======
//--- low level release 
/* 
    P7CR_P5         = 0;
    P7PU_P5         = 1;    
    KWUCR3_KW14LE   = 0;
    KWUCR3_KW14EN   = 1;
 */ 
//--- high level release
/* 
    P7CR_P5         = 0;
    P7PU_P5         = 0;    
    KWUCR3_KW14LE   = 1;
    KWUCR3_KW14EN   = 1;
 */
 
//====== KWI 15 ======
//--- low level release 
/* 
    P7CR_P6         = 0;
    P7PU_P6         = 1;    
    KWUCR3_KW15LE   = 0;
    KWUCR3_KW15EN   = 1;
 */ 
//--- high level release
/* 
    P7CR_P6         = 0;
    P7PU_P6         = 0;    
    KWUCR3_KW15LE   = 1;
    KWUCR3_KW15EN   = 1;
 */
 
}


//*********************************************************************
// name			: KWI_Disable
// brief		: disable KWI
// note			: 
//*********************************************************************
void KWI_Disable(void)
{

//====== KWI 0 ======   
/*  
    P4PU_P0         = 0;        
    KWUCR0_KW0EN    = 0; 
*/
    
//====== KWI 1 ======   
/*  
    P4PU_P1         = 0;        
    KWUCR1_KW1EN    = 0; 
*/

//====== KWI 2 ======   
    P4PU_P2         = 0;        
    KWUCR0_KW2EN    = 0;

//====== KWI 3 ======   
/*  
    P4PU_P3         = 0;        
    KWUCR0_KW3EN    = 0; 
*/
    
//====== KWI 4 ======   
/*  
    P4PU_P4         = 0;        
    KWUCR1_KW4EN    = 0; 
*/
    
//====== KWI 8 ======
/* 
    P2PU_P4         = 0;    
    KWUCR2_KW8EN    = 0;
 */ 

//====== KWI 12 ======
/* 
    P7PU_P3         = 0;    
    KWUCR3_KW12EN   = 0;
 */
 
//====== KWI 13 ======
/* 
    P7PU_P4         = 0;    
    KWUCR3_KW13EN   = 0;
 */
 
//====== KWI 14 ======
/* 
    P7PU_P5         = 0;    
    KWUCR3_KW14EN   = 0;
 */
 
//====== KWI 15 ======
/* 
    P7PU_P6         = 0;    
    KWUCR3_KW15EN   = 0;
 */

}

