//******************************************************************
// file			: main.c
// version		: V1.0 2019/04/09
// brief		: main program
// note			: 
// 			  1.set VD1 detection voltage to 4.2V (+/-0.2V)
//            2.when the VDD falls below the target voltage, MCU reset
//              Afterwards, when the VDD is higher than the target voltage, read VD1F
//              if VD1F is 1, P70 outputs a 1-second low level
//            
//            3.after setting the VD1 , P71 starts to continuously output the inverted level every 1 second      
//
//            P70 can be connected to a LED to observe flashing
//******************************************************************
#ifndef IO_MEM
#define IO_MEM
#endif

#include "main.h"

/* ---------------------- global variables ------------------------------ */



/* ---------------------- main program -------------------------------- */
void main(){
	
	
    /* ---------------------- system initialization ------------------------ */
    SYSTEM_INIT();
	P7DR_P0		= 1;					// P70 is first set to output high level, which is used for the demo afterward (light off LED)
    P7CR_P0		= 1;					// set P70 as a output pin
	
	P7DR_P1		= 1;					// set P71 to output high
    P7CR_P1		= 1;					// set P71 as a output pin
	/* --------------------------------------------------- */ 
	
	// after LVD reset, VD2F would be set to 1 
	if( VDCR1_VD1F == 1){			    
	
		//---------light on LED for 1 second then light off it--------------------------------
	    P7DR_P0	   = 0;				    // P70output low level (light on LED) 
	    delay_times(t_1ms,1000);		    // delay 1.0s
	    P7DR_P0	   = 1;				    // P70output high level (light off LED)
		//--------------------------------------------------------------
	
	    VDCR1_VD1F = 0;				    // clear VD1F
	}


    /* ---------------------- function initialization ------------------- */ 
	
	delay_times(t_1ms,250);		    // 250ms delay ensures system stability
	
	LVD_Init();
    
//------------------------------------------------------------------//
    
   
    
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    while(1){
		P7DR_P1	   = 0;				    // set P71 to output low
	    delay_times(t_1ms,1000);		// delay 1.0s
        CLR_WDT;						// clear the watchdog timer
		P7DR_P1	   = 1;				    // set P71 to output high
	    delay_times(t_1ms,1000);		// delay 1.0s
        CLR_WDT;						// clear the watchdog timer
        NOP;
        NOP;
        NOP;
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}

























/*---------------------- interrupt service routine ------------------------*/
//=============== Dummy function for interrupt ============
void __interrupt Int_dummy(void)
{

}
//=========================================================

void __interrupt OnlyReti(void)
{
    NOP;                                // no operation
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10; 	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}     

/*----------------- end of interrupt service routine ------------------------*/

/*---------------------- MQ6823 interrupt vector --------------------*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
    Int_dummy,          // 0xffc0 : Reserved
    Int_dummy,          // 0xffc2 : Reserved
    OnlyReti,           // 0xffc4 : IntTCC1P
    OnlyReti,           // 0xffc6 : IntTCC1T
    OnlyReti,           // 0xffc8 : IntTCA1
    Int_dummy,          // 0xffca : Reserved
    Int_dummy,          // 0xffcc : Reserved
    Int_dummy,          // 0xffce : Reserved
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    Int_dummy,          // 0xffd4 : Reserved
    Int_dummy,          // 0xffd6 : Reserved
    OnlyReti,          	// 0xffd8 : Int3 / IntEMG1
    OnlyReti,           // 0xffda : Int2 
    OnlyReti,           // 0xffdc : Int1
    OnlyReti,           // 0xffde : Int0
    OnlyReti,           // 0xffe0 : IntSBI
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,           // 0xffec : IntVLTD
    OnlyReti,           // 0xffee : IntTXD0
    OnlyReti,           // 0xfff0 : IntRXD0
    OnlyReti,           // 0xfff2 : IntSIO0
    OnlyReti,           // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI / INTUNDEF
    STARTUP             // 0xfffe : RESET
};
#pragma section const
/*-------------------  MQ6823 interrupt vector -------------------*/


















//*********************************************************************
// name			: SYSTEM_INIT(void)
// brief		: IO, CGCR and P10/P40/P41 initialization during debugging
// note			:
//*********************************************************************
void SYSTEM_INIT(void)
{
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  (default): when emulation, set P10 to Reset pin to avoid affecting the emulation and program functions
//  SET_P10_to_RESET_PIN;
//------------------------------------------------------------------
    FSCTRL_FSSEL = 0;                   // if the program has changed this bit, you need to manually initialize and clear it to the default value of 0 in the emulation mode 
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode), set P10 to GPIO pin
//------------------------------------------------------------------
//-- set P10 to GPIO pin ------
    SET_P10_to_IO_PIN;
//------------------------------------------------------------------
#endif



//-- pin configuration initialization (debug pin configuration)------
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  the simulation uses P10, P40 and P41 into Debug mode, which is set as an input during simulation
//  to avoid affecting the emulation and program functions
    P1DR = 0x00;
    P1CR = set8bit(11111110);           // set P10 as input pin
    P4DR = 0x00;
    P4CR = set8bit(11111100);           // set P40 and P41 as input pins
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;
//------------------------------------------------------------------
#endif

//-- pin configuration initialization ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//  P4DR = 0x00;
//  P4CR = 0xff;
    P5DR = 0x00;
    P5CR = 0xff;
    P7DR = 0x00;
    P7CR = 0xff;
    P8DR = 0x00;
    P8CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;
    
    CLR_WDT;                            // clear the watchdog timer
}

//*********************************************************************
// name			: delay_times
// brief		: time delay function
// note			: ==> t_1ms   = 0;          // time delay unit ms
//          : ==> t_100us = 1;          // time delay unit us (this accuracy is not good)
//          : the example of using a fixed loop with a time delay is as follows:
//          : delay_times(t_1ms, 800);  // delay 800ms
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
    uint  i, cgcrT;

//  uchar cgcrF[4]={ 2, 4,  8, 1 };     // use this array when the high-speed crystal frequency is 8MHz
    uchar cgcrF[4]={ 4, 8, 16, 2 };     // use this array when the high-speed crystal frequency is 16MHz

//  the time delay function of the system at NORMAL1 mode and NORMAL2 mode
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  the time delay function of the system at SLOW1 mode and SLOW2 mode), which has a large error, is used for reference
    else for(; x>0; x--){}

    CLR_WDT;                            // clear the watchdog timer
}
