//******************************************************
// file			: MQ6823_SFR.h
// version		: V1.0 2019/03/29
// brief		:
// note			: declare the detailed names represented by each bit of the special function registers
//******************************************************

#ifndef	_MQ6823_SFR_NAME_H_
#define _MQ6823_SFR_NAME_H_

#include "MQ6823_SFR_addr.h"



//****************************************************
//******
#define NOP                     __asm("NOP")                        // no operation
//******
#define DI                      __asm("DI")                         // disable all maskable interrupts // EIRL_IMF=0
#define EI                      __asm("EI")                         // enable all maskable interrupts // EIRL_IMF=1
//******
#define CLR_WDT                 WDCDR_WDTCR2=0x4e                   // clear the watchdog timer
//******
#define DIS_WDT                 WDCTR_WDTEN=0; WDCDR_WDTCR2=0xb1    // disable the watchdog timer operation and clear the 8-bit up counter
//******
#define SET_P10_to_RESET_PIN    SYSCR3_RSTDIS=0; SYSCR4=0xb2        // set P10 to reset pin (default)
#define SET_P10_to_IO_PIN       SYSCR3_RSTDIS=1; SYSCR4=0xb2        // set P10 to GPIO pin
//******
//****************************************************



//====================================================
//			SFR1
//====================================================
//------------------------------------
#define P0DR                    _0x0000.byte
#define P0DR_P7                 _0x0000.bit.b7
#define P0DR_P6                 _0x0000.bit.b6
#define P0DR_P5                 _0x0000.bit.b5
#define P0DR_P4                 _0x0000.bit.b4
#define P0DR_P3                 _0x0000.bit.b3
#define P0DR_P2                 _0x0000.bit.b2
#define P0DR_P1                 _0x0000.bit.b1
#define P0DR_P0                 _0x0000.bit.b0

//------------------------------------
#define P1DR                    _0x0001.byte
#define P1DR_P7                 _0x0001.bit.b7
#define P1DR_P6                 _0x0001.bit.b6
#define P1DR_P5                 _0x0001.bit.b5
#define P1DR_P4                 _0x0001.bit.b4
#define P1DR_P3                 _0x0001.bit.b3
#define P1DR_P2                 _0x0001.bit.b2
#define P1DR_P1                 _0x0001.bit.b1
#define P1DR_P0                 _0x0001.bit.b0

//------------------------------------
#define P2DR                    _0x0002.byte
#define P2DR_P7                 _0x0002.bit.b7
#define P2DR_P6                 _0x0002.bit.b6
#define P2DR_P5                 _0x0002.bit.b5
#define P2DR_P4                 _0x0002.bit.b4
#define P2DR_P3                 _0x0002.bit.b3
#define P2DR_P2                 _0x0002.bit.b2
#define P2DR_P1                 _0x0002.bit.b1
#define P2DR_P0                 _0x0002.bit.b0

//------------------------------------
#define P4DR                    _0x0004.byte
#define P4DR_P7                 _0x0004.bit.b7
#define P4DR_P6                 _0x0004.bit.b6
#define P4DR_P5                 _0x0004.bit.b5
#define P4DR_P4                 _0x0004.bit.b4
#define P4DR_P3                 _0x0004.bit.b3
#define P4DR_P2                 _0x0004.bit.b2
#define P4DR_P1                 _0x0004.bit.b1
#define P4DR_P0                 _0x0004.bit.b0

//------------------------------------
#define P5DR                    _0x0005.byte
#define P5DR_P7                 _0x0005.bit.b7
#define P5DR_P6                 _0x0005.bit.b6
#define P5DR_P5                 _0x0005.bit.b5
#define P5DR_P4                 _0x0005.bit.b4
#define P5DR_P3                 _0x0005.bit.b3
#define P5DR_P2                 _0x0005.bit.b2
#define P5DR_P1                 _0x0005.bit.b1
#define P5DR_P0                 _0x0005.bit.b0

//------------------------------------
#define P7DR                    _0x0007.byte
#define P7DR_P7                 _0x0007.bit.b7
#define P7DR_P6                 _0x0007.bit.b6
#define P7DR_P5                 _0x0007.bit.b5
#define P7DR_P4                 _0x0007.bit.b4
#define P7DR_P3                 _0x0007.bit.b3
#define P7DR_P2                 _0x0007.bit.b2
#define P7DR_P1                 _0x0007.bit.b1
#define P7DR_P0                 _0x0007.bit.b0

//------------------------------------
#define P8DR                    _0x0008.byte
#define P8DR_P7                 _0x0008.bit.b7
#define P8DR_P6                 _0x0008.bit.b6
#define P8DR_P5                 _0x0008.bit.b5
#define P8DR_P4                 _0x0008.bit.b4
#define P8DR_P3                 _0x0008.bit.b3
#define P8DR_P2                 _0x0008.bit.b2
#define P8DR_P1                 _0x0008.bit.b1
#define P8DR_P0                 _0x0008.bit.b0

//------------------------------------
#define P9DR                    _0x0009.byte
#define P9DR_P7                 _0x0009.bit.b7
#define P9DR_P6                 _0x0009.bit.b6
#define P9DR_P5                 _0x0009.bit.b5
#define P9DR_P4                 _0x0009.bit.b4
#define P9DR_P3                 _0x0009.bit.b3
#define P9DR_P2                 _0x0009.bit.b2
#define P9DR_P1                 _0x0009.bit.b1
#define P9DR_P0                 _0x0009.bit.b0

//------------------------------------
/*
MQ6823PBDR

*/

//------------------------------------
#define P0PRD                   _0x000D.byte
#define P0PRD_P7                _0x000D.bit.b7
#define P0PRD_P6                _0x000D.bit.b6
#define P0PRD_P5                _0x000D.bit.b5
#define P0PRD_P4                _0x000D.bit.b4
#define P0PRD_P3                _0x000D.bit.b3
#define P0PRD_P2                _0x000D.bit.b2
#define P0PRD_P1                _0x000D.bit.b1
#define P0PRD_P0                _0x000D.bit.b0

//------------------------------------
#define P1PRD                   _0x000E.byte
#define P1PRD_P7                _0x000E.bit.b7
#define P1PRD_P6                _0x000E.bit.b6
#define P1PRD_P5                _0x000E.bit.b5
#define P1PRD_P4                _0x000E.bit.b4
#define P1PRD_P3                _0x000E.bit.b3
#define P1PRD_P2                _0x000E.bit.b2
#define P1PRD_P1                _0x000E.bit.b1
#define P1PRD_P0                _0x000E.bit.b0

//------------------------------------
#define P2PRD                   _0x000F.byte
#define P2PRD_P7                _0x000F.bit.b7
#define P2PRD_P6                _0x000F.bit.b6
#define P2PRD_P5                _0x000F.bit.b5
#define P2PRD_P4                _0x000F.bit.b4
#define P2PRD_P3                _0x000F.bit.b3
#define P2PRD_P2                _0x000F.bit.b2
#define P2PRD_P1                _0x000F.bit.b1
#define P2PRD_P0                _0x000F.bit.b0

//------------------------------------
#define P4PRD                   _0x0011.byte
#define P4PRD_P7                _0x0011.bit.b7
#define P4PRD_P6                _0x0011.bit.b6
#define P4PRD_P5                _0x0011.bit.b5
#define P4PRD_P4                _0x0011.bit.b4
#define P4PRD_P3                _0x0011.bit.b3
#define P4PRD_P2                _0x0011.bit.b2
#define P4PRD_P1                _0x0011.bit.b1
#define P4PRD_P0                _0x0011.bit.b0

//------------------------------------
#define P5PRD                   _0x0012.byte
#define P5PRD_P7                _0x0012.bit.b7
#define P5PRD_P6                _0x0012.bit.b6
#define P5PRD_P5                _0x0012.bit.b5
#define P5PRD_P4                _0x0012.bit.b4
#define P5PRD_P3                _0x0012.bit.b3
#define P5PRD_P2                _0x0012.bit.b2
#define P5PRD_P1                _0x0012.bit.b1
#define P5PRD_P0                _0x0012.bit.b0

//------------------------------------
#define P7PRD                   _0x0014.byte
#define P7PRD_P7                _0x0014.bit.b7
#define P7PRD_P6                _0x0014.bit.b6
#define P7PRD_P5                _0x0014.bit.b5
#define P7PRD_P4                _0x0014.bit.b4
#define P7PRD_P3                _0x0014.bit.b3
#define P7PRD_P2                _0x0014.bit.b2
#define P7PRD_P1                _0x0014.bit.b1
#define P7PRD_P0                _0x0014.bit.b0

//------------------------------------
#define P8PRD                   _0x0015.byte
#define P8PRD_P7                _0x0015.bit.b7
#define P8PRD_P6                _0x0015.bit.b6
#define P8PRD_P5                _0x0015.bit.b5
#define P8PRD_P4                _0x0015.bit.b4
#define P8PRD_P3                _0x0015.bit.b3
#define P8PRD_P2                _0x0015.bit.b2
#define P8PRD_P1                _0x0015.bit.b1
#define P8PRD_P0                _0x0015.bit.b0

//------------------------------------
#define P9PRD                   _0x0016.byte
#define P9PRD_P7                _0x0016.bit.b7
#define P9PRD_P6                _0x0016.bit.b6
#define P9PRD_P5                _0x0016.bit.b5
#define P9PRD_P4                _0x0016.bit.b4
#define P9PRD_P3                _0x0016.bit.b3
#define P9PRD_P2                _0x0016.bit.b2
#define P9PRD_P1                _0x0016.bit.b1
#define P9PRD_P0                _0x0016.bit.b0

//------------------------------------
/*

*/
//------------------------------------

// MQ6823 UART0/UART1
//------------------------------------
#define UART0CR1                _0x001A.byte
#define UART0CR1_TXE            _0x001A.bit.b7
#define UART0CR1_RXE            _0x001A.bit.b6
#define UART0CR1_STOPBT         _0x001A.bit.b5
#define UART0CR1_EVEN           _0x001A.bit.b4
#define UART0CR1_PE             _0x001A.bit.b3
#define UART0CR1_IRDASEL        _0x001A.bit.b2
#define UART0CR1_BRG            _0x001A.bit.b1

//------------------------------------
#define UART0CR2                _0x001B.byte
#define UART0CR2_RTSEL          _0x001B.b5_3.b5_3
#define UART0CR2_RXDNC          _0x001B.b2_1.b2_1
#define UART0CR2_STOPBR         _0x001B.bit.b0

//------------------------------------
#define UART0DR                 _0x001C.byte

//------------------------------------
#define UART0SR                 _0x001D.byte
#define UART0SR_PERR            _0x001D.bit.b7
#define UART0SR_FERR            _0x001D.bit.b6
#define UART0SR_OERR            _0x001D.bit.b5
#define UART0SR_RBSY            _0x001D.bit.b3
#define UART0SR_RBFL            _0x001D.bit.b2
#define UART0SR_TBSY            _0x001D.bit.b1
#define UART0SR_TBFL            _0x001D.bit.b0

//------------------------------------
// TD0BUF and RD0BUF have the same address
#define TD0BUF                  _0x001E.byte
#define RD0BUF                  _0x001E.byte

//------------------------------------
#define SIO0CR                  _0x001F.byte
#define SIO0CR_SIOEDG           _0x001F.bit.b7
#define SIO0CR_SIOCKS           _0x001F.b6_4.b6_4
#define SIO0CR_SIODIR           _0x001F.bit.b3
#define SIO0CR_SIOS             _0x001F.bit.b2
#define SIO0CR_SIOM             _0x001F.b1_0.b1_0

//------------------------------------
#define SIO0SR                  _0x0020.byte
#define SIO0SR_SIOF             _0x0020.bit.b7
#define SIO0SR_SEF              _0x0020.bit.b6
#define SIO0SR_OERR             _0x0020.bit.b5
#define SIO0SR_RENDB            _0x0020.bit.b4
#define SIO0SR_UERR             _0x0020.bit.b3
#define SIO0SR_TBFL             _0x0020.bit.b2

//------------------------------------
#define SIO0BUF                 _0x0021.byte

//------------------------------------
#define SBI0CR1                 _0x0022.byte
#define SBI0CR1_BC              _0x0022.b7_5.b7_5
#define SBI0CR1_ACK             _0x0022.bit.b4
#define SBI0CR1_NOACK           _0x0022.bit.b3
#define SBI0CR1_SCK             _0x0022.b2_0.b2_0

//------------------------------------
// SBI0CR2 and SBI0SR2 have the same address
#define SBI0CR2                 _0x0023.byte
#define SBI0CR2_MST             _0x0023.bit.b7
#define SBI0CR2_TRX             _0x0023.bit.b6
#define SBI0CR2_BB              _0x0023.bit.b5
#define SBI0CR2_PIN             _0x0023.bit.b4
#define SBI0CR2_SBIM            _0x0023.bit.b3
#define SBI0CR2_SWRST           _0x0023.b1_0.b1_0
// SBI0CR2 and SBI0SR2 have the same address
#define SBI0SR2                 _0x0023.byte
#define SBI0SR2_MST             _0x0023.bit.b7
#define SBI0SR2_TRX             _0x0023.bit.b6
#define SBI0SR2_BB              _0x0023.bit.b5
#define SBI0SR2_PIN             _0x0023.bit.b4
#define SBI0SR2_AL              _0x0023.bit.b3
#define SBI0SR2_AAS             _0x0023.bit.b2
#define SBI0SR2_AD0             _0x0023.bit.b1
#define SBI0SR2_LRB             _0x0023.bit.b0

//------------------------------------
#define I2C0AR                  _0x0024.byte
#define I2C0AR_SA               _0x0024.b7_1.b7_1
#define I2C0AR_ALS              _0x0024.bit.b0

//------------------------------------
#define SBI0DBR                 _0x0025.byte

//------------------------------------
#define T00REG                  _0x0026.byte

//------------------------------------
#define T01REG                  _0x0027.byte

//------------------------------------
#define T00PWM                  _0x0028.byte
#define T00PWM_PWMDUTY          _0x0028.b7_1.b7_1
#define T00PWM_PWMAD            _0x0028.bit.b0
#define T00PWM_PWMDUTYL         _0x0028.b7_4.b7_4
#define T00PWM_PWMAD3           _0x0028.bit.b3
#define T00PWM_PWMAD2           _0x0028.bit.b2
#define T00PWM_PWMAD1           _0x0028.bit.b1
#define T00PWM_PWMAD0           _0x0028.bit.b0

//------------------------------------
#define T01PWM                  _0x0029.byte
#define T01PWM_PWMDUTY          _0x0029.b7_1.b7_1
#define T01PWM_PWMAD            _0x0029.bit.b0
#define T01PWM_PWMDUTYH         _0x0029.b3_0.b3_0

//------------------------------------
#define T00MOD                  _0x002A.byte
#define T00MOD_TFF              _0x002A.bit.b7
#define T00MOD_DBE              _0x002A.bit.b6
#define T00MOD_TCK              _0x002A.b5_3.b5_3
#define T00MOD_EIN              _0x002A.bit.b2
#define T00MOD_TCM              _0x002A.b1_0.b1_0

//------------------------------------
#define T01MOD                  _0x002B.byte
#define T01MOD_TFF              _0x002B.bit.b7
#define T01MOD_DBE              _0x002B.bit.b6
#define T01MOD_TCK              _0x002B.b5_3.b5_3
#define T01MOD_EIN              _0x002B.bit.b2
#define T01MOD_TCM              _0x002B.b1_0.b1_0

//------------------------------------
#define T001CR                  _0x002C.byte
#define T001CR_OUTAND           _0x002C.bit.b3
#define T001CR_TCAS             _0x002C.bit.b2
#define T001CR_T01RUN           _0x002C.bit.b1
#define T001CR_T00RUN           _0x002C.bit.b0

//------------------------------------
#define TA0DRA                  _0x002D.word
#define TA0DRAL                 _0x002D.byte[0]
#define TA0DRAH                 _0x002D.byte[1]

//------------------------------------
#define TA0DRB                  _0x002F.word
#define TA0DRBL                 _0x002F.byte[0]
#define TA0DRBH                 _0x002F.byte[1]

//------------------------------------
#define TA0MOD                  _0x0031.byte
#define TA0MOD_TADBE            _0x0031.bit.b7
#define TA0MOD_TATED            _0x0031.bit.b6
#define TA0MOD_TAMCAP           _0x0031.bit.b5
#define TA0MOD_TAMETT           _0x0031.bit.b5
#define TA0MOD_TACK             _0x0031.b4_3.b4_3
#define TA0MOD_TAM              _0x0031.b2_0.b2_0

//------------------------------------
#define TA0CR                   _0x0032.byte
#define TA0CR_TAOVE             _0x0032.bit.b7
#define TA0CR_TATFF             _0x0032.bit.b6
#define TA0CR_TANC              _0x0032.b5_4.b5_4
#define TA0CR_TAACAP            _0x0032.bit.b1
#define TA0CR_TAMPPG            _0x0032.bit.b1
#define TA0CR_TAS               _0x0032.bit.b0

//------------------------------------
#define TA0SR                   _0x0033.byte
#define TA0SR_TAOVF             _0x0033.bit.b7
#define TA0SR_TACPFA            _0x0033.bit.b1
#define TA0SR_TACPFB            _0x0033.bit.b0

//------------------------------------
#define ADCCR1                  _0x0034.byte
#define ADCCR1_ADRS             _0x0034.bit.b7
#define ADCCR1_AMD              _0x0034.b6_5.b6_5
#define ADCCR1_AINEN            _0x0034.bit.b4
#define ADCCR1_SAIN             _0x0034.b3_0.b3_0

//------------------------------------
#define ADCCR2                  _0x0035.byte
#define ADCCR2_EOCF             _0x0035.bit.b7
#define ADCCR2_ADBF             _0x0035.bit.b6
#define ADCCR2_ACK              _0x0035.b2_0.b2_0

//------------------------------------
#define ADCDR                   _0x0036.word
#define ADCDRL                  _0x0036.byte[0]
#define ADCDRH                  _0x0036.byte[1]

//------------------------------------
#define DVOCR                   _0x0038.byte
#define DVOCR_DVOEN             _0x0038.bit.b2
#define DVOCR_DVOCK             _0x0038.b1_0.b1_0

//------------------------------------
#define TBTCR                   _0x0039.byte
#define TBTCR_TBTEN             _0x0039.bit.b3
#define TBTCR_TBTCK             _0x0039.b2_0.b2_0

//------------------------------------
#define EIRL                    _0x003A.byte
//******
#define EIRL_EF7                _0x003A.bit.b7
#define EI_INTRXD0              _0x003A.bit.b7
//******
#define EIRL_EF6                _0x003A.bit.b6
#define EI_INTSIO0              _0x003A.bit.b6
//******
#define EIRL_EF5                _0x003A.bit.b5
#define EI_INTTBT               _0x003A.bit.b5
//******
#define EIRL_EF4                _0x003A.bit.b4
#define EI_INTWUC               _0x003A.bit.b4
//******
#define EIRL_IMF                _0x003A.bit.b0
#define EI_IMF                  _0x003A.bit.b0

//------------------------------------
#define EIRH                    _0x003B.byte
//******
#define EIRH_EF15               _0x003B.bit.b7
#define EI_INTSBI               _0x003B.bit.b7
//******
#define EIRH_EF14               _0x003B.bit.b6
#define EI_INTTCA0              _0x003B.bit.b6
//******
#define EIRH_EF13               _0x003B.bit.b5
#define EI_INTTC01              _0x003B.bit.b5
//******
#define EIRH_EF12               _0x003B.bit.b4
#define EI_INTTC00              _0x003B.bit.b4
//******
#define EIRH_EF11               _0x003B.bit.b3
#define EI_INTRTC               _0x003B.bit.b3
//******
#define EIRH_EF10               _0x003B.bit.b2
#define EI_INTADC               _0x003B.bit.b2
//******
#define EIRH_EF9                _0x003B.bit.b1
#define EI_INTLVD               _0x003B.bit.b1
//******
#define EIRH_EF8                _0x003B.bit.b0
#define EI_INTTXD0              _0x003B.bit.b0

//------------------------------------
#define EIRE                    _0x003C.byte
//******
#define EIRE_EF23               _0x003C.bit.b7
#define EI_INTTXD1              _0x003C.bit.b7
//******
#define EIRE_EF22               _0x003C.bit.b6
#define EI_INTRXD1              _0x003C.bit.b6
//******
#define EIRE_EF21               _0x003C.bit.b5

//******
#define EIRE_EF20               _0x003C.bit.b4
//******
#define EIRE_EF19               _0x003C.bit.b3
#define EI_INT3                 _0x003C.bit.b3
#define EI_INTEMG1              _0x003C.bit.b3		//20190123 add
//******
#define EIRE_EF18               _0x003C.bit.b2
#define EI_INT2                 _0x003C.bit.b2
//******
#define EIRE_EF17               _0x003C.bit.b1
#define EI_INT1                 _0x003C.bit.b1
//******
#define EIRE_EF16               _0x003C.bit.b0
#define EI_INT0                 _0x003C.bit.b0

//------------------------------------
#define EIRD                    _0x003D.byte
//******
#define EIRD_EF31               _0x003D.bit.b7
//******
#define EIRD_EF30               _0x003D.bit.b6
//******
#define EIRD_EF29               _0x003D.bit.b5
#define EI_INTTCC1P             _0x003D.bit.b5		//2019-03/22
//******
#define EIRD_EF28               _0x003D.bit.b4
#define EI_INTTCC1T             _0x003D.bit.b4		//2019-03/22
//******
#define EIRD_EF27               _0x003D.bit.b3
#define EI_INTTCA1              _0x003D.bit.b3
//******
#define EIRD_EF26               _0x003D.bit.b2
//******
#define EIRD_EF25               _0x003D.bit.b1
//******
#define EIRD_EF24               _0x003D.bit.b0

//------------------------------------
#define PSW                     _0x003F.byte
#define PSW_JF                  _0x003F.bit.b7
#define PSW_ZF                  _0x003F.bit.b6
#define PSW_CF                  _0x003F.bit.b5
#define PSW_HF                  _0x003F.bit.b4
#define PSW_SF                  _0x003F.bit.b3
#define PSW_VF                  _0x003F.bit.b2
//====================================================
//			SFR1
//====================================================



//====================================================
//			SFR3
//====================================================

//------------------------------------
#define UATCNG                  _0x0E97.byte
#define UATCNG_UAT2IO           _0x0E97.bit.b2
#define UATCNG_UAT1IO           _0x0E97.bit.b1
#define UATCNG_UAT0IO           _0x0E97.bit.b0

//------------------------------------
#define EINTCR0                 _0x0E98.byte
#define EINTCR0_NCE             _0x0E98.bit.b6
#define EINTCR0_INTSEL          _0x0E98.bit.b5
#define EINTCR0_INTLVL          _0x0E98.bit.b4
#define EINTCR0_INTES           _0x0E98.b3_2.b3_2
#define EINTCR0_INTNC           _0x0E98.b1_0.b1_0

//------------------------------------
#define EINTCR5                 _0x0E99.byte
#define EINTCR5_INTLVL          _0x0E99.bit.b4
#define EINTCR5_INTES           _0x0E99.b3_2.b3_2
#define EINTCR5_INTNC           _0x0E99.b1_0.b1_0

//------------------------------------
#define ADCVRF                  _0x0EE7.byte
#define ADCVRF_VRFSEL           _0x0EE7.b2_0.b2_0

//------------------------------------
#define FSCTRL                  _0x0EED.byte
#define FSCTRL_FOSCCKS          _0x0EED.bit.b2_1
#define FSCTRL_FSSEL            _0x0EED.bit.b0

//------------------------------------
// MULCTR was later renamed to VREF_CALIB, so both names were defined in order to be shared by the program
#define MULCTR                  _0x0EF6.byte    // MULCTR     is the old name at the time of development
#define MULCTR_VRFCAL           _0x0EF6.bit.b1
#define VREF_CALIB              _0x0EF6.byte    // VREF_CALIB is revised name for the specification
#define VREF_CALIB_VRFCAL       _0x0EF6.bit.b1
//====================================================
//			SFR3
//====================================================



//====================================================
//			SFR2
//====================================================
//------------------------------------
#define P0PD                    _0x0F00.byte
#define P0PD_P7                 _0x0F00.bit.b7
#define P0PD_P6                 _0x0F00.bit.b6
#define P0PD_P5                 _0x0F00.bit.b5
#define P0PD_P4                 _0x0F00.bit.b4
#define P0PD_P3                 _0x0F00.bit.b3
#define P0PD_P2                 _0x0F00.bit.b2
#define P0PD_P1                 _0x0F00.bit.b1
#define P0PD_P0                 _0x0F00.bit.b0

//------------------------------------
#define P2PD                    _0x0F02.byte
#define P2PD_P7                 _0x0F02.bit.b7
#define P2PD_P6                 _0x0F02.bit.b6
#define P2PD_P5                 _0x0F02.bit.b5
#define P2PD_P4                 _0x0F02.bit.b4
#define P2PD_P3                 _0x0F02.bit.b3
#define P2PD_P2                 _0x0F02.bit.b2
#define P2PD_P1                 _0x0F02.bit.b1
#define P2PD_P0                 _0x0F02.bit.b0

//------------------------------------
#define P4PD                    _0x0F04.byte
#define P4PD_P7                 _0x0F04.bit.b7
#define P4PD_P6                 _0x0F04.bit.b6
#define P4PD_P5                 _0x0F04.bit.b5
#define P4PD_P4                 _0x0F04.bit.b4
#define P4PD_P3                 _0x0F04.bit.b3
#define P4PD_P2                 _0x0F04.bit.b2
#define P4PD_P1                 _0x0F04.bit.b1
#define P4PD_P0                 _0x0F04.bit.b0

//------------------------------------
#define P5PD                    _0x0F05.byte
#define P5PD_P7                 _0x0F05.bit.b7
#define P5PD_P6                 _0x0F05.bit.b6
#define P5PD_P5                 _0x0F05.bit.b5
#define P5PD_P4                 _0x0F05.bit.b4
#define P5PD_P3                 _0x0F05.bit.b3
#define P5PD_P2                 _0x0F05.bit.b2
#define P5PD_P1                 _0x0F05.bit.b1
#define P5PD_P0                 _0x0F05.bit.b0

//------------------------------------
#define P7PD                    _0x0F07.byte
#define P7PD_P7                 _0x0F07.bit.b7
#define P7PD_P6                 _0x0F07.bit.b6
#define P7PD_P5                 _0x0F07.bit.b5
#define P7PD_P4                 _0x0F07.bit.b4
#define P7PD_P3                 _0x0F07.bit.b3
#define P7PD_P2                 _0x0F07.bit.b2
#define P7PD_P1                 _0x0F07.bit.b1
#define P7PD_P0                 _0x0F07.bit.b0

//------------------------------------
#define P8PD                    _0x0F08.byte
#define P8PD_P7                 _0x0F08.bit.b7
#define P8PD_P6                 _0x0F08.bit.b6
#define P8PD_P5                 _0x0F08.bit.b5
#define P8PD_P4                 _0x0F08.bit.b4
#define P8PD_P3                 _0x0F08.bit.b3
#define P8PD_P2                 _0x0F08.bit.b2
#define P8PD_P1                 _0x0F08.bit.b1
#define P8PD_P0                 _0x0F08.bit.b0

//------------------------------------
#define P9PD                    _0x0F09.byte
#define P9PD_P7                 _0x0F09.bit.b7
#define P9PD_P6                 _0x0F09.bit.b6
#define P9PD_P5                 _0x0F09.bit.b5
#define P9PD_P4                 _0x0F09.bit.b4
#define P9PD_P3                 _0x0F09.bit.b3
#define P9PD_P2                 _0x0F09.bit.b2
#define P9PD_P1                 _0x0F09.bit.b1
#define P9PD_P0                 _0x0F09.bit.b0

//------------------------------------
#define P0CR                    _0x0F1A.byte
#define P0CR_P7                 _0x0F1A.bit.b7
#define P0CR_P6                 _0x0F1A.bit.b6
#define P0CR_P5                 _0x0F1A.bit.b5
#define P0CR_P4                 _0x0F1A.bit.b4
#define P0CR_P3                 _0x0F1A.bit.b3
#define P0CR_P2                 _0x0F1A.bit.b2
#define P0CR_P1                 _0x0F1A.bit.b1
#define P0CR_P0                 _0x0F1A.bit.b0

//------------------------------------
#define P1CR                    _0x0F1B.byte
#define P1CR_P7                 _0x0F1B.bit.b7
#define P1CR_P6                 _0x0F1B.bit.b6
#define P1CR_P5                 _0x0F1B.bit.b5
#define P1CR_P4                 _0x0F1B.bit.b4
#define P1CR_P3                 _0x0F1B.bit.b3
#define P1CR_P2                 _0x0F1B.bit.b2
#define P1CR_P1                 _0x0F1B.bit.b1
#define P1CR_P0                 _0x0F1B.bit.b0

//------------------------------------
#define P2CR                    _0x0F1C.byte
#define P2CR_P7                 _0x0F1C.bit.b7
#define P2CR_P6                 _0x0F1C.bit.b6
#define P2CR_P5                 _0x0F1C.bit.b5
#define P2CR_P4                 _0x0F1C.bit.b4
#define P2CR_P3                 _0x0F1C.bit.b3
#define P2CR_P2                 _0x0F1C.bit.b2
#define P2CR_P1                 _0x0F1C.bit.b1
#define P2CR_P0                 _0x0F1C.bit.b0

//------------------------------------
#define P4CR                    _0x0F1E.byte
#define P4CR_P7                 _0x0F1E.bit.b7
#define P4CR_P6                 _0x0F1E.bit.b6
#define P4CR_P5                 _0x0F1E.bit.b5
#define P4CR_P4                 _0x0F1E.bit.b4
#define P4CR_P3                 _0x0F1E.bit.b3
#define P4CR_P2                 _0x0F1E.bit.b2
#define P4CR_P1                 _0x0F1E.bit.b1
#define P4CR_P0                 _0x0F1E.bit.b0

//------------------------------------
#define P5CR                    _0x0F1F.byte
#define P5CR_P7                 _0x0F1F.bit.b7
#define P5CR_P6                 _0x0F1F.bit.b6
#define P5CR_P5                 _0x0F1F.bit.b5
#define P5CR_P4                 _0x0F1F.bit.b4
#define P5CR_P3                 _0x0F1F.bit.b3
#define P5CR_P2                 _0x0F1F.bit.b2
#define P5CR_P1                 _0x0F1F.bit.b1
#define P5CR_P0                 _0x0F1F.bit.b0

//------------------------------------
#define P7CR                    _0x0F21.byte
#define P7CR_P7                 _0x0F21.bit.b7
#define P7CR_P6                 _0x0F21.bit.b6
#define P7CR_P5                 _0x0F21.bit.b5
#define P7CR_P4                 _0x0F21.bit.b4
#define P7CR_P3                 _0x0F21.bit.b3
#define P7CR_P2                 _0x0F21.bit.b2
#define P7CR_P1                 _0x0F21.bit.b1
#define P7CR_P0                 _0x0F21.bit.b0

//------------------------------------
#define P8CR                    _0x0F22.byte
#define P8CR_P7                 _0x0F22.bit.b7
#define P8CR_P6                 _0x0F22.bit.b6
#define P8CR_P5                 _0x0F22.bit.b5
#define P8CR_P4                 _0x0F22.bit.b4
#define P8CR_P3                 _0x0F22.bit.b3
#define P8CR_P2                 _0x0F22.bit.b2
#define P8CR_P1                 _0x0F22.bit.b1
#define P8CR_P0                 _0x0F22.bit.b0

//------------------------------------
#define P9CR                    _0x0F23.byte
#define P9CR_P7                 _0x0F23.bit.b7
#define P9CR_P6                 _0x0F23.bit.b6
#define P9CR_P5                 _0x0F23.bit.b5
#define P9CR_P4                 _0x0F23.bit.b4
#define P9CR_P3                 _0x0F23.bit.b3
#define P9CR_P2                 _0x0F23.bit.b2
#define P9CR_P1                 _0x0F23.bit.b1
#define P9CR_P0                 _0x0F23.bit.b0

//------------------------------------
#define P0PU                    _0x0F27.byte
#define P0PU_P7                 _0x0F27.bit.b7
#define P0PU_P6                 _0x0F27.bit.b6
#define P0PU_P5                 _0x0F27.bit.b5
#define P0PU_P4                 _0x0F27.bit.b4
#define P0PU_P3                 _0x0F27.bit.b3
#define P0PU_P2                 _0x0F27.bit.b2
#define P0PU_P1                 _0x0F27.bit.b1
#define P0PU_P0                 _0x0F27.bit.b0

//------------------------------------
#define P1PU                    _0x0F28.byte
#define P1PU_P7                 _0x0F28.bit.b7
#define P1PU_P6                 _0x0F28.bit.b6
#define P1PU_P5                 _0x0F28.bit.b5
#define P1PU_P4                 _0x0F28.bit.b4
#define P1PU_P3                 _0x0F28.bit.b3
#define P1PU_P2                 _0x0F28.bit.b2
#define P1PU_P1                 _0x0F28.bit.b1
#define P1PU_P0                 _0x0F28.bit.b0

//------------------------------------
#define P2PU                    _0x0F29.byte
#define P2PU_P7                 _0x0F29.bit.b7
#define P2PU_P6                 _0x0F29.bit.b6
#define P2PU_P5                 _0x0F29.bit.b5
#define P2PU_P4                 _0x0F29.bit.b4
#define P2PU_P3                 _0x0F29.bit.b3
#define P2PU_P2                 _0x0F29.bit.b2
#define P2PU_P1                 _0x0F29.bit.b1
#define P2PU_P0                 _0x0F29.bit.b0

//------------------------------------
#define P4PU                    _0x0F2B.byte
#define P4PU_P7                 _0x0F2B.bit.b7
#define P4PU_P6                 _0x0F2B.bit.b6
#define P4PU_P5                 _0x0F2B.bit.b5
#define P4PU_P4                 _0x0F2B.bit.b4
#define P4PU_P3                 _0x0F2B.bit.b3
#define P4PU_P2                 _0x0F2B.bit.b2
#define P4PU_P1                 _0x0F2B.bit.b1
#define P4PU_P0                 _0x0F2B.bit.b0

//------------------------------------
#define P5PU                    _0x0F2C.byte
#define P5PU_P7                 _0x0F2C.bit.b7
#define P5PU_P6                 _0x0F2C.bit.b6
#define P5PU_P5                 _0x0F2C.bit.b5
#define P5PU_P4                 _0x0F2C.bit.b4
#define P5PU_P3                 _0x0F2C.bit.b3
#define P5PU_P2                 _0x0F2C.bit.b2
#define P5PU_P1                 _0x0F2C.bit.b1
#define P5PU_P0                 _0x0F2C.bit.b0

//------------------------------------
#define P7PU                    _0x0F2E.byte
#define P7PU_P7                 _0x0F2E.bit.b7
#define P7PU_P6                 _0x0F2E.bit.b6
#define P7PU_P5                 _0x0F2E.bit.b5
#define P7PU_P4                 _0x0F2E.bit.b4
#define P7PU_P3                 _0x0F2E.bit.b3
#define P7PU_P2                 _0x0F2E.bit.b2
#define P7PU_P1                 _0x0F2E.bit.b1
#define P7PU_P0                 _0x0F2E.bit.b0

//------------------------------------
#define P8PU                    _0x0F2F.byte
#define P8PU_P7                 _0x0F2F.bit.b7
#define P8PU_P6                 _0x0F2F.bit.b6
#define P8PU_P5                 _0x0F2F.bit.b5
#define P8PU_P4                 _0x0F2F.bit.b4
#define P8PU_P3                 _0x0F2F.bit.b3
#define P8PU_P2                 _0x0F2F.bit.b2
#define P8PU_P1                 _0x0F2F.bit.b1
#define P8PU_P0                 _0x0F2F.bit.b0

//------------------------------------
#define P9PU                    _0x0F30.byte
#define P9PU_P7                 _0x0F30.bit.b7
#define P9PU_P6                 _0x0F30.bit.b6
#define P9PU_P5                 _0x0F30.bit.b5
#define P9PU_P4                 _0x0F30.bit.b4
#define P9PU_P3                 _0x0F30.bit.b3
#define P9PU_P2                 _0x0F30.bit.b2
#define P9PU_P1                 _0x0F30.bit.b1
#define P9PU_P0                 _0x0F30.bit.b0

//------------------------------------
#define P0FC                    _0x0F34.byte
#define P0FC_P7                 _0x0F34.bit.b7
#define P0FC_P6                 _0x0F34.bit.b6
#define P0FC_P5                 _0x0F34.bit.b5
#define P0FC_P4                 _0x0F34.bit.b4
#define P0FC_P3                 _0x0F34.bit.b3
#define P0FC_P2                 _0x0F34.bit.b2
#define P0FC_P1                 _0x0F34.bit.b1
#define P0FC_P0                 _0x0F34.bit.b0

//------------------------------------
#define P2FC                    _0x0F36.byte
#define P2FC_P7                 _0x0F36.bit.b7
#define P2FC_P6                 _0x0F36.bit.b6
#define P2FC_P5                 _0x0F36.bit.b5
#define P2FC_P4                 _0x0F36.bit.b4
#define P2FC_P3                 _0x0F36.bit.b3
#define P2FC_P2                 _0x0F36.bit.b2
#define P2FC_P1                 _0x0F36.bit.b1
#define P2FC_P0                 _0x0F36.bit.b0

//------------------------------------
#define P4FC                    _0x0F38.byte
#define P4FC_P7                 _0x0F38.bit.b7
#define P4FC_P6                 _0x0F38.bit.b6
#define P4FC_P5                 _0x0F38.bit.b5
#define P4FC_P4                 _0x0F38.bit.b4
#define P4FC_P3                 _0x0F38.bit.b3
#define P4FC_P2                 _0x0F38.bit.b2
#define P4FC_P1                 _0x0F38.bit.b1
#define P4FC_P0                 _0x0F38.bit.b0

//------------------------------------
#define P5FC                    _0x0F39.byte
#define P5FC_P7                 _0x0F39.bit.b7
#define P5FC_P6                 _0x0F39.bit.b6
#define P5FC_P5                 _0x0F39.bit.b5
#define P5FC_P4                 _0x0F39.bit.b4
#define P5FC_P3                 _0x0F39.bit.b3
#define P5FC_P2                 _0x0F39.bit.b2
#define P5FC_P1                 _0x0F39.bit.b1
#define P5FC_P0                 _0x0F39.bit.b0

//------------------------------------
#define P7FC                    _0x0F3B.byte
#define P7FC_P7                 _0x0F3B.bit.b7
#define P7FC_P6                 _0x0F3B.bit.b6
#define P7FC_P5                 _0x0F3B.bit.b5
#define P7FC_P4                 _0x0F3B.bit.b4
#define P7FC_P3                 _0x0F3B.bit.b3
#define P7FC_P2                 _0x0F3B.bit.b2
#define P7FC_P1                 _0x0F3B.bit.b1
#define P7FC_P0                 _0x0F3B.bit.b0

//------------------------------------
#define P8FC                    _0x0F3C.byte
#define P8FC_P7                 _0x0F3C.bit.b7
#define P8FC_P6                 _0x0F3C.bit.b6
#define P8FC_P5                 _0x0F3C.bit.b5
#define P8FC_P4                 _0x0F3C.bit.b4
#define P8FC_P3                 _0x0F3C.bit.b3
#define P8FC_P2                 _0x0F3C.bit.b2
#define P8FC_P1                 _0x0F3C.bit.b1
#define P8FC_P0                 _0x0F3C.bit.b0

//------------------------------------
#define P9FC                    _0x0F3D.byte
#define P9FC_P7                 _0x0F3D.bit.b7
#define P9FC_P6                 _0x0F3D.bit.b6
#define P9FC_P5                 _0x0F3D.bit.b5
#define P9FC_P4                 _0x0F3D.bit.b4
#define P9FC_P3                 _0x0F3D.bit.b3
#define P9FC_P2                 _0x0F3D.bit.b2
#define P9FC_P1                 _0x0F3D.bit.b1
#define P9FC_P0                 _0x0F3D.bit.b0

//------------------------------------
#define P2OUTCR                 _0x0F43.byte
#define P2OUTCR_P7              _0x0F43.bit.b7
#define P2OUTCR_P6              _0x0F43.bit.b6
#define P2OUTCR_P5              _0x0F43.bit.b5
#define P2OUTCR_P4              _0x0F43.bit.b4
#define P2OUTCR_P3              _0x0F43.bit.b3
#define P2OUTCR_P2              _0x0F43.bit.b2
#define P2OUTCR_P1              _0x0F43.bit.b1
#define P2OUTCR_P0              _0x0F43.bit.b0

//------------------------------------
//------------------------------------
#define UART1CR1                _0x0F54.byte
#define UART1CR1_TXE            _0x0F54.bit.b7
#define UART1CR1_RXE            _0x0F54.bit.b6
#define UART1CR1_STOPBT         _0x0F54.bit.b5
#define UART1CR1_EVEN           _0x0F54.bit.b4
#define UART1CR1_PE             _0x0F54.bit.b3
#define UART1CR1_IRDASEL        _0x0F54.bit.b2
#define UART1CR1_BRG            _0x0F54.bit.b1

//------------------------------------
#define UART1CR2                _0x0F55.byte
#define UART1CR2_RTSEL          _0x0F55.b5_3.b5_3
#define UART1CR2_RXDNC          _0x0F55.b2_1.b2_1
#define UART1CR2_STOPBR         _0x0F55.bit.b0

//------------------------------------
#define UART1DR                 _0x0F56.byte

//------------------------------------
#define UART1SR                 _0x0F57.byte
#define UART1SR_PERR            _0x0F57.bit.b7
#define UART1SR_FERR            _0x0F57.bit.b6
#define UART1SR_OERR            _0x0F57.bit.b5
#define UART1SR_RBSY            _0x0F57.bit.b3
#define UART1SR_RBFL            _0x0F57.bit.b2
#define UART1SR_TBSY            _0x0F57.bit.b1
#define UART1SR_TBFL            _0x0F57.bit.b0

//------------------------------------
// TD1BUF and RD1BUF have the same address
#define TD1BUF                  _0x0F58.byte
#define RD1BUF                  _0x0F58.byte

//------------------------------------
#define TA1DRA                  _0x0F5A.word
#define TA1DRAL                 _0x0F5A.byte[0]
#define TA1DRAH                 _0x0F5A.byte[1]

//------------------------------------
#define TA1DRB                  _0x0F5C.word
#define TA1DRBL                 _0x0F5C.byte[0]
#define TA1DRBH                 _0x0F5C.byte[1]

//------------------------------------
#define TA1MOD                  _0x0F5E.byte
#define TA1MOD_TADBE            _0x0F5E.bit.b7
#define TA1MOD_TATED            _0x0F5E.bit.b6
#define TA1MOD_TAMCAP           _0x0F5E.bit.b5
#define TA1MOD_TAMETT           _0x0F5E.bit.b5
#define TA1MOD_TACK             _0x0F5E.b4_3.b4_3
#define TA1MOD_TAM              _0x0F5E.b2_0.b2_0

//------------------------------------
#define TA1CR                   _0x0F5F.byte
#define TA1CR_TAOVE             _0x0F5F.bit.b7
#define TA1CR_TATFF             _0x0F5F.bit.b6
#define TA1CR_TANC              _0x0F5F.b5_4.b5_4
#define TA1CR_TAACAP            _0x0F5F.bit.b1
#define TA1CR_TAMPPG            _0x0F5F.bit.b1
#define TA1CR_TAS               _0x0F5F.bit.b0

//------------------------------------
#define TA1SR                   _0x0F60.byte
#define TA1SR_TAOVF             _0x0F60.bit.b7
#define TA1SR_TACPFA            _0x0F60.bit.b1
#define TA1SR_TACPFB            _0x0F60.bit.b0

//------------------------------------




//------------------------------------
#define POFFCR0                 _0x0F74.byte
#define POFFCR0_TCC1EN          _0x0F74.bit.b6 
#define POFFCR0_TC001EN         _0x0F74.bit.b4 
#define POFFCR0_TCA1EN          _0x0F74.bit.b1
#define POFFCR0_TCA0EN          _0x0F74.bit.b0

//------------------------------------
#define POFFCR1                 _0x0F75.byte
#define POFFCR1_SBI0EN          _0x0F75.bit.b4
#define POFFCR1_UART1EN         _0x0F75.bit.b1
#define POFFCR1_UART0EN         _0x0F75.bit.b0

//------------------------------------
#define POFFCR2                 _0x0F76.byte
#define POFFCR2_LCDEN           _0x0F76.bit.b7
#define POFFCR2_RTCEN           _0x0F76.bit.b5
#define POFFCR2_SIO1EN          _0x0F76.bit.b1
#define POFFCR2_SIO0EN          _0x0F76.bit.b0

//------------------------------------
#define POFFCR3                 _0x0F77.byte
#define POFFCR3_CMP23EN         _0x0F77.bit.b7
#define POFFCR3_CMP01EN         _0x0F77.bit.b6

#define POFFCR3_INT4EN          _0x0F77.bit.b4
#define POFFCR3_INT3EN          _0x0F77.bit.b3
#define POFFCR3_INT2EN          _0x0F77.bit.b2
#define POFFCR3_INT1EN          _0x0F77.bit.b1
#define POFFCR3_INT0EN          _0x0F77.bit.b0


//------------------------------------







//------------------------------------
#define TC1CR1                  _0x0F9C.byte
#define TC1CR1_TRGAM            _0x0F9C.bit.b7
#define TC1CR1_TRGSEL           _0x0F9C.bit.b6
#define TC1CR1_PPGC2INI         _0x0F9C.bit.b5
#define TC1CR1_PPGC1INI         _0x0F9C.bit.b4
#define TC1CR1_NCRSEL           _0x0F9C.b3_2.b3_2
#define TC1CR1_TCCCK            _0x0F9C.b1_0.b1_0

//------------------------------------
#define TC1CR2                  _0x0F9D.byte
#define TC1CR2_EMGR             _0x0F9D.bit.b7
#define TC1CR2_EMGIE            _0x0F9D.bit.b6
#define TC1CR2_PPGC2OE          _0x0F9D.bit.b5
#define TC1CR2_PPGC1OE          _0x0F9D.bit.b4
#define TC1CR2_CSTC             _0x0F9D.b3_2.b3_2
#define TC1CR2_TCCOUT           _0x0F9D.b1_0.b1_0

//------------------------------------
#define TC1CR3                  _0x0F9E.byte
#define TC1CR3_EMGF             _0x0F9E.bit.b5
#define TC1CR3_CNTBF            _0x0F9E.bit.b4
#define TC1CR3_CSIDIS           _0x0F9E.bit.b3
#define TC1CR3_STM              _0x0F9E.b2_1.b2_1
#define TC1CR3_TCCST            _0x0F9E.bit.b0

//------------------------------------
#define TC1DRA                  _0x0F9F.word
#define TC1DRAL                 _0x0F9F.byte[0]
#define TC1DRAH                 _0x0F9F.byte[1]

//------------------------------------
#define TC1DRB                  _0x0FA1.word
#define TC1DRBL                 _0x0FA1.byte[0]
#define TC1DRBH                 _0x0FA1.byte[1]

//------------------------------------
#define TC1DRC                  _0x0FA3.word
#define TC1DRCL                 _0x0FA3.byte[0]
#define TC1DRCH                 _0x0FA3.byte[1]

//------------------------------------
#define TC1DRD                  _0x0FA5.word
#define TC1DRDL                 _0x0FA5.byte[0]
#define TC1DRDH                 _0x0FA5.byte[1]

//------------------------------------
#define TC1DRE                  _0x0FA7.word
#define TC1DREL                 _0x0FA7.byte[0]
#define TC1DREH                 _0x0FA7.byte[1]

//------------------------------------
#define TC1CAPA                 _0x0FA9.word
#define TC1CAPAL                _0x0FA9.byte[0]
#define TC1CAPAH                _0x0FA9.byte[1]

//------------------------------------
#define TC1CAPB                 _0x0FAB.word
#define TC1CAPBL                _0x0FAB.byte[0]
#define TC1CAPBH                _0x0FAB.byte[1]


//------------------------------------
#define KWUCR0                  _0x0FC4.byte
#define KWUCR0_KW3LE            _0x0FC4.bit.b7
#define KWUCR0_KW3EN            _0x0FC4.bit.b6
#define KWUCR0_KW2LE            _0x0FC4.bit.b5
#define KWUCR0_KW2EN            _0x0FC4.bit.b4
#define KWUCR0_KW1LE            _0x0FC4.bit.b3
#define KWUCR0_KW1EN            _0x0FC4.bit.b2
#define KWUCR0_KW0LE            _0x0FC4.bit.b1
#define KWUCR0_KW0EN            _0x0FC4.bit.b0

//------------------------------------
#define KWUCR1                  _0x0FC5.byte
#define KWUCR1_KW7LE            _0x0FC5.bit.b7
#define KWUCR1_KW7EN            _0x0FC5.bit.b6
#define KWUCR1_KW6LE            _0x0FC5.bit.b5
#define KWUCR1_KW6EN            _0x0FC5.bit.b4
#define KWUCR1_KW5LE            _0x0FC5.bit.b3
#define KWUCR1_KW5EN            _0x0FC5.bit.b2
#define KWUCR1_KW4LE            _0x0FC5.bit.b1
#define KWUCR1_KW4EN            _0x0FC5.bit.b0

//------------------------------------
#define VDCR1                   _0x0FC6.byte
#define VDCR1_VD2F              _0x0FC6.bit.b7
#define VDCR1_VD2SF             _0x0FC6.bit.b6
#define VDCR1_VD2LVL            _0x0FC6.b5_4.b5_4
#define VDCR1_VD1F              _0x0FC6.bit.b3
#define VDCR1_VD1SF             _0x0FC6.bit.b2
#define VDCR1_VD1LVL            _0x0FC6.b1_0.b1_0

//------------------------------------
#define VDCR2                   _0x0FC7.byte
#define VDCR2_VD2MOD            _0x0FC7.bit.b3
#define VDCR2_VD2EN             _0x0FC7.bit.b2
#define VDCR2_VD1MOD            _0x0FC7.bit.b1
#define VDCR2_VD1EN             _0x0FC7.bit.b0

//------------------------------------
#define RTCCR                   _0x0FC8.byte
#define RTCCR_RTCSEL            _0x0FC8.b3_1.b3_1
#define RTCCR_RTCRUN            _0x0FC8.bit.b0

//------------------------------------
#define KWUCR2                  _0x0FCA.byte
#define KWUCR2_KW11LE           _0x0FCA.bit.b7
#define KWUCR2_KW11EN           _0x0FCA.bit.b6
#define KWUCR2_KW10LE           _0x0FCA.bit.b5
#define KWUCR2_KW10EN           _0x0FCA.bit.b4
#define KWUCR2_KW9LE            _0x0FCA.bit.b3
#define KWUCR2_KW9EN            _0x0FCA.bit.b2
#define KWUCR2_KW8LE            _0x0FCA.bit.b1
#define KWUCR2_KW8EN            _0x0FCA.bit.b0

//------------------------------------
#define KWUCR3                  _0x0FCB.byte
#define KWUCR3_KW15LE           _0x0FCB.bit.b7
#define KWUCR3_KW15EN           _0x0FCB.bit.b6
#define KWUCR3_KW14LE           _0x0FCB.bit.b5
#define KWUCR3_KW14EN           _0x0FCB.bit.b4
#define KWUCR3_KW13LE           _0x0FCB.bit.b3
#define KWUCR3_KW13EN           _0x0FCB.bit.b2
#define KWUCR3_KW12LE           _0x0FCB.bit.b1
#define KWUCR3_KW12EN           _0x0FCB.bit.b0

//------------------------------------
#define IRSTSR                  _0x0FCC.byte
#define IRSTSR_FCLR             _0x0FCC.bit.b7
#define IRSTSR_WDT2RF           _0x0FCC.bit.b7
#define IRSTSR_FLSRF            _0x0FCC.bit.b6
#define IRSTSR_LVD2RF           _0x0FCC.bit.b3
#define IRSTSR_LVD1RF           _0x0FCC.bit.b2
#define IRSTSR_SYSRF            _0x0FCC.bit.b1
#define IRSTSR_WDTRF            _0x0FCC.bit.b0

//------------------------------------
#define WUCCR                   _0x0FCD.byte
#define WUCCR_WUCRST            _0x0FCD.bit.b7
#define WUCCR_WUCDIV            _0x0FCD.b3_2.b3_2
#define WUCCR_WUCSEL            _0x0FCD.b1_0.b1_0

//------------------------------------
#define WUCDR                   _0x0FCE.byte

//------------------------------------
#define CGCR                    _0x0FCF.byte
#define CGCR_FCGCKSEL           _0x0FCF.b1_0.b1_0

//------------------------------------
#define FLSCR1                  _0x0FD0.byte
#define FLSCR1_FLSMD            _0x0FD0.b7_5.b7_5

//------------------------------------
// FLSCR2 and FLSCRM have the same address
#define FLSCR2                  _0x0FD1.byte
#define FLSCR2_CR1EN            _0x0FD1.byte
#define FLSCRM                  _0x0FD1.byte
#define FLSCRM_FLSMDM           _0x0FD1.bit.b5

//------------------------------------
#define FLSSTB                  _0x0FD2.byte
#define FLSSTB_FSTB             _0x0FD2.bit.b0

//------------------------------------


//------------------------------------
#define WDCTR                   _0x0FD4.byte
#define WDCTR_WDTEN             _0x0FD4.bit.b5
#define WDCTR_WDTW              _0x0FD4.b4_3.b4_3
#define WDCTR_WDTT              _0x0FD4.b2_1.b2_1
#define WDCTR_WDTOUT            _0x0FD4.bit.b0

//------------------------------------
#define WDCDR                   _0x0FD5.byte
#define WDCDR_WDTCR2            _0x0FD5.byte

//------------------------------------
#define WDCNT                   _0x0FD6.byte

//------------------------------------
#define WDST                    _0x0FD7.byte
#define WDST_WINTST2            _0x0FD7.bit.b2
#define WDST_WINTST1            _0x0FD7.bit.b1
#define WDST_WDTST              _0x0FD7.bit.b0

//------------------------------------
#define EINTCR1                 _0x0FD8.byte
#define EINTCR1_NCE             _0x0FD8.bit.b6
#define EINTCR1_INTSEL          _0x0FD8.bit.b5
#define EINTCR1_INTLVL          _0x0FD8.bit.b4
#define EINTCR1_INTES           _0x0FD8.b3_2.b3_2
#define EINTCR1_INTNC           _0x0FD8.b1_0.b1_0

//------------------------------------
#define EINTCR2                 _0x0FD9.byte
#define EINTCR2_NCE             _0x0FD9.bit.b6
#define EINTCR2_INTSEL          _0x0FD9.bit.b5
#define EINTCR2_INTLVL          _0x0FD9.bit.b4
#define EINTCR2_INTES           _0x0FD9.b3_2.b3_2
#define EINTCR2_INTNC           _0x0FD9.b1_0.b1_0

//------------------------------------
#define EINTCR3                 _0x0FDA.byte
#define EINTCR3_NCE             _0x0FDA.bit.b6
#define EINTCR3_INTSEL          _0x0FDA.bit.b5
#define EINTCR3_INTLVL          _0x0FDA.bit.b4
#define EINTCR3_INTES           _0x0FDA.b3_2.b3_2
#define EINTCR3_INTNC           _0x0FDA.b1_0.b1_0

//------------------------------------
#define EINTCR4                 _0x0FDB.byte
#define EINTCR4_INTLVL          _0x0FDB.bit.b4
#define EINTCR4_INTES           _0x0FDB.b3_2.b3_2
#define EINTCR4_INTNC           _0x0FDB.b1_0.b1_0

//------------------------------------
#define SYSCR1                  _0x0FDC.byte
#define SYSCR1_STOP             _0x0FDC.bit.b7
#define SYSCR1_RELM             _0x0FDC.bit.b6
#define SYSCR1_OUTEN            _0x0FDC.bit.b5
#define SYSCR1_DV9CK            _0x0FDC.bit.b4
#define SYSCR1_OSCSEL           _0x0FDC.bit.b3

//------------------------------------
#define SYSCR2                  _0x0FDD.byte
#define SYSCR2_OSCEN            _0x0FDD.bit.b7
#define SYSCR2_XEN              _0x0FDD.bit.b6
#define SYSCR2_XTEN             _0x0FDD.bit.b5
#define SYSCR2_SYSCK            _0x0FDD.bit.b4
#define SYSCR2_IDLE             _0x0FDD.bit.b3
#define SYSCR2_TGHALT           _0x0FDD.bit.b2

//------------------------------------
#define SYSCR3                  _0x0FDE.byte
#define SYSCR3_RSTDIS           _0x0FDE.bit.b0

//------------------------------------
// SYSCR4 and SYSSR4 have the same address
#define SYSCR4                  _0x0FDF.byte
#define SYSSR4                  _0x0FDF.byte
#define SYSSR4_RSTDISS          _0x0FDF.bit.b0

//------------------------------------
#define ILL                     _0x0FE0.byte
//******
#define ILL_IL7                 _0x0FE0.bit.b7
#define IL_INTRXD0              _0x0FE0.bit.b7
//******
#define ILL_IL6                 _0x0FE0.bit.b6
#define IL_INTSIO0              _0x0FE0.bit.b6
//******
#define ILL_IL5                 _0x0FE0.bit.b5
#define IL_INTTBT               _0x0FE0.bit.b5
//******
#define ILL_IL4                 _0x0FE0.bit.b4
#define IL_INTWUC               _0x0FE0.bit.b4
//******
#define ILL_IL3                 _0x0FE0.bit.b3
#define IL_INTWDT               _0x0FE0.bit.b3

//------------------------------------
#define ILH                     _0x0FE1.byte
//******
#define ILH_IL15                _0x0FE1.bit.b7
#define IL_INTSBI               _0x0FE1.bit.b7
//******
#define ILH_IL14                _0x0FE1.bit.b6
#define IL_INTTCA0              _0x0FE1.bit.b6
//******
#define ILH_IL13                _0x0FE1.bit.b5
#define IL_INTTC01              _0x0FE1.bit.b5
//******
#define ILH_IL12                _0x0FE1.bit.b4
#define IL_INTTC00              _0x0FE1.bit.b4
//******
#define ILH_IL11                _0x0FE1.bit.b3
#define IL_INTRTC               _0x0FE1.bit.b3
//******
#define ILH_IL10                _0x0FE1.bit.b2
#define IL_INTADC               _0x0FE1.bit.b2
//******
#define ILH_IL9                 _0x0FE1.bit.b1
#define IL_INTLVD               _0x0FE1.bit.b1
//******
#define ILH_IL8                 _0x0FE1.bit.b0
#define IL_INTTXD0              _0x0FE1.bit.b0

//------------------------------------
#define ILE                     _0x0FE2.byte
//******
#define ILE_IL23                _0x0FE2.bit.b7
#define IL_INTTXD1              _0x0FE2.bit.b7
//******
#define ILE_IL22                _0x0FE2.bit.b6
#define IL_INTRXD1              _0x0FE2.bit.b6
//******
#define ILE_IL21                _0x0FE2.bit.b5

//******
#define ILE_IL20                _0x0FE2.bit.b4

//******
#define ILE_IL19                _0x0FE2.bit.b3
#define IL_INT3                 _0x0FE2.bit.b3
#define IL_INTEMG1              _0x0FE2.bit.b2
//******
#define ILE_IL18                _0x0FE2.bit.b2
#define IL_INT2                 _0x0FE2.bit.b2

//******
#define ILE_IL17                _0x0FE2.bit.b1
#define IL_INT1                 _0x0FE2.bit.b1
//******
#define ILE_IL16                _0x0FE2.bit.b0
#define IL_INT0                 _0x0FE2.bit.b0

//------------------------------------
#define ILD                     _0x0FE3.byte
//******
#define ILD_IL31                _0x0FE3.bit.b7

//******
#define ILD_IL30                _0x0FE3.bit.b6

//******
#define ILD_IL29                _0x0FE3.bit.b5
#define IL_INTTCC1P             _0x0FE3.bit.b5
//******
#define ILD_IL28                _0x0FE3.bit.b4
#define IL_INTTCC1T             _0x0FE3.bit.b4
//******
#define ILD_IL27                _0x0FE3.bit.b3
#define IL_INTTCA1              _0x0FE3.bit.b3
//******
#define ILD_IL26                _0x0FE3.bit.b2

//******
#define ILD_IL25                _0x0FE3.bit.b1


//******
#define ILD_IL24                _0x0FE3.bit.b0


//------------------------------------
													//FF0~FF3 /*

#define ILRSL                   _0x0FF0.byte
//******
#define ILRSL_ILRS7             _0x0FF0.bit.b7
#define ILRS_INTRXD0            _0x0FF0.bit.b7
//******
#define ILRSL_ILRS6             _0x0FF0.bit.b6
#define ILRS_INTSIO0            _0x0FF0.bit.b6
//******
#define ILRSL_ILRS5             _0x0FF0.bit.b5
#define ILRS_INTTBT             _0x0FF0.bit.b5

//------------------------------------
#define ILRSH                   _0x0FF1.byte
//******
#define ILRSH_ILRS15            _0x0FF1.bit.b7
#define ILRS_INTSBI             _0x0FF1.bit.b7
//******
#define ILRSH_ILRS14            _0x0FF1.bit.b6
#define ILRS_INTTCA0            _0x0FF1.bit.b6
//******
#define ILRSH_ILRS13            _0x0FF1.bit.b5
#define ILRS_INTTC01            _0x0FF1.bit.b5
//******
#define ILRSH_ILRS12            _0x0FF1.bit.b4
#define ILRS_INTTC00            _0x0FF1.bit.b4
//******
#define ILRSH_ILRS11            _0x0FF1.bit.b3
#define ILRS_INTRTC             _0x0FF1.bit.b3
//******
#define ILRSH_ILRS10            _0x0FF1.bit.b2
#define ILRS_INTADC             _0x0FF1.bit.b2
//******
#define ILRSH_ILRS9             _0x0FF1.bit.b1
#define ILRS_INTLVD             _0x0FF1.bit.b1
//******
#define ILRSH_ILRS8             _0x0FF1.bit.b0
#define ILRS_INTTXD0            _0x0FF1.bit.b0

//------------------------------------
#define ILRSE                   _0x0FF2.byte
//******
#define ILRSE_ILRS23            _0x0FF2.bit.b7
#define ILRS_INTTXD1            _0x0FF2.bit.b7
//******
#define ILRSE_ILRS22            _0x0FF2.bit.b6
#define ILRS_INTRXD1            _0x0FF2.bit.b6
//******
#define ILRSE_ILRS21            _0x0FF2.bit.b5

//******
#define ILRSE_ILRS20            _0x0FF2.bit.b4
#define ILRS_INT4               _0x0FF2.bit.b4
//******
#define ILRSE_ILRS19            _0x0FF2.bit.b3
#define ILRS_INT3               _0x0FF2.bit.b3
//******
#define ILRSE_ILRS18            _0x0FF2.bit.b2
#define ILRS_INT2               _0x0FF2.bit.b2
#define ILRS_INTEMG0            _0x0FF2.bit.b2
//******
#define ILRSE_ILRS17            _0x0FF2.bit.b1
#define ILRS_INT1               _0x0FF2.bit.b1
//******
#define ILRSE_ILRS16            _0x0FF2.bit.b0
#define ILRS_INT0               _0x0FF2.bit.b0

//------------------------------------
#define ILRSD                   _0x0FF3.byte
//******
#define ILRSD_ILRS31            _0x0FF3.bit.b7
#define ILRS_INTTCC0P           _0x0FF3.bit.b7
//******
#define ILRSD_ILRS30            _0x0FF3.bit.b6
#define ILRS_INTTCC0T           _0x0FF3.bit.b6
//******
#define ILRSD_ILRS29            _0x0FF3.bit.b5
#define ILRS_INTTC05            _0x0FF3.bit.b5
//******
#define ILRSD_ILRS28            _0x0FF3.bit.b4
#define ILRS_INTTC04            _0x0FF3.bit.b4
//******
#define ILRSD_ILRS27            _0x0FF3.bit.b3
#define ILRS_INTTCA1            _0x0FF3.bit.b3
//******
#define ILRSD_ILRS26            _0x0FF3.bit.b2
#define ILRS_INTSIO1            _0x0FF3.bit.b2
//******
#define ILRSD_ILRS25            _0x0FF3.bit.b1
#define ILRS_INTTC03            _0x0FF3.bit.b1
//******
#define ILRSD_ILRS24            _0x0FF3.bit.b0
#define ILRS_INTTC02            _0x0FF3.bit.b0
//====================================================
//			SFR2
//====================================================
#endif		//_MQ6823_SFR_NAME_H_
















