//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: to drive 4-bit segment LCD GDC03077
//******************************************
//******************************************
//Stack Pointer	=	0x23f (If use mq6822_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 

#define Btn_STOP	P0PRD.bit.b0

//-- header guards --//
#define uchar unsigned char
#define uint  unsigned int
#define ulong unsigned long


//-- Define IO port --//


//-- function definition --//
void delay_ms(uint x);
void delay_100us(uint x);
void delay_6us(uint x);

void LCD_init_config();
void GDC03077_init_seq();
void Dig_Decode(uchar digN, uchar Num);
void Bat_Decode(uchar Num);


const uchar DIG_CODE_fge[16]={  0x05, 0x00, 0x06, 0x02, 0x03, 0x03, 0x07, 0x01,
								0x07, 0x03, 0x07, 0x07, 0x05, 0x06, 0x07, 0x07 };

const uchar DIG_CODE_abcd[16]={	0x0F, 0x06, 0x0B, 0x0F, 0x06, 0x0D, 0x0D, 0x07,
								0x0F, 0x0F, 0x07, 0x0C, 0x09, 0x0E, 0x09, 0x01 };

const uchar DIG_lcd_buf[8]={  0, 0, 2, 4, 6, 0, 2, 4 };
//0x5F, 0x06, 0x6B, 0x2F, 0x36, 0x3D, 0x7D, 0x17,
//0x7F, 0x3F, 0x77, 0x7C, 0x59, 0x6E, 0x79, 0x71 };




//*********************************************************************
// name			: main
// brief		: main function
// note			:
//*********************************************************************
void main()
{
	uchar DigN, NumN, iloop;

//-----Set WDT Disable-----
	WDCTR.byte = 0x00;		//clear wdt
	WDCDR.byte = 0xb1;		//clear wdt
	WDCDR.byte = 0x4e;		//clear wdt counter

//-----Disable P10 Reset-----
//	SYSCR3.byte = 0x01;
//	SYSCR4.byte = 0xB2;


//>>>>>> IO port initial-----

	LCD_init_config();

	P0CR.bit.b0	  = 0;				
	P0PU.bit.b0	  = 1;				// enable P00 built-in pull-up resistor
	
	P4CR.bit.b3   = 0;
	P4PU.bit.b3   = 1;				// enable P43(KWI3) built-in pull-up resistor
	KWUCR0.bit.b7 = 0;				// low level release STOP mode of KWI3
	KWUCR0.bit.b6 = 1;				// enable KWI3


//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		for( DigN=1; DigN<=10; DigN++)
		{
			for( NumN=0; NumN<16; NumN++)
			{

				if( Btn_STOP == 0)
				{				
					LCDCR3.byte    = 0x00;		
					LCDCR4.byte    = 0x00;		// disable SEG4~SEG11 output
					LCDCR5.byte    = 0x00;		// disable from COM0 to COM7 outpput
					LCDCR1.bit.b7  = 0;			// disable LCD control
					POFFCR2.bit.b7 = 0;			// disable the basic clock supply to LCD					
					
					// set all pins used for the LCD function to output low level to avoid leakage
									
					
					P2DR.byte     &= (~0xF8); 
					P4DR.byte     &= (~0xF0); 
					P7DR.byte     &= (~0xFD); 
					P8DR.byte     &= (~0x0C); 
					P9DR.byte     &= (~0x03); 					
					P2CR.byte     |= 0x18; 
					P4CR.byte     |= 0xF0; 
					P7CR.byte     |= 0x7D; 
					P8CR.byte     |= 0x0C; 
					P9CR.byte     |= 0x03; 
					//
				
					SYSCR1.byte   |= 0x60;		// set pot to output hold in the STOP mode and STOP release mode to level-sensitive release mode
					SYSCR1.bit.b7  = 1;			// activate the STOP mode

					// before using the LCD, set all pins used for the LCD function as input pins 
					P2CR.byte     &= (~0xF8); 
					P4CR.byte     &= (~0xF0); 
					P7CR.byte     &= (~0xFD); 
					P8CR.byte     &= (~0x0C); 
					P9CR.byte     &= (~0x03); 

					POFFCR2.bit.b7 = 1;			// enable the basic clock supply to LCD
					LCDCR3.byte    = 0xFF;		
					LCDCR4.byte    = 0x0F;		// enable SEG0~SEG11 output 
					LCDCR5.byte    = 0xFF;		// enable from COM0 to COM7 outpput 
					LCDCR1.bit.b7  = 1;         // enable LCD control
				}					
			
				// Run digit 1~7,9,10
				Dig_Decode(DigN, NumN);
				delay_ms(500);
				WDCDR.byte = 0x4E;
			}
		}
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
}




//*********************************************************************
// name			: Dig_Decode(uchar digN, uchar Num)
// brief		: digital display for GDC03077
// note			:
//*********************************************************************
void Dig_Decode(uchar digN, uchar Num)
{
	uchar NumFGE=0, NumABCD=0, NumMask;

	if( digN/5 )
	{
		NumMask  = 0xf0;
		NumFGE   = DIG_CODE_fge[Num];
		NumABCD  = DIG_CODE_abcd[Num];
	}
	else
	{
		NumMask  = 0x0f;
		NumFGE   = DIG_CODE_fge[Num]  << 4;
		NumABCD  = DIG_CODE_abcd[Num] << 4;
	}

	switch(digN){
		case 1:
			LCDBUF00.byte &= NumMask;
			LCDBUF01.byte &= NumMask;
			LCDBUF00.byte |= NumFGE;
			LCDBUF01.byte |= NumABCD;
			break;
		case 2:
			LCDBUF02.byte &= NumMask;
			LCDBUF03.byte &= NumMask;
			LCDBUF02.byte |= NumFGE;
			LCDBUF03.byte |= NumABCD;
			break;
		case 3:
			LCDBUF04.byte &= NumMask;
			LCDBUF05.byte &= NumMask;
			LCDBUF04.byte |= NumFGE;
			LCDBUF05.byte |= NumABCD;
			break;
		case 4:
			LCDBUF06.byte &= NumMask;
			LCDBUF07.byte &= NumMask;
			LCDBUF06.byte |= NumFGE;
			LCDBUF07.byte |= NumABCD;
			break;
		case 5:
			LCDBUF00.byte &= NumMask;
			LCDBUF01.byte &= NumMask;
			LCDBUF00.byte |= NumFGE;
			LCDBUF01.byte |= NumABCD;
			break;
		case 6:
			LCDBUF02.byte &= NumMask;
			LCDBUF03.byte &= NumMask;
			LCDBUF02.byte |= NumFGE;
			LCDBUF03.byte |= NumABCD;
			break;
		case 7:
			LCDBUF04.byte &= NumMask;
			LCDBUF05.byte &= NumMask;
			LCDBUF04.byte |= NumFGE;
			LCDBUF05.byte |= NumABCD;
			break;
		case 9:
			LCDBUF10.byte &= NumMask;
			LCDBUF11.byte &= NumMask;
			LCDBUF10.byte |= NumABCD;
			LCDBUF11.byte |= NumFGE;		
			break;		
		case 10:
			LCDBUF08.byte &= NumMask;
			LCDBUF09.byte &= NumMask;
			LCDBUF08.byte |= NumABCD;
			LCDBUF09.byte |= NumFGE;
			break;	
			
		default:
			break;
	}

}





//*********************************************************************
// name			: LCD_init_config()
// brief		: LCD_init_config
// note			:
//*********************************************************************
void LCD_init_config()
{
	P2CR.byte  &= (~0xF8); 
	P4CR.byte  &= (~0xF0); 
	P7CR.byte  &= (~0xFD); 
	P8CR.byte  &= (~0x0C); 
	P9CR.byte  &= (~0x03); 


	POFFCR2.bit.b7 = 1;		//enable LCDEN
	LCDCR1.byte = 0x53;		//1/4Bias , 1/8Duty , Fcgck/2^15
//	LCDCR1.byte = 0x63;		//1/3Bias , 1/8Duty , Fcgck/2^15
//	LCDCR1.byte = 0x73;		//1/2Bias , 1/8Duty , Fcgck/2^15
	LCDCR2.byte = 0x18;		//Default , No bleeder resistance

	GDC03077_init_seq();

	LCDCR3.byte = 0xFF;		//Enable SEGL_EN[7:0]
	LCDCR4.byte = 0x0F;		//Enable SEGH_EN[3:0]
	LCDCR5.byte = 0xFF;		//Enable COM_EN[7:0]
	LCDCR1.bit.b7 = 1;
}


//*********************************************************************
// name			: GDC03077_init_seq()
// brief		: GDC03077 all on
// note			: 
//*********************************************************************
void GDC03077_init_seq()
{

	LCDBUF00.byte = 0x55;
	LCDBUF01.byte = 0xFF;
	LCDBUF02.byte = 0x55;
	LCDBUF03.byte = 0xFF;
	LCDBUF04.byte = 0xFF;
	LCDBUF05.byte = 0xFF;
	LCDBUF06.byte = 0xFF;
	LCDBUF07.byte = 0xFF;
	LCDBUF08.byte = 0xFF;
	LCDBUF09.byte = 0xFF;
	LCDBUF10.byte = 0xFF;
	LCDBUF11.byte = 0xFF;

}


//*********************************************************************
// name			: delay_ms/us()
// brief		: time delay function
// note			:
//*********************************************************************
void delay_ms(uint x)
{
	uint i;
	for(; x>0; x--)
	{
	//	for(i=0; i<170; i++){}
		for(i=0; i<340; i++){}
		WDCDR.byte=0x4e; 		//clear wdt
	}
}

void delay_100us(uint x)
{
	uchar i;
	for(; x>0; x--)
	{
	//	for(i=0; i<17; i++){}
		for(i=0; i<34; i++){}
	}
	WDCDR.byte=0x4e; 		//clear wdt
}

void delay_6us(uint x)
{
	for(; x>0; x--){}
}
