//******************************************
// file			: MQ6812_UART
// version		: V1.0
// brief		: UARTʹú
// note			:
//******************************************

#include "main.h"


uchar flowFlag, rcv_cnt;
uchar uart1_status, tx1_data, rx1_data;

//*********************************************************************
// name			: UART1_Init
// brief		: UART initialization
// note			: operation mode must be NORMAL1 mode and NORMAL2 mode
//*********************************************************************
void UART1_Init(void)
{
//====== pin configuration ======
    P9CR_P1 = 0;                        // set P91 as input pin
    P9CR_P0 = 1;                        // set P90 as output pin
    P9FC_P0 = 1;                        // set P90 as special function pin

    UATCNG_UAT2IO = 0;                  // 0: set P90/P91 as UART input/output pin     1: set P26/P27 as UART input/output pin
    UATCNG_UAT1IO = 0;                  // 0: set P90 or P26 as UART output pin and P91 or P27 as UART input pin 1: set P91 or P27 as UART output pin and P90 or P26 as UART input pin

//====== enable function ======
    POFFCR1_UART1EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
	UART1CR1_PE		= 0;				// no parity
	UART1CR1_STOPBT	= 0;				// transmit stop bit length : 1 bit
	UART1CR2_STOPBR	= 0;				// receive stop bit length : 1 bit
	UART1CR1_BRG	= 0;				// 0: transfer base clock selection = fcgck
										// 1: transfer base clock selection = TCA0 output

//------ Baud rate = 9600
//--- fcgck @ 16MHz
/* 
    UART1CR2_RTSEL = 0x01;
    UART1DR        = 0x64;
 */	
//--- fcgck @ 8MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x30;
 */
//--- fcgck @ 4MHz

    UART1CR2_RTSEL = 0x00;
    UART1DR        = 0x19;
	
//--- fcgck @ 2MHz
/* 
    UART1CR2_RTSEL = 0x00;
    UART1DR        = 0x0c;
 */

//------ Baud rate = 115200
//--- fcgck @ 16MHz
/* 
    UART1CR2_RTSEL = 0x03;
    UART1DR        = 0x08;
 */
//--- fcgck @ 8MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x03;
 */
//--- fcgck @ 4MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x01;
 */
//--- fcgck @ 2MHz
/* 
    UART1CR2_RTSEL = 0x04;
    UART1DR        = 0x00;
 */

}


//*********************************************************************
// name			: UART1_Start
// brief		: start UART
// note			:
//*********************************************************************
void UART1_Start(void)
{
    UART1CR1_TXE = 1;                   // enable TX
    UART1CR1_RXE = 1;                   // enable RX
}


//*********************************************************************
// name			: UART1_Stop
// brief		: stop UART
// note			:
//*********************************************************************
void UART1_Stop(void)
{
    UART1CR1_TXE = 0;                   // disable TX
    UART1CR1_RXE = 0;                   // disable RX
}


//*********************************************************************
// name			: UART1_IntEnable
// brief		: enable UART interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void UART1_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts 
/* 	
    IL_INTTXD1      = 0;                // clear TX interrupt latch
    EI_INTTXD1      = 1;                // enable TX interrupt
 */	
    IL_INTRXD1      = 0;                // clear RX interrupt latch
    EI_INTRXD1      = 1;                // enable RX interrupt
    EI;                                 // enable all maskable interrupts 
}


//*********************************************************************
// name			: UART1_IntDisable
// brief		: disable UART interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void UART1_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts 
/* 	
    EI_INTTXD1      = 0;                // disable TX interrupt
	IL_INTTXD1      = 0;                // clear TX interrupt latch    
 */	
    EI_INTRXD1      = 0;                // disable RX interrupt
	IL_INTRXD1      = 0;                // clear RX interrupt latch    
    EI;                                 // enable all maskable interrupts 
}



//*********************************************************************
// name			: IntRXD1
// brief		: RXD1 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntRXD1(void)
{
	uart1_status = UART1SR;             // get flag data [PERR, FERR, OERR, -, RBSY, RBFL, TBSY, TBFL]
                                        // PERR    parity error flag      0: no parity error
                                        //                            1: parity error
                                        // RFERR   framing error flag        0: no framing error
                                        //                            1: framing error
                                        // OERR    overrun error flag          0: no overrun error
                                        //                            1: overrun error
                                        // RBSY    receive busy flag          0: before receiving or end of receiving
                                        //                            1: on receiving
                                        // RBFL    receive buffer full flag     0: receive buffer empty
                                        //                            1: receive buffer full
                                        // TBSY    transmit busy flag          0: before transmission or end of transmission
                                        //                            1: on transmitting
                                        // TBFL    transmit buffer full flag     0: transmit buffer empty
                                        //                            1: transmit buffer full

	rx1_data = RD1BUF;                  // get Rx data and clear UART1SR flag

    if( flowFlag == PKG_WAIT_RCV ){		// if the current state is 0x00(PKG_WAIT_RCV) and the RX data is 0x55(PKG_RCV),
    	if( (rx1_data == PKG_RCV) ){	// then set the state to 0x55(PKG_RCV)
			rcv_cnt = 0;
    		flowFlag = PKG_RCV;         
    	}
    }
    else if( flowFlag == PKG_RCV ){		// if the current state is PKG_RCV, store the RX data to rx1_buf[].
        rx1_buf[rcv_cnt] = rx1_data;
    	rcv_cnt++;

    	if( rcv_cnt >= RCV_MAX ){
    	    rcv_cnt  = 0;
    		flowFlag = PKG_SEND;        // after receiving the specified number of data, set the status to PKG_SEND
    	}
    }
}





//*********************************************************************
// name			: UART1_SendData
// brief		: UART1 sends multi-bytes data
// note			:
//*********************************************************************
void UART1_SendData(const uchar * buf,uint length)
{
    uint sendloop;

    for( sendloop = 0; sendloop < length; sendloop++ ){
        while( UART1SR_TBFL ){          // wait for buffer empty        
            CLR_WDT;                    // clear the watchdog timer
        }
        TD1BUF = buf[sendloop];
    }

    while( UART1SR_TBSY ){               // wait for end of transmission
        CLR_WDT;                        // clear the watchdog timer
    }
}























