//******************************************
//  : main
// 汾     : V1.1 02/24/2021 MQ6812
//      : ͷļ
// ע     : ֮ͷļԼдĵ
//******************************************
#ifndef _INCLUDES_H__
#define _INCLUDES_H__

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "MQ6812_SFR.h"    // ⹦ܼĴλԪϸ
#include "MQ6812_TC0.h"


//****************************************************
//   C ԶƵķʽֵ **********************
//****************************************************
#define Define2Bin(n)        \
(                            \
    ( ( n >> 21 ) & 0x80 ) | \
    ( ( n >> 18 ) & 0x40 ) | \
    ( ( n >> 15 ) & 0x20 ) | \
    ( ( n >> 12 ) & 0x10 ) | \
    ( ( n >>  9 ) & 0x08 ) | \
    ( ( n >>  6 ) & 0x04 ) | \
    ( ( n >>  3 ) & 0x02 ) | \
    ( ( n       ) & 0x01 )   \
)
#define set8bit(n)  Define2Bin(0x##n##L)
//  Ｔöдֵ
//  tempVAR = set8bit(10101010);   <==>   temp = 0xAA;
//****************************************************


//*******************************************************************************
//  ֻռһλԪλԪ (bit) С *************************************
//  עԴ˷ʽ bit Ϊλ֮޷ IDE ֮ watch Ӵ鿴ֵ
//        ֻܲ鿴 Byte ֮磺_flag_8bit
//*******************************************************************************
extern  BIT_LIST_8  _flag_8bit;

#define flag_8bit   _flag_8bit.byte
#define flag_7      _flag_8bit.bit.b7
//#define flag_6      _flag_8bit.bit.b6
//#define flag_5      _flag_8bit.bit.b5
//#define flag_4      _flag_8bit.bit.b4
#define flag_6_4    _flag_8bit.b6_4.b6_4  // ռ 3  bit ֮
#define flag_3      _flag_8bit.bit.b3
#define flag_2      _flag_8bit.bit.b2
//#define flag_1      _flag_8bit.bit.b1
//#define flag_0      _flag_8bit.bit.b0
#define flag_1_0    _flag_8bit.b1_0.b1_0  // ռ 2  bit ֮


//*******************************************************************************
//   BIT_LIST_16 ֻ֮ܶռһλԪ (bit) С ********************
//  עԴ˷ʽ bit Ϊλ֮޷ IDE ֮ watch Ӵ鿴ֵ
//        ֻܲ鿴 Byte ֮磺_flag_16bit
//*******************************************************************************
extern  BIT_LIST_16 _flag_16bit;

#define flag_16bit  _flag_16bit.word
#define flag_15     _flag_16bit.bit.b15
#define flag_14     _flag_16bit.bit.b14
#define flag_13     _flag_16bit.bit.b13
#define flag_12     _flag_16bit.bit.b12
#define flag_11     _flag_16bit.bit.b11
#define flag_10     _flag_16bit.bit.b10
#define flag_09     _flag_16bit.bit.b9
#define flag_08     _flag_16bit.bit.b8
#define flag_07     _flag_16bit.bit.b7
#define flag_06     _flag_16bit.bit.b6
#define flag_05     _flag_16bit.bit.b5
#define flag_04     _flag_16bit.bit.b4
#define flag_03     _flag_16bit.bit.b3
#define flag_02     _flag_16bit.bit.b2
#define flag_01     _flag_16bit.bit.b1
#define flag_00     _flag_16bit.bit.b0


//****************************************************
#define BIT0  0x0001
#define BIT1  0x0002
#define BIT2  0x0004
#define BIT3  0x0008
#define BIT4  0x0010
#define BIT5  0x0020
#define BIT6  0x0040
#define BIT7  0x0080
#define BIT8  0x0100
#define BIT9  0x0200
#define BIT10 0x0400
#define BIT11 0x0800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000

#define M_SET(n,c)  ((n) |=  (c))
#define M_CLR(n,c)  ((n) &= ~(c))

 


//****************************************************
//  Delay_Times(t_1ms, 800);            //  Normal mode, Slow mode
void Delay_Times(uchar tBase, uint x);  //  Normal mode, Slow mode
//...................|...........| x: 趨ӳʱ
//...................| tBase: 趨ӳٵλ: t_1ms/t_100us ...
#define t_1ms   0
#define t_100us 1




/* ---------------------- startup  ------------------------ */
extern void STARTUP(void);

/* ---------------------- ****** ****** ****** ------------------------ */
void System_Init(void);


/* ---------------------- ****** ****** ****** ------------------------ */




/*********************************************
****** ģʽת֮ʹע ******
**********************************************
//  --------:----------------------------------------------------------
//  ģʽл̣
//  Normal1	--> Normal2 --> SLOW2 --> SLOW1
//  SLOW1 --> SLOW2 --> Normal2 --> Normal1
//  --------:----------------------------------------------------------
//*********************************************************************
//          : Each Mode Switch Sequence
//  Normal1 :----------------------------------------------------------
//          : --> Normal1
//          : --> IDLE0(ֻ "TBTʱж" ѻص Normal1
//          : --> IDLE1( "ж"      ѻص Normal1
//          : --> STOP (ֻ "KWIѽ"     ѻص Normal1
//  Normal2 :----------------------------------------------------------
//          : --> Normal2
//          : --> IDLE2( "ж"      ѻص Normal2
//          : --> STOP (ֻ "KWIѽ"     ѻص Normal2
//  SLOW2   :----------------------------------------------------------
//          : --> SLOW2
//  SLOW1   :----------------------------------------------------------
//          : --> SLOW1
//          : --> SLEEP0(ֻ "TBTʱж" ѻص SLOW1
//          : --> SLEEP1( "ж"      ѻص SLOW1
//          : --> STOP  (ֻ "KWIѽ"     ѻص SLOW1
//  --------:----------------------------------------------------------
**********************************************************************/


//          |........................................................................................
//          |---------> // ע:
//          |---------> // 1. Enable LXtal: 趨 FSCTRL_FSSEL = 1; --> FSCTRLʹõλԪ(bit operation)
//          |---------> // 2. ⲿ¼ʱ, 乴ѡ ext low OSC:
//          |---------> //    IDE¼   : Project -> Pin Setting -> ѡ ext low OSC
//          |---------> //    Writer¼: ѡType -> IC typeѡͬһҳҷ -> ѡ ext low OSC
//          .........................................................................................
//--------------------------------------------------------------------------------------------------//

#define ENTRY_IDLE0     SYSCR2_TGHALT = 1       // TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode
#define ENTRY_SLEEP0    SYSCR2_TGHALT = 1       // TGHALT: (Normal1->IDLE0) / (SLOW1->SLEEP0) mode

#define ENTRY_IDLE1     SYSCR2_IDLE   = 1       // IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
#define ENTRY_IDLE2     SYSCR2_IDLE   = 1       // IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode
#define ENTRY_SLEEP1    SYSCR2_IDLE   = 1       // IDLE: (Normal1->IDLE1) / (Normal2->IDLE2) / (SLOW1->SLEEP1) mode

#define ENTRY_STOP  {   SYSCR1_OUTEN  = 1; SYSCR1_RELM = 1; SYSCR1_STOP = 1; }
                    //  SYSCR1_OUTEN  = 1;      // OUTEN=1,  STOP ģʽйܽŽԭ״̬
                    //                          //  STOP ģʽעλܸ, ĩʹýλ趨Ϊλ,
                    //                          // λӻδ֪©
                    //  SYSCR1_RELM   = 1;      // RELM=1, õƽ׼λ STOP ģʽ
                    //  SYSCR1_STOP   = 1;      //  STOP ģʽ
//--------------------------------------------------------------------------------------------------//




#endif //#ifndef _INCLUDES_H__
