//******************************************
// file			: MQ6812_TBT
// version		: V1.0
// brief		:  TBTʹú
// note			:
//******************************************

#include "main.h"

//*********************************************************************
// name			: TBT_Init
// brief		: TBT initialization
// note			:
//*********************************************************************
void TBT_Init(void)
{
//====== parameter setting ======
    TBTCR_TBTCK   = 6;                  // TBT interrupt Frequency = 3906.25 Hz   
                                        //                         (fcgck / 2^10)                                       
    NOP;                                // no operation
}


//*********************************************************************
// name			: TBT_Start
// brief		: start TBT
// note			:
//*********************************************************************
void TBT_Start(void)
{
    TBTCR_TBTEN   = 1;
}


//*********************************************************************
// name			: TBT_Stop
// brief		: stop TBT
// note			:
//*********************************************************************
void TBT_Stop(void)
{
    TBTCR_TBTEN   = 0;
}


//*********************************************************************
// name			: TBT_IntEnable
// brief		: enable TBT interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TBT_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTBT  = 0;                     // clear interrupt latch
    EI_INTTBT  = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: TBT_IntDisable
// brief		: TBT жϳ
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TBT_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTTBT  = 0;                     // clear interrupt enable flag
    IL_INTTBT  = 0;                     // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: IntTBT
// brief		: TBT interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTBT(void)
{
    P9DR_P0 =!P9DR_P0;
    NOP;                                // no operation
}


























