//******************************************
// file			: MQ6812_DVOB
// version		: V 1.0
// brief		: DVOB related functions
// note			: DVOB related functions are gathered in this subroutine
//******************************************

#include "main.h"

//*********************************************************************
// name			: DVOB_Init
// brief		: DVOB initialization
// note			:
//*********************************************************************
void DVOB_Init(void)
{
//====== parameter setting ======
    P7CR_P4       = 1;    
    P7FC_P4       = 1;                  // set P74 as special function pin
    DVOCR_DVOCK   = 2;                  // set DVOB output frequency to 3906.25 Hz   
                                        //                (fcgck / 2^10)                                       
    NOP;                                // no operation
}


//*********************************************************************
// name			: DVOB_Start
// brief		: start DVOB
// note			:
//*********************************************************************
void DVOB_Start(void)
{
    DVOCR_DVOEN   = 1;
}


//*********************************************************************
// name			: DVOB_Stop
// brief		: stop DVOB
// note			:
//*********************************************************************
void DVOB_Stop(void)
{
    DVOCR_DVOEN   = 0;                  // when DVOB is stopped, P74 output level is high
}


























