//******************************************
// file			: MQ6812_ADC.h
// version		: V1.0
// brief		: ADC header file
// note			:
//******************************************
#ifndef _MQ6812_ADC_H_
#define _MQ6812_ADC_H_



#define     AD_TIMES       16

/******************
 * 1st Argument
 * ****************/
#define     ADC_SINGLE      0x1 // single mode
#define     ADC_REPEAT      0x3 // repeat mode
/******************
 * 2nd Argument
 * ****************/
#define     AIN_DIS         0x0 // analog input disable
#define     AIN_EN          0x1 // analog input enable
/******************
 * 3rd Argument
 * ****************/
#define     AIN0            0x0 // set analog input channel to AIN0
#define     AIN1            0x1 // set analog input channel to AIN1
#define     AIN2            0x2 // set analog input channel to AIN2
#define     AIN3            0x3 // set analog input channel to AIN3
#define     AIN4            0x4 // set analog input channel to AIN4
#define     AIN5            0x5 // set analog input channel to AIN5
#define     AIN6            0x6 // set analog input channel to AIN6
#define     AIN7            0x7 // set analog input channel to AIN7
#define     AIN8            0x8 // set analog input channel to AIN8
#define     VDD4_1          0x9 // set analog input channel to internal 1/4 VDD input
#define     AIN_GND         0xc // set analog input channel to internal ground
#define     AIN13           0xd // set analog input channel to AIN13
#define     AIN14           0xe // set analog input channel to AIN14
#define     AIN15           0xf // set analog input channel to AIN15
/******************
 * 4th Argument
 * ****************/
// fcgck=16M... CONV256CLK(16us) ~ CONV1024CLK( 64us)
// fcgck= 8M... CONV128CLK(16us) ~ CONV1024CLK(128us)
// fcgck= 4M... CONV64CLK (16us) ~ CONV512CLK (128us)
// fcgck= 2M... CONV32CLK (16us) ~ CONV256CLK (128us)
#define     CONV32CLK       0x0 // set conversion times to 32 fcgck
#define     CONV64CLK       0x1 // set conversion times to 64 fcgck
#define     CONV128CLK      0x2 // set conversion times to 128 fcgck
#define     CONV256CLK      0x3 // set conversion times to 256 fcgck
#define     CONV512CLK      0x4 // set conversion times to 512 fcgck
#define     CONV1024CLK     0x5 // set conversion times to 1024 fcgck
                                // (*conversion times must be between 12.8 us to 128 us)
/******************
 * 5th Argument
 * ****************/
#define     VREF2           0x0 // set ADC reference voltage to internal 2V
#define     VREF3           0x1 // set ADC reference voltage to internal 3V
#define     VREF4           0x2 // set ADC reference voltage to internal 4V
#define     VDDVREF         0x3 // set ADC reference voltage to internal VDD
#define     EXTVREF         0x4 // set ADC reference voltage to external voltage (AIN3)
								// when AIN3 is used as the external voltage input, AIN3 cannot be used to analog input





extern uint  vref_l, vref_h, iReal_Vref2V, ADC_Code_READ;



void ADC_Init();
void ADC_Start(void);
void ADC_Stop(void);
void ADC_IntEnable(void);
void ADC_IntDisable(void);

uint GetVref(void);
uint ADC_SingleDetect(uchar SAIN);
uint ADC_RepeatDetect(uchar SAIN);

void __interrupt IntADC(void);






#endif








