//******************************************
// file			: MQ6812_TC0
// version		: V1.0
// brief		: 8-bit TC0 related functions
// note			: 8-bit TC0 related functions are gathered in this subroutine
//******************************************

#include "main.h"




//*********************************************************************
// name			: TC00_Timer_Init
// brief		: TC00 10-bit timer mode initialization (set period to 100us)
// note			:
//*********************************************************************
void TC00_Timer_Init(void)
{
//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T00MOD_TCM      = 0;                // set operation mode to 8-bit timer/event counter modes
    T00MOD_TCK      = 5;                // fcgck/4 = 1MHz = 1us
    T00MOD_DBE      = 1;                // enable double buffer
    T00REGL         = 100;              // set counter value to 100
	T00REGH_T00REGH = 0x00;
}


//*********************************************************************
// name			: TC00_PPG_Init
// brief		: TC00 10-bit PPG mode initialization (set period to 100us and duty cycle to 50%)
// note			:
//*********************************************************************
void TC00_PPG_Init(void)
{
//====== pin configuration ======
    P7DR_P0         = 1;                // set P70 to output high (suggest output level as the same as the value of T0xMOD_TFF)
    P7CR_P0         = 1;                // set P70 as output pin

//====== enable function ======
    POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work

//====== parameter setting ======
    T00MOD_TFF      = 1;                // set initial state of function pin to high
//	set function pins after function initialization
    P7FC_P0         = 1;                // set P70 as PPG function pin

    T00MOD_TCM      = 3;                // set operation mode to 8-bit PPG mode
    T00MOD_TCK      = 5;                // fcgck/4 = 1MHz = 1us
    T00MOD_DBE      = 1;                // enable double buffer

    T00REGL          = 100;              // set PPG period = 100us
	T00REGH_T00REGH  = 0;
	
    T00PWML          = 50;               // set PPG duty cycle = 50/100 = 50%
	T00PWMH_T00PWMH  = 0;
}


//*********************************************************************
// name			: T001_PPG_Comp
// brief		: TC001 10-bit complementary output mode initialization
// note			:
//*********************************************************************
void T001_PPG_Comp_Init(void)
{
//====== pin configuration ======

    P7CR_P0	=1;			//set P70 output
	P7FC_P0	=1;			//set P70 function mode
	P7CR_P1	=1;			//set P71 output
	P7FC_P1	=1;			//set P71 function mode
	
	POFFCR0_TC001EN = 1;                // this register must be enable first and then the related registers settings will work
	T001CR_COMPSL   = 1;                // select complementary output setting
	
	T00MOD          =0x3A;				//0xFA;		//[TFF0,DBE0,TCK0[3],-,TCM0]
										//<DBE0>=1,<TCK0>=111,<TCM0>=10 10-bit PWM mode

    T01MOD          =0x3A;				//[TFF0,-,TCK0[3],-,TCM0]
										//<TCK>=111,<TCM>=10 10-bit PWM mode
			
	T01MOD_TFF = 1;       //set initial state of function pin to high
							
	T00REGL = 0x60;	 		//set timer value
	T00REGH = 0x05;			//set timer value = 0x0560
		
	T00PWML = 0x00;	 		//set timer value
	T00PWMH = 0x02; 		//set timer value = 0x0200
	
	T01REGL = 0x58;	 		//set timer value
	T01REGH = 0x05;			//set timer value = 0x0558
		
	T01PWML = 0xE0;	 		//set timer value
	T01PWMH = 0x01; 		//set timer value = 0x01E0
	
}

//*********************************************************************
// name			: T001_Comp_Start
// brief		: start TC00
// note			:
//*********************************************************************
void T001_Comp_Start(void)
{
	T001CR_T00RUN =1; 		//[-,-,-,COMPSL	  OUTAND,-,T01RUN,T00RUN]
							//start TCQ00   
	T001CR_T01RUN =1; 						
}

//*********************************************************************
// name			: TC00_SetDuty
// brief		: set duty cycle
// note			: duty cycle : T00PWM/T00REG    (10-bit PPG mode)
//                 : (T00PWM/2) / 128 (10-bit PWM mode
//*********************************************************************
void TC00_SetDuty(uint duty)
{
    T00PWML          = (duty & 0xFF);
	T00PWMH_T00PWMH  = (duty >> 8); 
}

//*********************************************************************
// name			: TC00_SetPeriod
// brief		: set period
// note			: 
//*********************************************************************
void TC00_SetPeriod(uchar period)
{
    T00REGL          = (period & 0xFF);
	T00REGH_T00REGH  = (period >> 8);
}

//*********************************************************************
// name			: TC00_Start
// brief		: start TC00
// note			:
//*********************************************************************
void TC00_Start(void)
{
    T001CR_T00RUN   = 1;                
}


//*********************************************************************
// name			: TC00_Stop
// brief		: stop TC00
// note			:
//*********************************************************************
void TC00_Stop(void)
{
    T001CR_T00RUN   = 0;                
}


//*********************************************************************
// name			: TC00_IntEnable
// brief		: enable TC00 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TC00_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTC00      = 0;                // clear interrupt latch
    EI_INTTC00      = 1;                // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: TC00_IntDisable
// brief		: disable TC00 interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TC00_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTTC00      = 0;                // clear interrupt enable flag
	IL_INTTC00      = 0;                // clear interrupt latch    
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}



//*********************************************************************
// name			: IntTC00
// brief		: interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTC00(void)
{    
	P9DR_P0 = !P9DR_P0;
    NOP;                                // no operation
}





























