//******************************************
//  : MQ6812_TC0
// 汾     : V1.1 02/24/2021 MQ6812
//      : TC0ʹú
// ע     :
//******************************************

#include "main.h"




//*********************************************************************
//    : TC00_Timer_Init
//  : TC00 10λrģʽr100us
// ע     :
//*********************************************************************
void TC00_Timer_Init(void)
{
//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T00MOD_TCM      = 0;                // 趨Ϊ 8 λʱģʽ
    T00MOD_TCK      = 5;                // fcgck/4 = 1MHz = 1us
    T00MOD_DBE      = 1;                // ʹ˫
    T00REGL         = 100;              // 趨ֵ: ÿ 100 * 1us жһ
	T00REGH_T00REGH = 0x00;
}


//*********************************************************************
//    : TC00_PPG_Init
//  : TC00 10λPPGģʽL100usռձ50%
// ע     :
//*********************************************************************
void TC00_PPG_Init(void)
{
//====== ܽųʼ ======
    P7DR_P0         = 1;                // ܽʼͬ PPG ĳʼֵ(T0xMOD_TFF)
    P7CR_P0         = 1;                // ܽ趨Ϊ

//====== ܿ( Enable) ======
    POFFCR0_TC001EN = 1;                // ȿݴò

//====== 趨 ======
    T00MOD_TFF      = 1;                // 趨ʼֵΪ׼λռձ
//	PxFC ùţڳʼֵ趨֮ PxFC
    P7FC_P0         = 1;                // ܽ趨Ϊ PPG 

    T00MOD_TCM      = 3;                // 趨Ϊ 8 λɱ PPG ģʽ
    T00MOD_TCK      = 5;                // fcgck/4 = 1MHz = 1us
    T00MOD_DBE      = 1;                // ʹ˫

    T00REGL          = 100;              // 趨 PPG  = 100us
	T00REGH_T00REGH  = 0;
	
    T00PWML          = 50;               // 趨 PPG ռձ = 50/100 = 50%
	T00PWMH_T00PWMH  = 0;
}


//*********************************************************************
//    : T001_PPG_Comp
//  : T001 10λģʽ
// ע     :
//*********************************************************************
void T001_PPG_Comp_Init(void)
{
//====== ܽųʼ ======

    P7CR_P0	=1;			//set P70 output
	P7FC_P0	=1;			//set P70 function mode
	P7CR_P1	=1;			//set P71 output
	P7FC_P1	=1;			//set P71 function mode
	
	POFFCR0_TC001EN = 1;                // ȿݴò
	T001CR_COMPSL   = 1;                //ѡʱ00/01 ʽ趨
	
	T00MOD          =0x3A;				//0xFA;		//[TFF0,DBE0,TCK0[3],-,TCM0]
										//<DBE0>=1,<TCK0>=111,<TCM0>=10 10λPWMģʽ

    T01MOD          =0x3A;				//[TFF0,-,TCK0[3],-,TCM0]
										//<TCK>=111,<TCM>=10 10λPWMģʽ
			
	T01MOD_TFF = 1;       //ģʽ趨PPG00B ŵĳʼ״̬Ϊߵƽ
							
	T00REGL = 0x60;	 		//OӋrֵ
	T00REGH = 0x05;			//OӋrֵ = 0x0560
		
	T00PWML = 0x00;	 		//OӋrֵ
	T00PWMH = 0x02; 		//OӋrֵ = 0x0200
	
	T01REGL = 0x58;	 		//OӋrֵ
	T01REGH = 0x05;			//OӋrֵ = 0x0558
		
	T01PWML = 0xE0;	 		//OӋrֵ
	T01PWMH = 0x01; 		//OӋrֵ = 0x01E0
	
}

//*********************************************************************
//    : T001_Comp_Start
//  : TC00
// ע     :
//*********************************************************************
void T001_Comp_Start(void)
{
	T001CR_T00RUN =1; 		//[-,-,-,COMPSL	  OUTAND,-,T01RUN,T00RUN]
							//TCQ00   
	T001CR_T01RUN =1; 						
}

//*********************************************************************
//    : TC00_SetDuty
//  : O}Ӌֵ
// ע     : ռձ : T00PWM/T00REG    (10λPPGģʽ)
//                 : (T00PWM/2) / 128 (10λPWMģʽ
//*********************************************************************
void TC00_SetDuty(uint duty)
{
    T00PWML          = (duty & 0xFF);
	T00PWMH_T00PWMH  = (duty >> 8); 
}

//*********************************************************************
//    : TC00_SetPeriod
//  : OLӋֵ
// ע     : 
//*********************************************************************
void TC00_SetPeriod(uchar period)
{
    T00REGL          = (period & 0xFF);
	T00REGH_T00REGH  = (period >> 8);
}

//*********************************************************************
//    : TC00_Start
//  : TC00
// ע     :
//*********************************************************************
void TC00_Start(void)
{
    T001CR_T00RUN   = 1;                // ʱ
}


//*********************************************************************
//    : TC00_Stop
//  : ֹͣTC00
// ע     :
//*********************************************************************
void TC00_Stop(void)
{
    T001CR_T00RUN   = 0;                // ֹͣʱ
}


//*********************************************************************
//    : TC00_IntEnable
//  : TC00ж
// ע     : ִкῪж(IMF)
//*********************************************************************
void TC00_IntEnable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    IL_INTTC00      = 0;                // ж
    EI_INTTC00      = 1;                // 趨ж
    EI;                                 // пж // EIRL_IMF=1
}



//*********************************************************************
//    : TC00_IntDisable
//  : ֹTC00ж
// ע     : ִкῪж(IMF)
//*********************************************************************
void TC00_IntDisable(void)
{
    DI;                                 // ֹпж // EIRL_IMF=0
    EI_INTTC00      = 0;                // ж
	IL_INTTC00      = 0;                // ж    
    EI;                                 // пж // EIRL_IMF=1
}



//*********************************************************************
//    : IntTC00
//  : жϸʽ
// ע     :
//*********************************************************************
void __interrupt IntTC00(void)
{    
	P9DR_P0 = !P9DR_P0;
    NOP;                                // ָ
}





























