//******************************************
//  ƣ MQ6812_startup.c
//  汾     V1.0
//       
//  ע    
//******************************************
//******************************************
//******************************************
/*
 * --------------------------------------------------------------------------
 *   HEADER INCLUDE DEFINITIONS
 * --------------------------------------------------------------------------
 */
#include <stdlib.h>
#include "MQ6812_SFR.h"                     // ⹦ܼĴλԪϸ

/*
 * --------------------------------------------------------------------------
 *   MACRO DEFINITIONS
 * --------------------------------------------------------------------------
 */
extern unsigned int  _BaseSP;				/*ѯBָʼַһ㶨xSRAMһַ*/
extern unsigned int  _RAM_Top;				/*SRAMĵһַ*/
extern unsigned int  _RAM_End;				/*SRAMһַ*/

extern unsigned char _TDataAddr[];			/* for tiny_data initialize, defined in link command file  */
extern unsigned char _TDataOrg[];			/* for tiny_data initialize, defined in link command file  */
extern unsigned int  _TDataSize;			/* for tiny_data initialize, defined in link command file  */
extern unsigned char _NDataAddr[];			/* for near_data initialize, defined in link command file  */
extern unsigned char _NDataOrg[];			/* for near_data initialize, defined in link command file  */
extern unsigned int  _NDataSize;			/* for near_data initialize, defined in link command file  */

/*
 * --------------------------------------------------------------------------
 *   FUNCTION DECLARATIONS
 * --------------------------------------------------------------------------
 */

/*#**************************************************************************#*/

/*
 ******************************************************************************
 * NAME				:STARTUP
 *-----------------------------------------------------------------------------
 * DESCRIPTION		:Startup routine
 * PARAMETER		:-
 *
 * RETURN VALUE		:-
 *
 ******************************************************************************
 */
void STARTUP( void )
{
//=============================================================================
//  disable interrupt
//=============================================================================
    DI;                                 // ֹпж // EIRL_IMF=0


//=============================================================================
//  initial Registers
//=============================================================================
    __WA = 0x00;
    __BC = 0x00;
    __DE = 0x00;
    __HL = 0x00;
    __IX = 0x00;
    __IY = 0x00;

//=============================================================================
//  initialize stack pointer
//=============================================================================
    __asm(" LD SP,__BaseSP");       //initialize stack pointer

//=============================================================================
//  clear status word
//=============================================================================
    __asm(" LD PSW,0x00");

//=============================================================================
//  clear RAM
//=============================================================================
    __asm(" LD HL,__RAM_Top");
    __asm(" LD BC,__RAM_End - __RAM_Top");
    __asm(" LD A,0x00");
    __asm("CLR_RAM:");
    __asm(" LD (HL),A");
    __asm(" INC HL");
    __asm(" DEC BC");
    __asm(" JRS F,CLR_RAM");        // Clear the RAM

//=============================================================================
//  initialize of tiny_data section
//=============================================================================
    __asm("	LD	IX,__TDataOrg");
    __asm("	LD	IY,__TDataAddr");
    __asm("	LD	A,__TDataSize");
    __asm("	DEC	A");
    __asm("	J	T,non_t_data");
    __asm("move_t_data:");
    __asm("	LD	C,(IX)");
    __asm("	LD	(IY),C");
    __asm("	INC	IX");
    __asm("	INC	IY");
    __asm("	DEC	A");
    __asm("	J	F,move_t_data");
    __asm("non_t_data:");

//=============================================================================
//  initialize of near_data section
//=============================================================================
    __asm("	LD	IX,__NDataOrg");
    __asm("	LD	IY,__NDataAddr");
    __asm("	LD	WA,__NDataSize");
    __asm("	DEC	WA");
    __asm("	J	T,non_n_data");
    __asm("move_n_data:");
    __asm("	LD	C,(IX)");
    __asm("	LD	(IY),C");
    __asm("	INC	IX");
    __asm("	INC	IY");
    __asm("	DEC	WA");
    __asm("	J	F,move_n_data");
    __asm("non_n_data:");

//=============================================================================
//Set UnPad Pin normal output LOW to avoid leakage
//=============================================================================
    P2DR &= 0x1F;	//;P25~P27 output low
   	P7DR &= 0x7F;	//;P77 output low
	
    P2CR |= 0xE0;	//;P25~P27 output 
    P7CR |= 0x80;	//;P77 output
	
//=============================================================================
//  jump to main
//=============================================================================
	main();
	for (;;) {
		;
	}
}

