//******************************************
// file			: MQ6812_RTC
// version		: V1.0
// brief		: RTC related functions
// note			: RTC related functions are gathered in this subroutine
//******************************************

#include "main.h"

//*********************************************************************
// name			: RTC_Init
// brief		: RTC initialization
// note			:
//*********************************************************************
void RTC_Init(void)
{
//====== parameter setting ======
    POFFCR2_RTCEN  = 1;
    RTCCR_RTCSEL  = 0;                  // RTC interrupt frequency = 1 Hz   
                                        //        period = 1 s    
    NOP;                                // no operation
}


//*********************************************************************
// name			: RTC_Start
// brief		: start RTC
// note			:
//*********************************************************************
void RTC_Start(void)
{
    RTCCR_RTCRUN   = 1;
}


//*********************************************************************
// name			: RTC_Stop
// brief		: stop RTC
// note			:
//*********************************************************************
void RTC_Stop(void)
{
    RTCCR_RTCRUN   = 0;
}


//*********************************************************************
// name			: RTC_IntEnable
// brief		: enable RTC interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void RTC_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTRTC  = 0;                     // clear interrupt latch
    EI_INTRTC  = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: RTC_IntDisable
// brief		: disable RTC interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void RTC_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTRTC  = 0;                     // clear interrupt enable flag
    IL_INTRTC  = 0;                     // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: IntRTC
// brief		: RTC interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntRTC(void)
{
    P9DR_P0 =!P9DR_P0;
    NOP;                                // no operation
    NOP;
    NOP;
}


























