//*********************************************************************
// file			: LVD_Init
// brief		: LVD related setting, set VD2 to 2.00V+/- 0.1V and trigger reset after detection
// note			: this function waits in a loop until the system has stabilized before completing the setup
//*********************************************************************

#include "main.h"


void LVD_Init(){	
    VDCR1_VD2LVL 	= 3;                // 0: 2.85V +/- 0.15V
                                        // 1: 2.65V +/- 0.15V
                                        // 2: 2.35V +/- 0.15V
                                        // 3: 2.00V +/- 0.15V
                        
	// set to generate a interrupt signal first and wait for the system to stabilize before setting to generate a reset signal												
    VDCR2_VD2MOD 	= 0;				// set VD2 to gernerate a interrupt signal
	EI_INTLVD 	 	= 0;				// disable LVD interrupt
	IL_INTLVD 	 	= 0;				// clear LVD interrupt flag	
	VDCR2_VD2EN  	= 1; 				// enable VD2	
	Delay_Times(t_100us,1);				// 100us delay ensures system stability	
	while(IL_INTLVD == 1){				 
		CLR_WDT;
		IL_INTLVD	= 0;
	}	
	VDCR1_VD2F      = 0;				// clear VD2F
	// ---
	
	// selects the operation mode of voltage to generates a voltage detection reset signal
	VDCR2_VD2MOD	= 1;				// 0 : Generates a voltage detection interrupt request signal
                                        // 1 : Generates a voltage detection reset signal
										
}
//*********************************************************************
// file			: LVD_IntEnable
// brief		: enable LVD interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void LVD_IntEnable(){   
    DI;
    IL_INTLVD = 0;                      // clear LVD interrupt flag
    EI_INTLVD = 1;                      // enable LVD interrupt
    EI; 
}
//*********************************************************************
// file			: LVD_IntDisable
// brief		: disable LVD interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void LVD_IntDisable(){  
    DI;
    EI_INTLVD = 0;                      // disable LVD interrupt
    IL_INTLVD = 0;                      // clear LVD interrupt flag    
    EI; 
}


//*********************************************************************
// file			: LVD_Stop
// brief		: disable LVD
// note			: 
//*********************************************************************
void LVD_Stop(){
    VDCR2_VD2EN = 0;                    
}

//*********************************************************************
// file			: __interrupt IntVLTD
// brief		: LVD interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntVLTD(void){    
    NOP;
}
