//******************************************
// file			: MQ6812_LCD
// version		: V 1.0
// brief		: LCD related functions
// note			: LCD related functions are gathered in this subroutine
//******************************************

#include "main.h"


const uchar DIG_CODE_fge[16]={  0x05, 0x00, 0x06, 0x02, 0x03, 0x03, 0x07, 0x01,
								0x07, 0x03, 0x07, 0x07, 0x05, 0x06, 0x07, 0x07 };

const uchar DIG_CODE_abcd[16]={	0x0F, 0x06, 0x0B, 0x0F, 0x06, 0x0D, 0x0D, 0x07,
								0x0F, 0x0F, 0x07, 0x0C, 0x09, 0x0E, 0x09, 0x01 };


//*********************************************************************
// name			: LCD_Init
// brief		: LCD initialization
// note			:
//*********************************************************************
void LCD_Init(void)
{
//====== enable function ======
    POFFCR2_LCDEN = 1;

//====== parameter setting ======
    LCDCR1_DUTY   = 0x05;               //0x05: 1/8 duty1/4 bias
                                        //0x06: 1/8 duty1/3 bias
                                        //0x07: 1/8 duty1/2 bias
    LCDCR1_SLF    = 0x03;               // Fcgck/2^15
    LCDCR2_LDRS   = 1;

    LCDCR3 = 0xf0;                      // Enable SEG_EN[7:4]    
	LCDCR4 = 0x0f;                      // Enable SEG_EN[11:8]    
    LCDCR5 = 0xff;                      // Enable COM_EN[7: 0]
    
    
}


//*********************************************************************
// name			: LCD_Start
// brief		: start LCD
// note			:
//*********************************************************************
void LCD_Start(void)
{
    LCDCR1_EDSP = 1;
}


//*********************************************************************
// name			: LCD_Stop
// brief		: stop LCD
// note			: before entering the STOP mode, stop the LCD display in this order to avoid LCD ghosting
//            also set all pins used for the LCD function to output low level to avoid leakage
//*********************************************************************
void LCD_Stop(void)
{
    LCDCR3 = 0x00;                      // Disable SEG_EN[ 7: 0]
    LCDCR4 = 0x00;                      // Disable SEG_EN[15: 8]
    LCDCR5 = 0x00;                      // Disable COM_EN[7:0]    

    LCDCR1_EDSP   = 0;
    POFFCR2_LCDEN = 0;
	
	// set all pins used for the LCD function to output low level to avoid leakage
					
	
	P2DR  &= (~0x18); 
	P4DR  &= (~0xF0); 
	P7DR  &= (~0x7D); 
	P8DR  &= (~0x0C); 
	P9DR  &= (~0x03); 					
	P2CR  |= 0x18; 
	P4CR  |= 0xF0; 
	P7CR  |= 0x7D; 
	P8CR  |= 0x0C; 
	P9CR  |= 0x03; 
}


//*********************************************************************
// name			: LCDBUFxx_InitSeq
// brief		: LCD all on
// note			: 
//*********************************************************************
void LCDBUFxx_InitSeq(void)
{
    LCDBUF04 = 0xFF;
    LCDBUF05 = 0xFF;                    
    LCDBUF06 = 0xFF;
    LCDBUF07 = 0xFF;
    LCDBUF08 = 0xFF;
    LCDBUF09 = 0xFF;
    LCDBUF10 = 0xFF;
    LCDBUF11 = 0xFF;
}



//*********************************************************************
// name			: Dig_Decode(unsigned char digN,unsigned char Num)
// brief		: digital display for GDC03077
// note			:
//*********************************************************************
void Dig_Decode(unsigned char digN,unsigned char Num)
{
	unsigned char NumFGE=0, NumABCD=0, NumMask;

	if( digN/5 )
	{
		NumMask  = 0xf0;
		NumFGE   = DIG_CODE_fge[Num];
		NumABCD  = DIG_CODE_abcd[Num];
	}
	else
	{
		NumMask  = 0x0f;
		NumFGE   = DIG_CODE_fge[Num]  << 4;
		NumABCD  = DIG_CODE_abcd[Num] << 4;
	}

	switch(digN){
		case 1:
			LCDBUF04 &= NumMask;
			LCDBUF05 &= NumMask;
			LCDBUF04 |= NumFGE;
			LCDBUF05 |= NumABCD;
			break;
		case 2:
			LCDBUF06 &= NumMask;
			LCDBUF07 &= NumMask;
			LCDBUF06 |= NumFGE;
			LCDBUF07 |= NumABCD;
			break;
		case 3:
			LCDBUF08 &= NumMask;
			LCDBUF09 &= NumMask;
			LCDBUF08 |= NumFGE;
			LCDBUF09 |= NumABCD;
			break;
		case 4:
			LCDBUF10 &= NumMask;
			LCDBUF11 &= NumMask;
			LCDBUF10 |= NumFGE;
			LCDBUF11 |= NumABCD;
			break;
		case 5:
			LCDBUF04 &= NumMask;
			LCDBUF05 &= NumMask;
			LCDBUF04 |= NumFGE;
			LCDBUF05 |= NumABCD;
			break;
		case 6:
			LCDBUF06 &= NumMask;
			LCDBUF07 &= NumMask;
			LCDBUF06 |= NumFGE;
			LCDBUF07 |= NumABCD;
			break;
		case 7:
			LCDBUF08 &= NumMask;
			LCDBUF09 &= NumMask;
			LCDBUF08 |= NumFGE;
			LCDBUF09 |= NumABCD;
			break;

	}

}

























