//******************************************
// file			: MQ6812_ExtINT
// version		: V1.0
// brief		: ExtINT related functions
// note			: ExtINT related functions are gathered in this subroutine
//******************************************

#include "main.h"




//*********************************************************************
// name			: ExtINT_Init
// brief		: external interrupt initialization
// note			: 
//*********************************************************************
void ExtINT_Init(void)
{
//-------------------------------------------------------
//------ INT 2

    P7CR_P5 = 0;                        // pin initialization
    POFFCR3_INT2EN = 1;                 // enable function   
    EINTCR2_INTES  = 0x00;              // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 

//-------------------------------------------------------
//------ INT 3
/* 
    P7CR_P6 = 0;                        // pin initialization
    POFFCR3_INT3EN = 1;                 // enable function   
    EINTCR3_INTES  = 0x00;              // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 
 */
//-------------------------------------------------------
//------ INT 4
/* 
    P7CR_P7 = 0;                        // pin initialization
    POFFCR3_INT4EN = 1;                 // enable function   
    EINTCR4_INTES  = 0x00;              // interrupt request generation edge  0 : rsing edge  1: falling edge  2 : both edges  3 : H level 
 */

}


//*********************************************************************
// name			: ExtINT_IntEnable
// brief		: enable external interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void ExtINT_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
//-------------------------------------------------------
//------ INT 2

    IL_INT2 = 0;                        // clear interrupt latch
    EI_INT2 = 1;                        // set interrupt enable flag
 
//-------------------------------------------------------
//------ INT 3
/* 
    IL_INT3 = 0;                        // clear interrupt latch
    EI_INT3 = 1;                        // set interrupt enable flag
 */
//-------------------------------------------------------
//------ INT 4
/* 
    IL_INT4 = 0;                        // clear interrupt latch
    EI_INT4 = 1;                        // set interrupt enable flag
 */
//-------------------------------------------------------
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: ExtINT_IntDisable
// brief		: disable external interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void ExtINT_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
//-------------------------------------------------------
//------ INT 2

	EI_INT2 = 0;                        // clear interrupt enable flag
    IL_INT2 = 0;                        // clear interrupt latch    
 
//-------------------------------------------------------
//------ INT 3
/* 
    EI_INT3 = 0;                        // clear interrupt enable flag
	IL_INT3 = 0;                        // clear interrupt latch    
 */
//-------------------------------------------------------
//------ INT 4
/* 
    EI_INT4 = 0;                        // clear interrupt enable flag
	IL_INT4 = 0;                        // clear interrupt latch    
 */ 
//-------------------------------------------------------
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}




//*********************************************************************
// name			: Int2
// brief		: external interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int2(void)
{
    P9DR_P0 = !P9DR_P0;                 // toggle IO    
    NOP;                                // no operation
}


//*********************************************************************
// name			: Int3
// brief		: external interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int3(void)
{
    NOP;                                // no operation
}


//*********************************************************************
// name			: Int4
// brief		: external interrupt service routine
// note			:
//*********************************************************************
void __interrupt Int4(void)
{    
    NOP;                                // no operation
}





























